/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.SumSquareCount;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Unity;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class Variance {
    private Variance() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & Unity<U> & Ordered<U>, U> void compute(T alg, IndexedDataSource<U> storage, U result) {
        long storageSize = storage.size();
        if (storageSize == 0L || storageSize == 1L) {
            alg.zero().call(result);
            return;
        }
        Object avg = alg.construct();
        Object sum = alg.construct();
        Object count = alg.construct();
        Object one = alg.construct();
        ((Unity<U>)alg).unity().call(one);
        SumSquareCount.compute(alg, storage, avg, sum, count);
        ((Addition<U>)alg).subtract().call(count, one, count);
        ((Invertible)alg).divide().call(sum, count, result);
    }
}

