/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Tolerance;

public class WithinTolerance<T extends Algebra<T, U> & Tolerance<W, U>, U, V extends Algebra<V, W>, W>
implements Function2<Boolean, U, U> {
    private final T uAlgebra;
    private final V tolAlgebra;
    private final W tolerance;

    public WithinTolerance(T uAlgebra, V tolAlgebra, W tolerance) {
        this.uAlgebra = uAlgebra;
        this.tolAlgebra = tolAlgebra;
        this.tolerance = tolAlgebra.construct(tolerance);
    }

    public void setTolerance(W tol) {
        this.tolAlgebra.assign().call(tol, this.tolerance);
    }

    public void getTolerance(W tol) {
        this.tolAlgebra.assign().call(this.tolerance, tol);
    }

    @Override
    public Boolean call(U a, U b) {
        return ((Tolerance)this.uAlgebra).within().call(this.tolerance, a, b);
    }
}

