/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm.corrconv;

import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class CorrConv1D {
    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T alg, Function2<Long, Long, Long> indexer, IndexedDataSource<U> filter, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        if (a == b) {
            throw new IllegalArgumentException("source and dest lists must be different");
        }
        if (filter.size() % 2L != 1L) {
            throw new IllegalArgumentException("filter length should be odd");
        }
        Object tmp = alg.construct();
        Object f = alg.construct();
        Object sum = alg.construct();
        long n = filter.size() / 2L;
        for (long x = 0L; x < a.size(); ++x) {
            alg.zero().call(sum);
            for (long i = -n; i <= n; ++i) {
                long idx = indexer.call(x, i);
                a.get(idx, tmp);
                filter.get(i + n, f);
                ((Multiplication)alg).multiply().call(tmp, f, tmp);
                ((Addition<U>)alg).add().call(sum, tmp, sum);
            }
            b.set(x, sum);
        }
    }
}

