/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm.corrconv;

import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Multiplication;

public class ParallelCorrConvND {
    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T alg, int maxPieces, Procedure4<MultiDimDataSource<U>, IntegerIndex, IntegerIndex, IntegerIndex> indexer, MultiDimDataSource<U> filter, MultiDimDataSource<U> a, MultiDimDataSource<U> b) {
        int numD = a.numDimensions();
        if (a == b) {
            throw new IllegalArgumentException("source and dest datasets must be different");
        }
        if (b.numDimensions() != numD) {
            throw new IllegalArgumentException("source and dest have different number of dimensions!");
        }
        if (filter.numDimensions() != numD) {
            throw new IllegalArgumentException("filter and source have different number of dimensions!");
        }
        if (filter.numElements() % 2L != 1L) {
            throw new IllegalArgumentException("filter dimensions should all be odd");
        }
        int index = -1;
        long maxDim = -1L;
        for (int i = 0; i < numD; ++i) {
            long dim = a.dimension(i);
            if (dim <= maxDim) continue;
            index = i;
            maxDim = dim;
        }
        if (maxDim <= 0L) {
            throw new IllegalArgumentException("invalid data dimensions");
        }
        long pieces = maxPieces;
        if (pieces > maxDim) {
            pieces = maxDim;
        }
        if (pieces > Integer.MAX_VALUE) {
            pieces = Integer.MAX_VALUE;
        }
        Thread[] threads = new Thread[(int)pieces];
        long start = 0L;
        int i = 0;
        while ((long)i < pieces) {
            IntegerIndex minPt = new IntegerIndex(numD);
            IntegerIndex maxPt = new IntegerIndex(numD);
            for (int j = 0; j < numD; ++j) {
                maxPt.set(j, a.dimension(j) - 1L);
            }
            long end = (long)i == pieces - 1L ? maxDim - 1L : start + maxDim / pieces - 1L;
            minPt.set(index, start);
            maxPt.set(index, end);
            Computer<T, U> computer = new Computer<T, U>(alg, numD, indexer, filter, a, b, minPt, maxPt);
            threads[i] = new Thread(computer);
            start = end + 1L;
            ++i;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelCorrConvND");
            }
        }
    }

    private static class Computer<T extends Algebra<T, U> & Addition<U>, U>
    implements Runnable {
        private final T alg;
        private final int numD;
        private final MultiDimDataSource<U> filter;
        private final MultiDimDataSource<U> a;
        private final MultiDimDataSource<U> b;
        private final IntegerIndex dataMinPt;
        private final IntegerIndex dataMaxPt;
        private final Procedure4<MultiDimDataSource<U>, IntegerIndex, IntegerIndex, IntegerIndex> indexer;

        public Computer(T alg, int numD, Procedure4<MultiDimDataSource<U>, IntegerIndex, IntegerIndex, IntegerIndex> indexer, MultiDimDataSource<U> filter, MultiDimDataSource<U> a, MultiDimDataSource<U> b, IntegerIndex dataMinPt, IntegerIndex dataMaxPt) {
            this.alg = alg;
            this.numD = numD;
            this.indexer = indexer;
            this.filter = filter;
            this.a = a;
            this.b = b;
            this.dataMinPt = dataMinPt;
            this.dataMaxPt = dataMaxPt;
        }

        @Override
        public void run() {
            IntegerIndex filterMin = new IntegerIndex(this.numD);
            IntegerIndex filterMax = new IntegerIndex(this.numD);
            IntegerIndex dataPoint = new IntegerIndex(this.numD);
            IntegerIndex filterPoint = new IntegerIndex(this.numD);
            IntegerIndex pt = new IntegerIndex(this.numD);
            for (int i = 0; i < this.numD; ++i) {
                filterMin.set(i, 0L);
                filterMax.set(i, this.filter.dimension(i) - 1L);
            }
            Object tmp = this.alg.construct();
            Object f = this.alg.construct();
            Object sum = this.alg.construct();
            SamplingCartesianIntegerGrid dataBounds = new SamplingCartesianIntegerGrid(this.dataMinPt, this.dataMaxPt);
            SamplingCartesianIntegerGrid filterBounds = new SamplingCartesianIntegerGrid(filterMin, filterMax);
            SamplingIterator<IntegerIndex> dataPoints = dataBounds.iterator();
            while (dataPoints.hasNext()) {
                dataPoints.next(dataPoint);
                SamplingIterator<IntegerIndex> filterPoints = filterBounds.iterator();
                this.alg.zero().call(sum);
                while (filterPoints.hasNext()) {
                    filterPoints.next(filterPoint);
                    this.indexer.call(this.filter, dataPoint, filterPoint, pt);
                    this.a.get(pt, tmp);
                    this.filter.get(filterPoint, f);
                    ((Multiplication)this.alg).multiply().call(tmp, f, tmp);
                    ((Addition)this.alg).add().call(sum, tmp, sum);
                }
                this.b.set(dataPoint, sum);
            }
        }
    }
}

