/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm.resample;

import java.math.BigDecimal;
import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.multidim.MultiDimStorage;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;

public class ResampleCubic {
    private ResampleCubic() {
    }

    public static <T extends Algebra<T, U> & Addition<U>, U extends Allocatable<U>> MultiDimDataSource<U> compute(T alg, long[] newDims, MultiDimDataSource<U> input, int maxPieces) {
        int numD = input.numDimensions();
        if (newDims.length != numD) {
            throw new IllegalArgumentException("mismatched dims in Resample");
        }
        Allocatable value = (Allocatable)alg.construct();
        MultiDimDataSource<Allocatable> output = MultiDimStorage.allocate(input.storageType(), newDims, value);
        int index = -1;
        long maxDim = -1L;
        for (int i = 0; i < numD; ++i) {
            long dim = newDims[i];
            if (dim <= maxDim) continue;
            index = i;
            maxDim = dim;
        }
        if (maxDim <= 0L) {
            throw new IllegalArgumentException("invalid data dimensions");
        }
        long pieces = maxPieces;
        if (pieces > maxDim) {
            pieces = maxDim;
        }
        if (pieces > Integer.MAX_VALUE) {
            pieces = Integer.MAX_VALUE;
        }
        Thread[] threads = new Thread[(int)pieces];
        long start = 0L;
        int i = 0;
        while ((long)i < pieces) {
            long[] min = new long[numD];
            long[] max = new long[numD];
            for (int j = 0; j < numD; ++j) {
                max[j] = newDims[j] - 1L;
            }
            long end = (long)i == pieces - 1L ? maxDim - 1L : start + maxDim / pieces - 1L;
            min[index] = start;
            max[index] = end;
            Computer<T, Allocatable> computer = new Computer<T, Allocatable>(alg, newDims, min, max, input, output);
            threads[i] = new Thread(computer);
            start = end + 1L;
            ++i;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelResampler");
            }
        }
        return output;
    }

    private static class Computer<T extends Algebra<T, U> & Addition<U>, U>
    implements Runnable {
        private final int numD;
        private final long[] newDims;
        private final long[] min;
        private final long[] max;
        private final T alg;
        private final MultiDimDataSource<U> input;
        private final MultiDimDataSource<U> output;

        public Computer(T alg, long[] newDims, long[] min, long[] max, MultiDimDataSource<U> input, MultiDimDataSource<U> output) {
            this.numD = newDims.length;
            this.newDims = newDims;
            this.min = min;
            this.max = max;
            this.alg = alg;
            this.input = input;
            this.output = output;
        }

        @Override
        public void run() {
            Object value = this.alg.construct();
            IntegerIndex inputPoint = new IntegerIndex(this.numD);
            IntegerIndex outputPoint = new IntegerIndex(this.numD);
            long[] inputDims = new long[this.numD];
            for (int i = 0; i < this.numD; ++i) {
                inputDims[i] = this.input.dimension(i);
            }
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(this.min, this.max);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            while (iter.hasNext()) {
                iter.next(outputPoint);
                this.computeValue(this.alg, this.input, inputDims, inputPoint, this.newDims, outputPoint, value);
                this.output.set(outputPoint, value);
            }
        }

        private void computeValue(T alg, MultiDimDataSource<U> input, long[] inputDims, IntegerIndex inputPoint, long[] outputDims, IntegerIndex outputPoint, U outVal) {
            int i;
            int numD = inputDims.length;
            BigDecimal[] coords = new BigDecimal[numD];
            for (i = 0; i < numD; ++i) {
                coords[i] = BigDecimal.valueOf(outputPoint.get(i));
                coords[i] = coords[i].divide(BigDecimal.valueOf(outputDims[i] - 1L), HighPrecisionAlgebra.getContext());
                coords[i] = coords[i].multiply(BigDecimal.valueOf(inputDims[i] - 1L));
            }
            for (i = 0; i < numD; ++i) {
                inputPoint.set(i, coords[i].longValue());
            }
            alg.zero().call(outVal);
            this.sum(alg, input, numD, coords, inputPoint, outVal);
            double scale = 1.0 / (double)numD;
            ((ScaleByDouble)alg).scaleByDouble().call(scale, outVal, outVal);
        }

        private void sum(T alg, MultiDimDataSource<U> input, int numD, BigDecimal[] coords, IntegerIndex inputPoint, U outVal) {
            Object tmp = alg.construct();
            for (int d = 0; d < numD; ++d) {
                BigDecimal t = coords[d].remainder(BigDecimal.ONE);
                this.cubicSolution(alg, input, inputPoint, d, t, tmp);
                ((Addition)alg).add().call(outVal, tmp, outVal);
            }
        }

        private void cubicSolution(T alg, MultiDimDataSource<U> input, IntegerIndex inputPoint, int dim, BigDecimal t, U outVal) {
            Object ym1 = alg.construct();
            Object y0 = alg.construct();
            Object y1 = alg.construct();
            Object y2 = alg.construct();
            input.get(inputPoint, y0);
            inputPoint.set(dim, inputPoint.get(dim) + 1L);
            input.get(inputPoint, y1);
            inputPoint.set(dim, inputPoint.get(dim) + 1L);
            input.get(inputPoint, y2);
            inputPoint.set(dim, inputPoint.get(dim) - 3L);
            input.get(inputPoint, ym1);
            inputPoint.set(dim, inputPoint.get(dim) + 1L);
            Object a = alg.construct();
            Object b = alg.construct();
            Object c = alg.construct();
            Object d = alg.construct();
            Object tmp1 = alg.construct();
            Object tmp2 = alg.construct();
            Object tmp3 = alg.construct();
            Object tmp4 = alg.construct();
            alg.assign().call(y0, d);
            ((ScaleByDouble)alg).scaleByDouble().call(-0.5, ym1, tmp1);
            ((ScaleByDouble)alg).scaleByDouble().call(0.5, y1, tmp2);
            ((Addition)alg).add().call(tmp1, tmp2, c);
            alg.assign().call(ym1, tmp1);
            ((ScaleByDouble)alg).scaleByDouble().call(-2.5, y0, tmp2);
            ((ScaleByDouble)alg).scaleByDouble().call(2.0, y1, tmp3);
            ((ScaleByDouble)alg).scaleByDouble().call(-0.5, y2, tmp4);
            ((Addition)alg).add().call(tmp1, tmp2, tmp1);
            ((Addition)alg).add().call(tmp3, tmp4, tmp3);
            ((Addition)alg).add().call(tmp1, tmp3, b);
            ((ScaleByDouble)alg).scaleByDouble().call(-0.5, ym1, tmp1);
            ((ScaleByDouble)alg).scaleByDouble().call(1.5, y0, tmp2);
            ((ScaleByDouble)alg).scaleByDouble().call(-1.5, y1, tmp3);
            ((ScaleByDouble)alg).scaleByDouble().call(0.5, y2, tmp4);
            ((Addition)alg).add().call(tmp1, tmp2, tmp1);
            ((Addition)alg).add().call(tmp3, tmp4, tmp3);
            ((Addition)alg).add().call(tmp1, tmp3, a);
            double x = t.doubleValue();
            alg.assign().call(d, tmp2);
            ((ScaleByDouble)alg).scaleByDouble().call(x, c, tmp1);
            ((Addition)alg).add().call(tmp2, tmp1, tmp2);
            ((ScaleByDouble)alg).scaleByDouble().call(x * x, b, tmp1);
            ((Addition)alg).add().call(tmp2, tmp1, tmp2);
            ((ScaleByDouble)alg).scaleByDouble().call(x * x * x, a, tmp1);
            ((Addition)alg).add().call(tmp2, tmp1, tmp2);
            alg.assign().call(tmp2, outVal);
        }
    }
}

