/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm.resample;

import java.math.BigDecimal;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.multidim.MultiDimStorage;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;

public class ResampleNN {
    private ResampleNN() {
    }

    public static <T extends Algebra<T, U>, U extends Allocatable<U>> MultiDimDataSource<U> compute(T alg, long[] newDims, MultiDimDataSource<U> input, int maxPieces) {
        int numD = input.numDimensions();
        if (newDims.length != numD) {
            throw new IllegalArgumentException("mismatched dims in Resample");
        }
        Allocatable value = (Allocatable)alg.construct();
        MultiDimDataSource<Allocatable> output = MultiDimStorage.allocate(input.storageType(), newDims, value);
        int index = -1;
        long maxDim = -1L;
        for (int i = 0; i < numD; ++i) {
            long dim = newDims[i];
            if (dim <= maxDim) continue;
            index = i;
            maxDim = dim;
        }
        if (maxDim <= 0L) {
            throw new IllegalArgumentException("invalid data dimensions");
        }
        long pieces = maxPieces;
        if (pieces > maxDim) {
            pieces = maxDim;
        }
        if (pieces > Integer.MAX_VALUE) {
            pieces = Integer.MAX_VALUE;
        }
        Thread[] threads = new Thread[(int)pieces];
        long start = 0L;
        int i = 0;
        while ((long)i < pieces) {
            long[] min = new long[numD];
            long[] max = new long[numD];
            for (int j = 0; j < numD; ++j) {
                max[j] = newDims[j] - 1L;
            }
            long end = (long)i == pieces - 1L ? maxDim - 1L : start + maxDim / pieces - 1L;
            min[index] = start;
            max[index] = end;
            Computer<T, Allocatable> computer = new Computer<T, Allocatable>(alg, newDims, min, max, input, output);
            threads[i] = new Thread(computer);
            start = end + 1L;
            ++i;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelResampler");
            }
        }
        return output;
    }

    private static class Computer<T extends Algebra<T, U>, U>
    implements Runnable {
        private final int numD;
        private final long[] newDims;
        private final long[] min;
        private final long[] max;
        private final T alg;
        private final MultiDimDataSource<U> input;
        private final MultiDimDataSource<U> output;

        public Computer(T alg, long[] newDims, long[] min, long[] max, MultiDimDataSource<U> input, MultiDimDataSource<U> output) {
            this.numD = newDims.length;
            this.newDims = newDims;
            this.min = min;
            this.max = max;
            this.alg = alg;
            this.input = input;
            this.output = output;
        }

        @Override
        public void run() {
            Object value = this.alg.construct();
            IntegerIndex inputPoint = new IntegerIndex(this.numD);
            IntegerIndex outputPoint = new IntegerIndex(this.numD);
            long[] inputDims = new long[this.numD];
            for (int i = 0; i < this.numD; ++i) {
                inputDims[i] = this.input.dimension(i);
            }
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(this.min, this.max);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            while (iter.hasNext()) {
                iter.next(outputPoint);
                this.computeValue(this.alg, this.input, inputDims, inputPoint, this.newDims, outputPoint, value);
                this.output.set(outputPoint, value);
            }
        }

        private void computeValue(T alg, MultiDimDataSource<U> input, long[] inputDims, IntegerIndex inputPoint, long[] outputDims, IntegerIndex outputPoint, U outVal) {
            int i;
            BigDecimal[] coords = new BigDecimal[this.numD];
            for (i = 0; i < this.numD; ++i) {
                coords[i] = BigDecimal.valueOf(outputPoint.get(i));
                coords[i] = coords[i].divide(BigDecimal.valueOf(outputDims[i] - 1L), HighPrecisionAlgebra.getContext());
                coords[i] = coords[i].multiply(BigDecimal.valueOf(inputDims[i] - 1L));
                coords[i] = coords[i].add(G.ONE_HALF);
            }
            for (i = 0; i < this.numD; ++i) {
                inputPoint.set(i, coords[i].longValue());
            }
            input.get(inputPoint, outVal);
        }
    }
}

