/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.misc;

import java.util.ArrayList;
import java.util.List;

public class BigList<T> {
    public static long MAX_ITEMS = 4611686014132420609L;
    private List<List<T>> lists;

    public BigList() {
        this.lists = new ArrayList<List<T>>();
    }

    public BigList(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("negative index error");
        }
        if (size > MAX_ITEMS) {
            throw new IllegalArgumentException("BigList can only handle at most " + MAX_ITEMS + " items. " + size + " items were requested.");
        }
        this.lists = new ArrayList<List<T>>();
        while (size > 0L) {
            ArrayList<Object> l;
            if (size / Integer.MAX_VALUE > 0L) {
                l = new ArrayList<Object>(Integer.MAX_VALUE);
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    l.add(null);
                }
            } else {
                int sz = (int)size;
                l = new ArrayList(sz);
                for (int i = 0; i < sz; ++i) {
                    l.add(null);
                }
            }
            this.lists.add(l);
            size -= Integer.MAX_VALUE;
        }
    }

    public long size() {
        if (this.lists.size() == 0) {
            return 0L;
        }
        long size = 1L;
        size *= (long)(this.lists.size() - 1);
        size *= Integer.MAX_VALUE;
        return size += (long)this.lists.get(this.lists.size() - 1).size();
    }

    public T get(long i) {
        if (i < 0L) {
            throw new IllegalArgumentException("negative index error");
        }
        if (i >= MAX_ITEMS) {
            throw new IllegalArgumentException("BigList can only handle " + MAX_ITEMS + " items");
        }
        int list = (int)(i / Integer.MAX_VALUE);
        int offset = (int)(i % Integer.MAX_VALUE);
        List<T> l = this.lists.get(list);
        return l.get(offset);
    }

    public void set(long i, T v) {
        if (i < 0L) {
            throw new IllegalArgumentException("negative index error");
        }
        if (i >= MAX_ITEMS) {
            throw new IllegalArgumentException("BigList can only handle " + MAX_ITEMS + " items");
        }
        int list = (int)(i / Integer.MAX_VALUE);
        int offset = (int)(i % Integer.MAX_VALUE);
        List<T> l = this.lists.get(list);
        l.set(offset, v);
    }

    public void add(T val) {
        if (this.lists.size() == 0 || this.lists.get(this.lists.size() - 1).size() == Integer.MAX_VALUE) {
            this.lists.add(new ArrayList());
        }
        this.lists.get(this.lists.size() - 1).add(val);
    }
}

