/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.misc;

public class RealUtils {
    private RealUtils() {
    }

    public static boolean near(float f1, float f2, float tol) {
        if (tol < 0.0f) {
            throw new IllegalArgumentException("negative tolerance given");
        }
        return Math.abs(f1 - f2) <= tol;
    }

    public static boolean near(double f1, double f2, double tol) {
        if (tol < 0.0) {
            throw new IllegalArgumentException("negative tolerance given");
        }
        return Math.abs(f1 - f2) <= tol;
    }

    public static double distance1d(double x1, double x2) {
        return Math.abs(x2 - x1);
    }

    public static double distance2d(double x1, double y1, double x2, double y2) {
        double dy;
        double dx = Math.abs(x2 - x1);
        double max = Math.max(dx, dy = Math.abs(y2 - y1));
        if (max == 0.0) {
            return 0.0;
        }
        return max * Math.sqrt((dx /= max) * dx + (dy /= max) * dy);
    }

    public static double distance3d(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = Math.abs(x2 - x1);
        double dy = Math.abs(y2 - y1);
        double dz = Math.abs(z2 - z1);
        double max = Math.max(dx, dy);
        if ((max = Math.max(max, dz)) == 0.0) {
            return 0.0;
        }
        return max * Math.sqrt((dx /= max) * dx + (dy /= max) * dy + (dz /= max) * dz);
    }

    public static double distanceNd(double[] p1, double[] p2, double[] scratchSpace) {
        int i;
        if (p1.length != p2.length || p1.length != scratchSpace.length) {
            throw new IllegalArgumentException("mismatched dimenions in distanceNd()");
        }
        if (p1 == scratchSpace || p2 == scratchSpace) {
            throw new IllegalArgumentException("scratch space must be dofferent from inputs");
        }
        if (p1.length == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < p1.length; ++i2) {
            scratchSpace[i2] = Math.abs(p2[i2] - p1[i2]);
        }
        double max = scratchSpace[0];
        for (i = 1; i < p1.length; ++i) {
            max = Math.max(max, scratchSpace[i]);
        }
        if (max == 0.0) {
            return 0.0;
        }
        i = 0;
        while (i < p1.length) {
            int n = i++;
            scratchSpace[n] = scratchSpace[n] / max;
        }
        double sumSq = 0.0;
        for (int i3 = 0; i3 < p1.length; ++i3) {
            sumSq += scratchSpace[i3] * scratchSpace[i3];
        }
        return max * Math.sqrt(sumSq);
    }
}

