/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.multidim;

import java.util.ArrayList;
import java.util.List;
import nom.bdezonia.zorbage.axis.IdentityAxis;
import nom.bdezonia.zorbage.misc.LongUtils;
import nom.bdezonia.zorbage.multidim.IndexUtils;
import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.multidim.PipedDataSource;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class NdData<U>
implements MultiDimDataSource<U> {
    private final List<Procedure2<Long, HighPrecisionMember>> axes;
    private final IndexedDataSource<U> data;
    private final long[] dims;

    public NdData(long[] dims, IndexedDataSource<U> data) {
        if (dims.length == 0) {
            throw new IllegalArgumentException("multidim data source must have 1 or more dimensions");
        }
        if (LongUtils.numElements(dims) != data.size()) {
            throw new IllegalArgumentException("num elements within stated dimensions do not match size of given data source");
        }
        this.dims = dims;
        this.data = data;
        this.axes = new ArrayList<Procedure2<Long, HighPrecisionMember>>();
        for (int i = 0; i < dims.length; ++i) {
            this.axes.add(new IdentityAxis());
        }
    }

    @Override
    public IndexedDataSource<U> rawData() {
        return this.data;
    }

    @Override
    public int numDimensions() {
        return this.dims.length;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative index exception");
        }
        if (d < this.dims.length) {
            return this.dims[d];
        }
        return 1L;
    }

    @Override
    public long numElements() {
        return this.data.size();
    }

    @Override
    public Procedure2<Long, HighPrecisionMember> getAxis(int i) {
        return this.axes.get(i);
    }

    @Override
    public void setAxis(int i, Procedure2<Long, HighPrecisionMember> proc) {
        this.axes.set(i, proc);
    }

    @Override
    public IndexedDataSource<U> piped(int dim, IntegerIndex coord) {
        return new PipedDataSource(this, dim, coord);
    }

    @Override
    public void set(IntegerIndex index, U v) {
        long idx = IndexUtils.indexToLong(this.dims, index);
        this.data.set(idx, v);
    }

    @Override
    public void setSafe(IntegerIndex index, U v) {
        if (this.oob(index)) {
            throw new IllegalArgumentException("index out of bounds of multidim dimensions");
        }
        this.set(index, v);
    }

    @Override
    public void get(IntegerIndex index, U v) {
        long idx = IndexUtils.indexToLong(this.dims, index);
        this.data.get(idx, v);
    }

    @Override
    public void getSafe(IntegerIndex index, U v) {
        if (this.oob(index)) {
            throw new IllegalArgumentException("index out of bounds of multidim dimensions");
        }
        this.get(index, v);
    }

    @Override
    public boolean oob(IntegerIndex index) {
        if (index.numDimensions() != this.numDimensions()) {
            throw new IllegalArgumentException("index dimensionality not the same as multidim dimensions");
        }
        for (int i = 0; i < index.numDimensions(); ++i) {
            if (index.get(i) >= 0L && index.get(i) < this.dimension(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StorageConstruction storageType() {
        return this.data.storageType();
    }
}

