/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.multidim;

import nom.bdezonia.zorbage.multidim.IndexUtils;
import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.SequencedDataSource;

public class PipedDataSource<U>
implements IndexedDataSource<U> {
    private final MultiDimDataSource<U> d;
    private final int dim;
    private final long[] parentDims;
    private final IntegerIndex coords;
    private final IndexedDataSource<U> data;

    public PipedDataSource(MultiDimDataSource<U> d, int dim, IntegerIndex coords) {
        int i;
        if (coords.numDimensions() != d.numDimensions()) {
            throw new IllegalArgumentException("coordinate does not match dimensionality of multidim data");
        }
        if (dim < 0 || dim >= coords.numDimensions()) {
            throw new IllegalArgumentException("ranging dim is not within dimensionality of multidim data");
        }
        for (i = 0; i < coords.numDimensions(); ++i) {
            if (i == dim || coords.get(i) >= 0L && coords.get(i) < d.dimension(i)) continue;
            throw new IllegalArgumentException("coordinate is outside bounds of multidim data");
        }
        this.d = d;
        this.dim = dim;
        this.coords = new IntegerIndex(coords.numDimensions());
        for (i = 0; i < coords.numDimensions(); ++i) {
            this.coords.set(i, coords.get(i));
        }
        this.parentDims = new long[d.numDimensions()];
        for (i = 0; i < d.numDimensions(); ++i) {
            this.parentDims[i] = d.dimension(i);
        }
        this.data = this.findSubset();
    }

    @Override
    public PipedDataSource<U> duplicate() {
        return new PipedDataSource<U>(this.d, this.dim, this.coords);
    }

    @Override
    public void set(long index, U value) {
        this.data.set(index, value);
    }

    @Override
    public void get(long index, U value) {
        this.data.get(index, value);
    }

    @Override
    public long size() {
        return this.data.size();
    }

    private IndexedDataSource<U> findSubset() {
        IntegerIndex start = new IntegerIndex(this.coords.numDimensions());
        IntegerIndex stop = new IntegerIndex(this.coords.numDimensions());
        for (int i = 0; i < this.coords.numDimensions(); ++i) {
            start.set(i, this.coords.get(i));
            stop.set(i, this.coords.get(i));
        }
        start.set(this.dim, 0L);
        stop.set(this.dim, this.d.dimension(this.dim) - 1L);
        long count = this.d.dimension(this.dim);
        long offset = IndexUtils.indexToLong(this.parentDims, start);
        long stride = count <= 1L ? 1L : (IndexUtils.indexToLong(this.parentDims, stop) - offset) / (count - 1L);
        return new SequencedDataSource(this.d.rawData(), offset, stride, count);
    }

    @Override
    public StorageConstruction storageType() {
        return this.d.storageType();
    }
}

