/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.multidim;

import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ProcedurePaddedMultiDimDataSource<T extends Algebra<T, U>, U>
implements MultiDimDataSource<U> {
    private final T algebra;
    private final MultiDimDataSource<U> md;
    private final Procedure2<IntegerIndex, U> proc;
    private final ThreadLocal<U> tmp;

    public ProcedurePaddedMultiDimDataSource(T alg, MultiDimDataSource<U> md, Procedure2<IntegerIndex, U> proc) {
        this.algebra = alg;
        this.md = md;
        this.proc = proc;
        this.tmp = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return ProcedurePaddedMultiDimDataSource.this.algebra.construct();
            }
        };
    }

    @Override
    public IndexedDataSource<U> rawData() {
        return this.md.rawData();
    }

    @Override
    public int numDimensions() {
        return this.md.numDimensions();
    }

    @Override
    public long dimension(int d) {
        return this.md.dimension(d);
    }

    @Override
    public long numElements() {
        return this.md.numElements();
    }

    @Override
    public Procedure2<Long, HighPrecisionMember> getAxis(int i) {
        return this.md.getAxis(i);
    }

    @Override
    public void setAxis(int i, Procedure2<Long, HighPrecisionMember> proc) {
        this.md.setAxis(i, proc);
    }

    @Override
    public IndexedDataSource<U> piped(int dim, IntegerIndex coord) {
        return this.md.piped(dim, coord);
    }

    @Override
    public void set(IntegerIndex index, U v) {
        if (this.md.oob(index)) {
            U t = this.tmp.get();
            this.proc.call(index, t);
            if (!this.algebra.isEqual().call(t, v).booleanValue()) {
                throw new IllegalArgumentException("Cannot set out of bounds value in conflict with out of bounds procedure");
            }
        } else {
            this.md.set(index, v);
        }
    }

    @Override
    public void get(IntegerIndex index, U v) {
        if (this.md.oob(index)) {
            this.proc.call(index, v);
        } else {
            this.md.get(index, v);
        }
    }

    @Override
    public void setSafe(IntegerIndex index, U v) {
        this.md.setSafe(index, v);
    }

    @Override
    public void getSafe(IntegerIndex index, U v) {
        this.md.getSafe(index, v);
    }

    @Override
    public boolean oob(IntegerIndex index) {
        return this.md.oob(index);
    }

    @Override
    public StorageConstruction storageType() {
        return this.md.storageType();
    }
}

