/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.oob.nd;

import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.sampling.IntegerIndex;

public class MirrorNdOOB<U>
implements Procedure2<IntegerIndex, U> {
    private final MultiDimDataSource<U> ds;
    private final ThreadLocal<IntegerIndex> coord;

    public MirrorNdOOB(MultiDimDataSource<U> d) {
        this.ds = d;
        this.coord = new ThreadLocal<IntegerIndex>(){

            @Override
            protected IntegerIndex initialValue() {
                return new IntegerIndex(MirrorNdOOB.this.ds.numDimensions());
            }
        };
    }

    @Override
    public void call(IntegerIndex index, U value) {
        if (index.numDimensions() != this.ds.numDimensions()) {
            throw new IllegalArgumentException("index does not have same num dims as dataset");
        }
        IntegerIndex tmp = this.coord.get();
        boolean oob = false;
        for (int i = 0; i < this.ds.numDimensions(); ++i) {
            long offset;
            long idx;
            long val = index.get(i);
            if (val < 0L) {
                idx = (-val - 1L) / this.ds.dimension(i);
                offset = (-val - 1L) % this.ds.dimension(i);
                if (idx % 2L == 0L) {
                    tmp.set(i, offset);
                } else {
                    tmp.set(i, this.ds.dimension(i) - 1L - offset);
                }
                oob = true;
                continue;
            }
            if (val >= this.ds.dimension(i)) {
                idx = val / this.ds.dimension(i);
                offset = val % this.ds.dimension(i);
                if (idx % 2L == 0L) {
                    tmp.set(i, offset);
                } else {
                    tmp.set(i, this.ds.dimension(i) - 1L - offset);
                }
                oob = true;
                continue;
            }
            tmp.set(i, val);
        }
        if (!oob) {
            throw new IllegalArgumentException("OOB method called with in bounds index");
        }
        this.ds.get(tmp, value);
    }
}

