/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.procedure.impl;

import nom.bdezonia.zorbage.procedure.Procedure;
import nom.bdezonia.zorbage.procedure.impl.Asinh;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;

public class AsinhL<T extends Algebra<T, U> & InverseHyperbolic<U>, U>
implements Procedure<U> {
    private final Procedure<U> ancestor;
    private final Asinh<T, U> lowerProc;
    private final T algebra;
    private final ThreadLocal<U> tmp;

    public AsinhL(T alg, Procedure<U> ancestor) {
        this.algebra = alg;
        this.ancestor = ancestor;
        this.lowerProc = new Asinh(this.algebra);
        this.tmp = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return AsinhL.this.algebra.construct();
            }
        };
    }

    @Override
    public void call(U result, U ... inputs) {
        U u = this.tmp.get();
        this.ancestor.call(u, inputs);
        this.lowerProc.call(u, result);
    }
}

