/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.procedure.impl;

import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class Kronecker<T extends Algebra<T, U> & Unity<U>, U>
implements Procedure3<long[], long[], U> {
    private final T algebra;
    private final U zero;
    private final U one;

    public Kronecker(T algebra) {
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.one = algebra.construct();
        ((Unity)algebra).unity().call(this.one);
    }

    @Override
    public void call(long[] a, long[] b, U c) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("index length mismatch");
        }
        if (a.length == 0) {
            this.algebra.assign().call(this.zero, c);
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            this.algebra.assign().call(this.zero, c);
            return;
        }
        this.algebra.assign().call(this.one, c);
    }
}

