/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.procedure.impl;

import nom.bdezonia.zorbage.procedure.Procedure;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;

public class MinInputs<T extends Algebra<T, U> & Ordered<U>, U>
implements Procedure<U> {
    private final T algebra;

    public MinInputs(T algebra) {
        this.algebra = algebra;
    }

    @Override
    public void call(U result, U ... inputs) {
        if (inputs.length == 0) {
            throw new IllegalArgumentException("no inputs given");
        }
        Object min = this.algebra.construct();
        this.algebra.assign().call(inputs[0], min);
        for (int i = 1; i < inputs.length; ++i) {
            if (!((Ordered)this.algebra).isLess().call(inputs[i], min).booleanValue()) continue;
            this.algebra.assign().call(inputs[i], min);
        }
        this.algebra.assign().call(min, result);
    }
}

