/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.procedure.impl;

import nom.bdezonia.zorbage.procedure.Procedure;
import nom.bdezonia.zorbage.procedure.impl.Mod;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.IntegralDivision;

public class ModL<T extends Algebra<T, U> & IntegralDivision<U>, U>
implements Procedure<U> {
    private final Procedure<U> ancestor1;
    private final Procedure<U> ancestor2;
    private final Mod<T, U> lowerProc;
    private final T algebra;
    private final ThreadLocal<U> tmp1;
    private final ThreadLocal<U> tmp2;

    public ModL(T alg, Procedure<U> ancestor1, Procedure<U> ancestor2) {
        this.algebra = alg;
        this.ancestor1 = ancestor1;
        this.ancestor2 = ancestor2;
        this.lowerProc = new Mod(this.algebra);
        this.tmp1 = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return ModL.this.algebra.construct();
            }
        };
        this.tmp2 = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return ModL.this.algebra.construct();
            }
        };
    }

    @Override
    public void call(U result, U ... inputs) {
        U u1 = this.tmp1.get();
        U u2 = this.tmp2.get();
        this.ancestor1.call(u1, inputs);
        this.ancestor2.call(u2, inputs);
        this.lowerProc.call(u1, u2, result);
    }
}

