/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.procedure.impl;

import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class Step<T extends Algebra<T, U> & Ordered<U>, U>
implements Procedure2<U, U> {
    private final T algebra;
    private final U zero;
    private final U one;
    private final U h0;

    public Step(T algebra, U h0) {
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.h0 = algebra.construct();
        this.one = algebra.construct();
        ((Unity)algebra).unity().call(this.one);
        algebra.assign().call(h0, this.h0);
        if (((Ordered)algebra).isLess().call(h0, this.zero).booleanValue() || ((Ordered)algebra).isGreater().call(h0, this.one).booleanValue()) {
            throw new IllegalArgumentException("step: h0 out of sensible range");
        }
    }

    @Override
    public void call(U a, U b) {
        int s = ((Ordered)this.algebra).signum().call(a);
        if (s < 0) {
            this.algebra.assign().call(this.zero, b);
        } else if (s > 0) {
            this.algebra.assign().call(this.one, b);
        } else {
            this.algebra.assign().call(this.h0, b);
        }
    }
}

