/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.procedure.impl;

import nom.bdezonia.zorbage.procedure.Procedure;
import nom.bdezonia.zorbage.type.algebra.Algebra;

public class VariableConstantL<T extends Algebra<T, U>, U>
implements Procedure<U> {
    private final T algebra;
    private final int index;

    public VariableConstantL(T algebra, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index exception");
        }
        this.algebra = algebra;
        this.index = index;
    }

    @Override
    public void call(U result, U ... inputs) {
        if (this.index >= inputs.length) {
            throw new IllegalArgumentException("unspecified variable #" + this.index);
        }
        this.algebra.assign().call(inputs[this.index], result);
    }
}

