/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.procedure.impl.parse;

import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.procedure.Procedure;
import nom.bdezonia.zorbage.procedure.impl.AbsL;
import nom.bdezonia.zorbage.procedure.impl.AcosL;
import nom.bdezonia.zorbage.procedure.impl.AcoshL;
import nom.bdezonia.zorbage.procedure.impl.AddL;
import nom.bdezonia.zorbage.procedure.impl.AsinL;
import nom.bdezonia.zorbage.procedure.impl.AsinhL;
import nom.bdezonia.zorbage.procedure.impl.AtanL;
import nom.bdezonia.zorbage.procedure.impl.AtanhL;
import nom.bdezonia.zorbage.procedure.impl.CbrtL;
import nom.bdezonia.zorbage.procedure.impl.ConstantL;
import nom.bdezonia.zorbage.procedure.impl.CosL;
import nom.bdezonia.zorbage.procedure.impl.CoshL;
import nom.bdezonia.zorbage.procedure.impl.DivL;
import nom.bdezonia.zorbage.procedure.impl.DivideL;
import nom.bdezonia.zorbage.procedure.impl.ExpL;
import nom.bdezonia.zorbage.procedure.impl.LogL;
import nom.bdezonia.zorbage.procedure.impl.MaxL;
import nom.bdezonia.zorbage.procedure.impl.MinL;
import nom.bdezonia.zorbage.procedure.impl.ModL;
import nom.bdezonia.zorbage.procedure.impl.MultiplyL;
import nom.bdezonia.zorbage.procedure.impl.NegateL;
import nom.bdezonia.zorbage.procedure.impl.PowL;
import nom.bdezonia.zorbage.procedure.impl.RandL;
import nom.bdezonia.zorbage.procedure.impl.SinL;
import nom.bdezonia.zorbage.procedure.impl.SincL;
import nom.bdezonia.zorbage.procedure.impl.SinchL;
import nom.bdezonia.zorbage.procedure.impl.SinchpiL;
import nom.bdezonia.zorbage.procedure.impl.SincpiL;
import nom.bdezonia.zorbage.procedure.impl.SinhL;
import nom.bdezonia.zorbage.procedure.impl.SqrtL;
import nom.bdezonia.zorbage.procedure.impl.SubtractL;
import nom.bdezonia.zorbage.procedure.impl.TanL;
import nom.bdezonia.zorbage.procedure.impl.TanhL;
import nom.bdezonia.zorbage.procedure.impl.VariableConstantL;
import nom.bdezonia.zorbage.procedure.impl.ZeroL;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.algebra.AbsoluteValue;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;
import nom.bdezonia.zorbage.type.algebra.InverseTrigonometric;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.ModularDivision;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.OctonionConstants;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;

public class EquationParser<T extends Algebra<T, U>, U> {
    public Tuple2<String, Procedure<U>> parse(T algebra, String string) {
        Tuple2<String, BigList<Token>> lexResult = new Lexer().lex(algebra, string);
        if (lexResult.a() == null) {
            return new Parser().parse(algebra, lexResult.b());
        }
        Tuple2<Object, Object> tuple = new Tuple2<Object, Object>(null, null);
        tuple.setA(lexResult.a());
        tuple.setB(new ZeroL(algebra));
        return tuple;
    }

    private boolean match(Class<?> tokClass, BigList<Token> tokens, long pos) {
        if (pos >= tokens.size()) {
            return false;
        }
        return tokens.get(pos).getClass() == tokClass;
    }

    private ParseStatus syntaxError(long tokenNumber, BigList<Token> tokens, String errMsg) {
        ParseStatus status = new ParseStatus();
        status.tokenNumber = tokenNumber;
        if (tokenNumber < tokens.size()) {
            Token token = tokens.get(tokenNumber);
            status.errMsg = "Syntax error with token (" + token.getText() + ") near column " + token.getStart() + ": " + errMsg;
        } else {
            Token token = tokens.get(tokenNumber - 1L);
            status.errMsg = "Unexpected end of input after token (" + token.getText() + ") near column " + token.getStart() + ": context - " + errMsg;
        }
        return status;
    }

    private ParseStatus equation(T algebra, BigList<Token> tokens, long pos) {
        ParseStatus status1 = this.term(algebra, tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        ParseStatus status2 = status1;
        if (this.match(Plus.class, tokens, status1.tokenNumber)) {
            if (!(algebra instanceof Addition)) {
                status2.errMsg = "Parse error near '+' token: addition not defined for given algebra";
            } else {
                status2 = this.equation(algebra, tokens, status1.tokenNumber + 1L);
            }
            if (status2.errMsg != null) {
                return status2;
            }
            status2.procedure = new AddL(algebra, status1.procedure, status2.procedure);
        } else if (this.match(Minus.class, tokens, status1.tokenNumber)) {
            if (!(algebra instanceof Addition)) {
                status2.errMsg = "Parse error near '-' token: subtraction not defined for given algebra";
            } else {
                status2 = this.equation(algebra, tokens, status1.tokenNumber + 1L);
            }
            if (status2.errMsg != null) {
                return status2;
            }
            status2.procedure = new SubtractL(algebra, status1.procedure, status2.procedure);
        }
        return status2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ParseStatus term(T algebra, BigList<Token> tokens, long pos) {
        ParseStatus status1 = this.factor(algebra, tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        ParseStatus status2 = status1;
        if (this.match(Times.class, tokens, status1.tokenNumber)) {
            if (!(algebra instanceof Multiplication)) {
                status2.errMsg = "Parse error near '*' token: multiplication not defined for given algebra";
            } else {
                status2 = this.term(algebra, tokens, status1.tokenNumber + 1L);
            }
            if (status2.errMsg != null) {
                return status2;
            }
            status2.procedure = new MultiplyL(algebra, status1.procedure, status2.procedure);
            return status2;
        }
        if (this.match(Divide.class, tokens, status1.tokenNumber)) {
            if (!(algebra instanceof Invertible) && !(algebra instanceof ModularDivision)) {
                status2.errMsg = "Parse error near '/' token: division not defined for given algebra";
                return status2;
            }
            status2 = this.term(algebra, tokens, status1.tokenNumber + 1L);
            if (status2.errMsg != null) {
                return status2;
            }
            if (algebra instanceof Invertible) {
                status2.procedure = new DivideL(algebra, status1.procedure, status2.procedure);
                return status2;
            }
            status2.procedure = new DivL(algebra, status1.procedure, status2.procedure);
            return status2;
        }
        if (!this.match(Mod.class, tokens, status1.tokenNumber)) return status2;
        if (!(algebra instanceof ModularDivision)) {
            status2.errMsg = "Parse error near '%' token: modular division not defined for given algebra";
        } else {
            status2 = this.term(algebra, tokens, status1.tokenNumber + 1L);
        }
        if (status2.errMsg != null) {
            return status2;
        }
        status2.procedure = new ModL(algebra, status1.procedure, status2.procedure);
        return status2;
    }

    private ParseStatus factor(T algebra, BigList<Token> tokens, long pos) {
        ParseStatus status1 = this.signedAtom(algebra, tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        ParseStatus status2 = status1;
        if (this.match(Power.class, tokens, status1.tokenNumber)) {
            if (!(algebra instanceof nom.bdezonia.zorbage.type.algebra.Power)) {
                status2.errMsg = "Parse error near '^' token: exponentiation not defined for given algebra";
            } else {
                status2 = this.factor(algebra, tokens, status1.tokenNumber + 1L);
            }
            if (status2.errMsg != null) {
                return status2;
            }
            status2.procedure = new PowL(algebra, status1.procedure, status2.procedure);
        }
        return status2;
    }

    private ParseStatus signedAtom(T algebra, BigList<Token> tokens, long pos) {
        if (this.match(Plus.class, tokens, pos)) {
            return this.atom(algebra, tokens, pos + 1L);
        }
        if (this.match(Minus.class, tokens, pos)) {
            ParseStatus status = this.atom(algebra, tokens, pos + 1L);
            if (status.errMsg != null) {
                return status;
            }
            status.procedure = new NegateL(algebra, status.procedure);
            return status;
        }
        return this.atom(algebra, tokens, pos);
    }

    private ParseStatus atom(T algebra, BigList<Token> tokens, long pos) {
        if (this.match(Index.class, tokens, pos)) {
            Index idx = (Index)tokens.get(pos);
            int index = idx.getNumber();
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 1L;
            status.procedure = new VariableConstantL(algebra, index);
            return status;
        }
        if (this.match(FunctionName.class, tokens, pos)) {
            FunctionName funcCall = (FunctionName)tokens.get(pos);
            if (funcCall.getText() == "rand") {
                ParseStatus status = new ParseStatus();
                if (!(algebra instanceof Random)) {
                    status.errMsg = "Parse error near 'rand' token: randomize not defined for given algebra";
                } else {
                    status.procedure = this.createFunction(algebra, funcCall.getText(), null);
                }
                status.tokenNumber = pos + 1L;
                return status;
            }
            if (!this.match(OpenParen.class, tokens, pos + 1L)) {
                return this.syntaxError(pos + 1L, tokens, "Function call definition expected a '('");
            }
            ParseStatus status = this.equation(algebra, tokens, pos + 2L);
            if (status.errMsg != null) {
                return status;
            }
            if (!this.match(CloseParen.class, tokens, status.tokenNumber)) {
                return this.syntaxError(status.tokenNumber, tokens, "Function call definition expected a ')'");
            }
            status.procedure = this.createFunction(algebra, funcCall.getText(), status.procedure);
            ++status.tokenNumber;
            return status;
        }
        if (this.match(OpenParen.class, tokens, pos)) {
            ParseStatus status = this.equation(algebra, tokens, pos + 1L);
            if (status.errMsg != null) {
                return status;
            }
            if (!this.match(CloseParen.class, tokens, status.tokenNumber)) {
                return this.syntaxError(status.tokenNumber, tokens, "Expected a ')'");
            }
            ++status.tokenNumber;
            return status;
        }
        if (this.match(Min.class, tokens, pos) || this.match(Max.class, tokens, pos)) {
            if (!(algebra instanceof Ordered)) {
                return this.syntaxError(pos, tokens, "'min' or 'max' token: ordering is not defined for given algebra");
            }
            if (!this.match(OpenParen.class, tokens, pos + 1L)) {
                return this.syntaxError(pos + 1L, tokens, "Expected a '('.");
            }
            ParseStatus status1 = this.equation(algebra, tokens, pos + 2L);
            if (status1.errMsg != null) {
                return status1;
            }
            if (!this.match(Comma.class, tokens, status1.tokenNumber)) {
                return this.syntaxError(status1.tokenNumber, tokens, "Expected a ','.");
            }
            ParseStatus status2 = this.equation(algebra, tokens, status1.tokenNumber + 1L);
            if (status2.errMsg != null) {
                return status2;
            }
            if (!this.match(CloseParen.class, tokens, status2.tokenNumber)) {
                return this.syntaxError(status2.tokenNumber, tokens, "Expected a ')'.");
            }
            ParseStatus status = new ParseStatus();
            status.tokenNumber = status2.tokenNumber + 1L;
            status.procedure = this.match(Min.class, tokens, pos) ? new MinL(algebra, status1.procedure, status2.procedure) : new MaxL(algebra, status1.procedure, status2.procedure);
            return status;
        }
        return this.num(algebra, tokens, pos);
    }

    private ParseStatus num(T algebra, BigList<Token> tokens, long pos) {
        try {
            Numeric tok = (Numeric)tokens.get(pos);
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 1L;
            status.procedure = new ConstantL<T, Object>(algebra, tok.value);
            return status;
        }
        catch (Exception e) {
            return this.syntaxError(pos, tokens, "Expected something numeric.");
        }
    }

    private Procedure<U> createFunction(T algebra, String funcName, Procedure<U> ancestor1) {
        if (algebra instanceof InverseTrigonometric) {
            if (funcName.equals("acos")) {
                return new AcosL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("asin")) {
                return new AsinL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("atan")) {
                return new AtanL<T, U>(algebra, ancestor1);
            }
        }
        if (algebra instanceof InverseHyperbolic) {
            if (funcName.equals("acosh")) {
                return new AcoshL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("asinh")) {
                return new AsinhL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("atanh")) {
                return new AtanhL<T, U>(algebra, ancestor1);
            }
        }
        if (algebra instanceof Roots) {
            if (funcName.equals("cbrt")) {
                return new CbrtL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("sqrt")) {
                return new SqrtL<T, U>(algebra, ancestor1);
            }
        }
        if (algebra instanceof Trigonometric) {
            if (funcName.equals("cos")) {
                return new CosL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("sin")) {
                return new SinL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("tan")) {
                return new TanL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("sinc")) {
                return new SincL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("sincpi")) {
                return new SincpiL<T, U>(algebra, ancestor1);
            }
        }
        if (algebra instanceof Hyperbolic) {
            if (funcName.equals("cosh")) {
                return new CoshL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("sinh")) {
                return new SinhL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("tanh")) {
                return new TanhL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("sinch")) {
                return new SinchL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("sinchpi")) {
                return new SinchpiL<T, U>(algebra, ancestor1);
            }
        }
        if (algebra instanceof Exponential) {
            if (funcName.equals("exp")) {
                return new ExpL<T, U>(algebra, ancestor1);
            }
            if (funcName.equals("log")) {
                return new LogL<T, U>(algebra, ancestor1);
            }
        }
        if (algebra instanceof Random && funcName.equals("rand")) {
            return new RandL(algebra);
        }
        if (algebra instanceof AbsoluteValue && funcName.equals("abs")) {
            return new AbsL<T, U>(algebra, ancestor1);
        }
        throw new IllegalArgumentException("Unsupported function type : " + funcName + " for given algebra");
    }

    private class ParseStatus {
        String errMsg;
        long tokenNumber;
        Procedure<U> procedure;

        private ParseStatus() {
        }
    }

    private class Parser {
        private Parser() {
        }

        Tuple2<String, Procedure<U>> parse(T algebra, BigList<Token> tokens) {
            ParseStatus result = EquationParser.this.equation(algebra, tokens, 0L);
            Tuple2<Object, Object> retVal = new Tuple2<Object, Object>(null, null);
            if (result.errMsg != null) {
                retVal.setA(result.errMsg);
                retVal.setB(new ZeroL(algebra));
            } else {
                retVal.setA(null);
                retVal.setB(result.procedure);
            }
            return retVal;
        }
    }

    private class Lexer {
        private Lexer() {
        }

        Tuple2<String, BigList<Token>> lex(T alg, String str) {
            Tuple2<Object, Object> result = new Tuple2<Object, Object>(null, null);
            BigList<Token> toks = new BigList<Token>();
            result.setA(null);
            result.setB(toks);
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                if (ch == '(') {
                    toks.add(new OpenParen(i));
                    continue;
                }
                if (ch == ')') {
                    toks.add(new CloseParen(i));
                    continue;
                }
                if (ch == '+') {
                    toks.add(new Plus(i));
                    continue;
                }
                if (ch == '-') {
                    toks.add(new Minus(i));
                    continue;
                }
                if (ch == '*') {
                    toks.add(new Times(i));
                    continue;
                }
                if (ch == '/') {
                    toks.add(new Divide(i));
                    continue;
                }
                if (ch == '%') {
                    toks.add(new Mod(i));
                    continue;
                }
                if (ch == '^') {
                    toks.add(new Power(i));
                    continue;
                }
                if (ch == ',') {
                    toks.add(new Comma(i));
                    continue;
                }
                if (ch == '$') {
                    int p;
                    int num = 0;
                    for (p = i + 1; p < str.length() && Character.isDigit(str.charAt(p)); ++p) {
                        num *= 10;
                        num += str.charAt(p) - 48;
                    }
                    if (p == i + 1) {
                        result.setA(("Lex err near position " + p + ": $ sign should be followed by one or more digits"));
                        return result;
                    }
                    toks.add(new Index(i, num));
                    i = p - 1;
                    continue;
                }
                if (ch == '[') {
                    StringBuilder sb = new StringBuilder();
                    int level = 1;
                    int p = i + 1;
                    sb.append(ch);
                    while (level > 0) {
                        if (p >= str.length()) {
                            result.setA(("Lex err near position " + p + ": unterminated multidim numeric type"));
                            return result;
                        }
                        ch = str.charAt(p);
                        if (ch == '[') {
                            ++level;
                        }
                        if (ch == ']') {
                            --level;
                        }
                        sb.append(ch);
                        ++p;
                        if (level != 0) continue;
                    }
                    String value = alg.construct((String)sb.toString());
                    toks.add(new Numeric(i, value));
                    i = p - 1;
                    continue;
                }
                if (ch == '{') {
                    StringBuilder sb = new StringBuilder();
                    int p = i + 1;
                    sb.append(ch);
                    while (ch != '}') {
                        if (p >= str.length()) {
                            result.setA(("Lex err near position " + p + ": unterminated multidim numeric type"));
                            return result;
                        }
                        ch = str.charAt(p);
                        sb.append(ch);
                        ++p;
                    }
                    String value = alg.construct((String)sb.toString());
                    toks.add(new Numeric(i, value));
                    i = p - 1;
                    continue;
                }
                if (Character.isDigit(ch) || ch == '.') {
                    int p;
                    StringBuilder sb = new StringBuilder();
                    sb.append(ch);
                    for (p = i + 1; p < str.length(); ++p) {
                        ch = str.charAt(p);
                        if (Character.isDigit(ch)) {
                            sb.append(ch);
                            continue;
                        }
                        if (ch == '.') {
                            if (sb.toString().indexOf(46) == -1) {
                                sb.append(ch);
                                continue;
                            }
                            --p;
                            break;
                        }
                        if (ch == 'e') {
                            if (sb.toString().indexOf(101) == -1) {
                                sb.append(ch);
                                continue;
                            }
                            --p;
                            break;
                        }
                        if (ch == '+' || ch == '-') {
                            int epos = sb.toString().indexOf(101);
                            String tmp = sb.toString();
                            if (epos > -1 && tmp.charAt(tmp.length() - 1) == 'e') {
                                sb.append(ch);
                                continue;
                            }
                            --p;
                            break;
                        }
                        --p;
                        break;
                    }
                    String value = alg.construct((String)sb.toString());
                    toks.add(new Numeric(i, value));
                    i = p - 1;
                    continue;
                }
                if (ch == 'E') {
                    Object value = alg.construct();
                    if (!(alg instanceof RealConstants)) {
                        result.setA(("Lex err near position " + i + ": E not defined for given algebra"));
                        return result;
                    }
                    RealConstants a = (RealConstants)alg;
                    a.E().call(value);
                    toks.add(new Numeric(i, value));
                    continue;
                }
                if (ch == 'L') {
                    Object value = alg.construct();
                    if (!(alg instanceof OctonionConstants)) {
                        result.setA(("Lex err near position " + i + ": L not defined for given algebra"));
                        return result;
                    }
                    OctonionConstants a = (OctonionConstants)alg;
                    a.L().call(value);
                    toks.add(new Numeric(i, value));
                    continue;
                }
                if (ch == 'I') {
                    if (this.nextFew(str, i, "I0")) {
                        Object value = alg.construct();
                        if (!(alg instanceof OctonionConstants)) {
                            result.setA(("Lex err near position " + i + ": I0 not defined for given algebra"));
                            return result;
                        }
                        OctonionConstants a = (OctonionConstants)alg;
                        a.I0().call(value);
                        toks.add(new Numeric(i, value));
                        ++i;
                        continue;
                    }
                    Object value = alg.construct();
                    if (!(alg instanceof ImaginaryConstants)) {
                        result.setA(("Lex err near position " + i + ": I not defined for given algebra"));
                        return result;
                    }
                    ImaginaryConstants a = (ImaginaryConstants)alg;
                    a.I().call(value);
                    toks.add(new Numeric(i, value));
                    continue;
                }
                if (ch == 'J') {
                    if (this.nextFew(str, i, "J0")) {
                        Object value = alg.construct();
                        if (!(alg instanceof OctonionConstants)) {
                            result.setA(("Lex err near position " + i + ": J0 not defined for given algebra"));
                            return result;
                        }
                        OctonionConstants a = (OctonionConstants)alg;
                        a.J0().call(value);
                        toks.add(new Numeric(i, value));
                        ++i;
                        continue;
                    }
                    Object value = alg.construct();
                    if (!(alg instanceof QuaternionConstants)) {
                        result.setA(("Lex err near position " + i + ": J not defined for given algebra"));
                        return result;
                    }
                    QuaternionConstants a = (QuaternionConstants)alg;
                    a.J().call(value);
                    toks.add(new Numeric(i, value));
                    continue;
                }
                if (ch == 'K') {
                    if (this.nextFew(str, i, "K0")) {
                        Object value = alg.construct();
                        if (!(alg instanceof OctonionConstants)) {
                            result.setA(("Lex err near position " + i + ": K0 not defined for given algebra"));
                            return result;
                        }
                        OctonionConstants a = (OctonionConstants)alg;
                        a.K0().call(value);
                        toks.add(new Numeric(i, value));
                        ++i;
                        continue;
                    }
                    Object value = alg.construct();
                    if (!(alg instanceof QuaternionConstants)) {
                        result.setA(("Lex err near position " + i + ": K not defined for given algebra"));
                        return result;
                    }
                    QuaternionConstants a = (QuaternionConstants)alg;
                    a.K().call(value);
                    toks.add(new Numeric(i, value));
                    continue;
                }
                if (ch == 'G') {
                    if (this.nextFew(str, i, "GAMMA")) {
                        Object value = alg.construct();
                        if (!(alg instanceof RealConstants)) {
                            result.setA(("Lex err near position " + i + ": GAMMA not defined for given algebra"));
                            return result;
                        }
                        RealConstants a = (RealConstants)alg;
                        a.GAMMA().call(value);
                        toks.add(new Numeric(i, value));
                        i += 4;
                        continue;
                    }
                    result.setA(("Lex err near position " + i + ": G char should be followed by AMMA"));
                    return result;
                }
                if (ch == 'P') {
                    if (this.nextFew(str, i, "PHI")) {
                        Object value = alg.construct();
                        if (!(alg instanceof RealConstants)) {
                            result.setA(("Lex err near position " + i + ": PHI not defined for given algebra"));
                            return result;
                        }
                        RealConstants a = (RealConstants)alg;
                        a.PHI().call(value);
                        toks.add(new Numeric(i, value));
                        i += 2;
                        continue;
                    }
                    if (this.nextFew(str, i, "PI")) {
                        Object value = alg.construct();
                        if (!(alg instanceof RealConstants)) {
                            result.setA(("Lex err near position " + i + ": PI not defined for given algebra"));
                            return result;
                        }
                        RealConstants a = (RealConstants)alg;
                        a.PI().call(value);
                        toks.add(new Numeric(i, value));
                        ++i;
                        continue;
                    }
                    result.setA(("Lex err near position " + i + ": P char should be followed by I"));
                    return result;
                }
                if (this.nextFew(str, i, "sinchpi")) {
                    toks.add(new FunctionName(i, "sinchpi"));
                    i += 6;
                    continue;
                }
                if (this.nextFew(str, i, "sincpi")) {
                    toks.add(new FunctionName(i, "sincpi"));
                    i += 5;
                    continue;
                }
                if (this.nextFew(str, i, "sinch")) {
                    toks.add(new FunctionName(i, "sinch"));
                    i += 4;
                    continue;
                }
                if (this.nextFew(str, i, "acosh")) {
                    toks.add(new FunctionName(i, "acosh"));
                    i += 4;
                    continue;
                }
                if (this.nextFew(str, i, "asinh")) {
                    toks.add(new FunctionName(i, "asinh"));
                    i += 4;
                    continue;
                }
                if (this.nextFew(str, i, "atanh")) {
                    toks.add(new FunctionName(i, "atanh"));
                    i += 4;
                    continue;
                }
                if (this.nextFew(str, i, "tmin")) {
                    Object value = alg.construct();
                    if (!(alg instanceof Bounded)) {
                        result.setA(("Lex err near position " + i + ": tmin not defined for given algebra"));
                        return result;
                    }
                    Bounded a = (Bounded)alg;
                    a.minBound().call(value);
                    toks.add(new Numeric(i, value));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "tmax")) {
                    Object value = alg.construct();
                    if (!(alg instanceof Bounded)) {
                        result.setA(("Lex err near position " + i + ": tmax not defined for given algebra"));
                        return result;
                    }
                    Bounded a = (Bounded)alg;
                    a.maxBound().call(value);
                    toks.add(new Numeric(i, value));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "acos")) {
                    toks.add(new FunctionName(i, "acos"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "asin")) {
                    toks.add(new FunctionName(i, "asin"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "atan")) {
                    toks.add(new FunctionName(i, "atan"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "cosh")) {
                    toks.add(new FunctionName(i, "cosh"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "sinh")) {
                    toks.add(new FunctionName(i, "sinh"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "tanh")) {
                    toks.add(new FunctionName(i, "tanh"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "cbrt")) {
                    toks.add(new FunctionName(i, "cbrt"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "sqrt")) {
                    toks.add(new FunctionName(i, "sqrt"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "rand")) {
                    toks.add(new FunctionName(i, "rand"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "sinc")) {
                    toks.add(new FunctionName(i, "sinc"));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "zero")) {
                    Object value = alg.construct();
                    toks.add(new Numeric(i, value));
                    i += 3;
                    continue;
                }
                if (this.nextFew(str, i, "min")) {
                    toks.add(new Min(i));
                    i += 2;
                    continue;
                }
                if (this.nextFew(str, i, "max")) {
                    toks.add(new Max(i));
                    i += 2;
                    continue;
                }
                if (this.nextFew(str, i, "cos")) {
                    toks.add(new FunctionName(i, "cos"));
                    i += 2;
                    continue;
                }
                if (this.nextFew(str, i, "sin")) {
                    toks.add(new FunctionName(i, "sin"));
                    i += 2;
                    continue;
                }
                if (this.nextFew(str, i, "tan")) {
                    toks.add(new FunctionName(i, "tan"));
                    i += 2;
                    continue;
                }
                if (this.nextFew(str, i, "exp")) {
                    toks.add(new FunctionName(i, "exp"));
                    i += 2;
                    continue;
                }
                if (this.nextFew(str, i, "log")) {
                    toks.add(new FunctionName(i, "log"));
                    i += 2;
                    continue;
                }
                if (this.nextFew(str, i, "abs")) {
                    toks.add(new FunctionName(i, "abs"));
                    i += 2;
                    continue;
                }
                result.setA(("Lex err near position " + i + ": unknown function name or other bad syntax"));
                return result;
            }
            return result;
        }

        private boolean nextFew(String str, int pos, String funcName) {
            if (pos + funcName.length() > str.length()) {
                return false;
            }
            for (int i = 0; i < funcName.length(); ++i) {
                if (str.charAt(pos + i) == funcName.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }

    private class Numeric
    extends Token {
        private U value;

        Numeric(int start, U value) {
            this.setStart(start);
            this.value = value;
        }
    }

    private class Comma
    extends Token {
        Comma(int start) {
            this.setStart(start);
        }
    }

    private class Min
    extends Token {
        Min(int start) {
            this.setStart(start);
        }
    }

    private class Max
    extends Token {
        Max(int start) {
            this.setStart(start);
        }
    }

    private class Power
    extends Token {
        Power(int start) {
            this.setStart(start);
        }
    }

    private class Mod
    extends Token {
        Mod(int start) {
            this.setStart(start);
        }
    }

    private class Divide
    extends Token {
        Divide(int start) {
            this.setStart(start);
        }
    }

    private class Times
    extends Token {
        Times(int start) {
            this.setStart(start);
        }
    }

    private class Minus
    extends Token {
        Minus(int start) {
            this.setStart(start);
        }
    }

    private class Plus
    extends Token {
        Plus(int start) {
            this.setStart(start);
        }
    }

    private class CloseParen
    extends Token {
        CloseParen(int start) {
            this.setStart(start);
        }
    }

    private class OpenParen
    extends Token {
        OpenParen(int start) {
            this.setStart(start);
        }
    }

    private class FunctionName
    extends Token {
        FunctionName(int start, String name) {
            this.setStart(start);
            this.setText(name);
        }
    }

    private class Index
    extends Token {
        private int number;

        Index(int start, int number) {
            this.setStart(start);
            this.number = number;
        }

        int getNumber() {
            return this.number;
        }
    }

    private class Token {
        private String text;
        private int start;

        private Token() {
        }

        void setText(String text) {
            this.text = text;
        }

        String getText() {
            return this.text;
        }

        void setStart(int start) {
            this.start = start;
        }

        int getStart() {
            return this.start;
        }
    }
}

