/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.region;

import nom.bdezonia.zorbage.misc.RealUtils;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.region.Region;
import nom.bdezonia.zorbage.sampling.RealIndex;

public class RegionCircle
implements Region<RealIndex> {
    private final double cx;
    private final double cy;
    private final double radius;
    private final Procedure1<RealIndex> MAX_BOUND = new Procedure1<RealIndex>(){

        @Override
        public void call(RealIndex max) {
            if (max.numDimensions() != 2) {
                throw new IllegalArgumentException("incorrect dimensions of point in RegionCircle::maxBound()");
            }
            max.set(0, RegionCircle.this.cx + RegionCircle.this.radius);
            max.set(1, RegionCircle.this.cy + RegionCircle.this.radius);
        }
    };
    private final Procedure1<RealIndex> MIN_BOUND = new Procedure1<RealIndex>(){

        @Override
        public void call(RealIndex min) {
            if (min.numDimensions() != 2) {
                throw new IllegalArgumentException("incorrect dimensions of point in RegionCircle::minBound()");
            }
            min.set(0, RegionCircle.this.cx - RegionCircle.this.radius);
            min.set(1, RegionCircle.this.cy - RegionCircle.this.radius);
        }
    };

    public RegionCircle(double cx, double cy, double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("negative radius in RegionCircle");
        }
        this.cx = cx;
        this.cy = cy;
        this.radius = radius;
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public boolean contains(RealIndex samplePoint) {
        if (samplePoint.numDimensions() != 2) {
            throw new IllegalArgumentException("incorrect dimensions of sample point in RegionCircle::contains()");
        }
        return RealUtils.distance2d(samplePoint.get(0), samplePoint.get(1), this.cx, this.cy) <= this.radius;
    }

    @Override
    public Procedure1<RealIndex> maxBound() {
        return this.MAX_BOUND;
    }

    @Override
    public Procedure1<RealIndex> minBound() {
        return this.MIN_BOUND;
    }
}

