/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import nom.bdezonia.zorbage.sampling.SupportsBoundsCalc;
import nom.bdezonia.zorbage.type.algebra.DimensionCount;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;

public class IntegerIndex
implements Allocatable<IntegerIndex>,
Duplicatable<IntegerIndex>,
DimensionCount,
Settable<IntegerIndex>,
Gettable<IntegerIndex>,
SupportsBoundsCalc<IntegerIndex> {
    private final long[] index;

    public IntegerIndex(int numDims) {
        this.index = new long[numDims];
    }

    public IntegerIndex(long[] idx) {
        this.index = (long[])idx.clone();
    }

    @Override
    public void set(IntegerIndex other) {
        if (this.index.length != other.index.length) {
            throw new IllegalArgumentException("mismatched dims in set()");
        }
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = other.index[i];
        }
    }

    @Override
    public void get(IntegerIndex other) {
        if (this.index.length != other.index.length) {
            throw new IllegalArgumentException("mismatched dims in get()");
        }
        for (int i = 0; i < this.index.length; ++i) {
            other.index[i] = this.index[i];
        }
    }

    public void set(int dim, long value) {
        this.index[dim] = value;
    }

    public long get(int dim) {
        return this.index[dim];
    }

    @Override
    public IntegerIndex duplicate() {
        return new IntegerIndex(this.index);
    }

    @Override
    public int numDimensions() {
        return this.index.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntegerIndex) {
            IntegerIndex other = (IntegerIndex)obj;
            if (this.numDimensions() != other.numDimensions()) {
                return false;
            }
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (this.get(i) == other.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setMax() {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Long.MAX_VALUE;
        }
    }

    @Override
    public void setMin() {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Long.MIN_VALUE;
        }
    }

    @Override
    public void updateMin(IntegerIndex tmp) {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Math.min(this.index[i], tmp.get(i));
        }
    }

    @Override
    public void updateMax(IntegerIndex tmp) {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Math.max(this.index[i], tmp.get(i));
        }
    }

    @Override
    public IntegerIndex allocate() {
        return new IntegerIndex(this.index.length);
    }
}

