/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import nom.bdezonia.zorbage.sampling.SupportsBoundsCalc;
import nom.bdezonia.zorbage.type.algebra.DimensionCount;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;

public class RealIndex
implements Allocatable<RealIndex>,
Duplicatable<RealIndex>,
DimensionCount,
Settable<RealIndex>,
Gettable<RealIndex>,
SupportsBoundsCalc<RealIndex> {
    private final double[] index;

    public RealIndex(int numDims) {
        this.index = new double[numDims];
    }

    public RealIndex(double[] idx) {
        this.index = (double[])idx.clone();
    }

    @Override
    public void set(RealIndex other) {
        if (this.index.length != other.index.length) {
            throw new IllegalArgumentException("mismatched dims in set()");
        }
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = other.index[i];
        }
    }

    @Override
    public void get(RealIndex other) {
        if (this.index.length != other.index.length) {
            throw new IllegalArgumentException("mismatched dims in get()");
        }
        for (int i = 0; i < this.index.length; ++i) {
            other.index[i] = this.index[i];
        }
    }

    public void set(int dim, double value) {
        this.index[dim] = value;
    }

    public double get(int dim) {
        return this.index[dim];
    }

    @Override
    public RealIndex duplicate() {
        return new RealIndex(this.index);
    }

    @Override
    public int numDimensions() {
        return this.index.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RealIndex) {
            RealIndex other = (RealIndex)obj;
            if (this.numDimensions() != other.numDimensions()) {
                return false;
            }
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (this.get(i) == other.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setMax() {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Double.MAX_VALUE;
        }
    }

    @Override
    public void setMin() {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = -1.7976931348623157E308;
        }
    }

    @Override
    public void updateMin(RealIndex tmp) {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Math.min(this.index[i], tmp.get(i));
        }
    }

    @Override
    public void updateMax(RealIndex tmp) {
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Math.max(this.index[i], tmp.get(i));
        }
    }

    @Override
    public RealIndex allocate() {
        return new RealIndex(this.index.length);
    }
}

