/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingIterator;

public class SamplingCartesianIntegerGrid
implements Sampling<IntegerIndex> {
    private final int numD;
    private final IntegerIndex minPt;
    private final IntegerIndex maxPt;

    public SamplingCartesianIntegerGrid(long[] point1, long[] point2) {
        if (point1.length != point2.length) {
            throw new IllegalArgumentException("mismatched dimensions of input points");
        }
        this.numD = point1.length;
        this.minPt = new IntegerIndex(this.numD);
        this.maxPt = new IntegerIndex(this.numD);
        for (int i = 0; i < this.numD; ++i) {
            this.minPt.set(i, Math.min(point1[i], point2[i]));
            this.maxPt.set(i, Math.max(point1[i], point2[i]));
        }
    }

    public SamplingCartesianIntegerGrid(IntegerIndex point1, IntegerIndex point2) {
        if (point1.numDimensions() != point2.numDimensions()) {
            throw new IllegalArgumentException("mismatched dimensions of input points");
        }
        this.numD = point1.numDimensions();
        this.minPt = point1.allocate();
        this.maxPt = point1.allocate();
        for (int i = 0; i < this.numD; ++i) {
            this.minPt.set(i, Math.min(point1.get(i), point2.get(i)));
            this.maxPt.set(i, Math.max(point1.get(i), point2.get(i)));
        }
    }

    @Override
    public int numDimensions() {
        return this.numD;
    }

    @Override
    public boolean contains(IntegerIndex samplePoint) {
        if (samplePoint.numDimensions() != this.numD) {
            throw new IllegalArgumentException("contains() expects input point to have same dimension as sampling");
        }
        for (int i = 0; i < this.numD; ++i) {
            if (samplePoint.get(i) < this.minPt.get(i)) {
                return false;
            }
            if (samplePoint.get(i) <= this.maxPt.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SamplingIterator<IntegerIndex> iterator() {
        return new Iterator();
    }

    private class Iterator
    implements SamplingIterator<IntegerIndex> {
        private final IntegerIndex index;

        private Iterator() {
            if (SamplingCartesianIntegerGrid.this.minPt.get(0) == Long.MIN_VALUE) {
                throw new IllegalArgumentException("cannot handle min point at Long.MIN_VALUE");
            }
            this.index = SamplingCartesianIntegerGrid.this.minPt.duplicate();
            this.index.set(0, this.index.get(0) - 1L);
        }

        @Override
        public boolean hasNext() {
            return !this.index.equals(SamplingCartesianIntegerGrid.this.maxPt);
        }

        @Override
        public void next(IntegerIndex value) {
            if (value.numDimensions() != SamplingCartesianIntegerGrid.this.numD) {
                throw new IllegalArgumentException("mismatched dimensions of output point");
            }
            for (int i = 0; i < SamplingCartesianIntegerGrid.this.numD; ++i) {
                if (this.index.get(i) < SamplingCartesianIntegerGrid.this.maxPt.get(i)) {
                    this.index.set(i, this.index.get(i) + 1L);
                    for (int j = 0; j < SamplingCartesianIntegerGrid.this.numD; ++j) {
                        value.set(j, this.index.get(j));
                    }
                    return;
                }
                this.index.set(i, SamplingCartesianIntegerGrid.this.minPt.get(i));
            }
            throw new IllegalArgumentException("next() called on sampling that does not hasNext()");
        }
    }
}

