/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.RealIndex;
import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingGeneral;
import nom.bdezonia.zorbage.sampling.SamplingIterator;

public class SamplingCartesianRealGrid
implements Sampling<RealIndex> {
    private final SamplingGeneral<RealIndex> sampling;
    private final double TOL = 1.0E-6;

    public SamplingCartesianRealGrid(double[] point1, double[] point2, long[] counts) {
        if (point1.length != point2.length || point1.length != counts.length) {
            throw new IllegalArgumentException("mismatched dimensions of input points");
        }
        int numD = point1.length;
        this.sampling = new SamplingGeneral(numD);
        RealIndex minPt = new RealIndex(numD);
        RealIndex maxPt = new RealIndex(numD);
        IntegerIndex dimCounts = new IntegerIndex(numD);
        for (int i = 0; i < numD; ++i) {
            minPt.set(i, Math.min(point1[i], point2[i]));
            maxPt.set(i, Math.max(point1[i], point2[i]));
            dimCounts.set(i, Math.abs(counts[i]));
        }
        IntegerIndex index = dimCounts.allocate();
        index.set(0, index.get(0) - 1L);
        RealIndex pt = minPt.allocate();
        while (this.hasNext(index, dimCounts)) {
            this.next(index, dimCounts, minPt, maxPt, pt);
            this.sampling.add(pt);
        }
    }

    public SamplingCartesianRealGrid(RealIndex point1, RealIndex point2, IntegerIndex counts) {
        if (point1.numDimensions() != point2.numDimensions() || point1.numDimensions() != counts.numDimensions()) {
            throw new IllegalArgumentException("mismatched dimensions of input points");
        }
        int numD = point1.numDimensions();
        this.sampling = new SamplingGeneral(numD);
        RealIndex minPt = new RealIndex(numD);
        RealIndex maxPt = new RealIndex(numD);
        IntegerIndex dimCounts = new IntegerIndex(numD);
        for (int i = 0; i < numD; ++i) {
            minPt.set(i, Math.min(point1.get(i), point2.get(i)));
            maxPt.set(i, Math.max(point1.get(i), point2.get(i)));
            dimCounts.set(i, Math.abs(counts.get(i)));
        }
        IntegerIndex index = dimCounts.allocate();
        index.set(0, index.get(0) - 1L);
        RealIndex pt = minPt.allocate();
        while (this.hasNext(index, dimCounts)) {
            this.next(index, dimCounts, minPt, maxPt, pt);
            this.sampling.add(pt);
        }
    }

    @Override
    public int numDimensions() {
        return this.sampling.numDimensions();
    }

    @Override
    public boolean contains(RealIndex samplePoint) {
        if (samplePoint.numDimensions() != this.sampling.numDimensions()) {
            throw new IllegalArgumentException("contains() sample point does not match dimensionality");
        }
        RealIndex tmp = new RealIndex(this.sampling.numDimensions());
        SamplingIterator<RealIndex> iter = this.sampling.iterator();
        while (iter.hasNext()) {
            iter.next(tmp);
            double dist = 0.0;
            for (int i = 0; i < tmp.numDimensions(); ++i) {
                double delta = samplePoint.get(i) - tmp.get(i);
                dist += delta * delta;
            }
            if (!((dist = Math.sqrt(dist)) < 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SamplingIterator<RealIndex> iterator() {
        return this.sampling.iterator();
    }

    private boolean hasNext(IntegerIndex index, IntegerIndex dimCounts) {
        for (int i = 0; i < index.numDimensions(); ++i) {
            if (index.get(i) >= dimCounts.get(i) - 1L) continue;
            return true;
        }
        return false;
    }

    private void next(IntegerIndex index, IntegerIndex dimCounts, RealIndex minPt, RealIndex maxPt, RealIndex value) {
        for (int i = 0; i < index.numDimensions(); ++i) {
            if (index.get(i) < dimCounts.get(i) - 1L) {
                index.set(i, index.get(i) + 1L);
                for (int j = 0; j < index.numDimensions(); ++j) {
                    double val = minPt.get(j);
                    value.set(j, val += (maxPt.get(j) - minPt.get(j)) / (double)(dimCounts.get(j) - 1L) * (double)index.get(j));
                }
                return;
            }
            index.set(i, 0L);
        }
        throw new IllegalArgumentException("next() called on sampling that does not hasNext()");
    }
}

