/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import nom.bdezonia.zorbage.sampling.Bounds;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingDifference;
import nom.bdezonia.zorbage.sampling.SamplingIterator;

public class SamplingComplement
implements Sampling<IntegerIndex> {
    private final Sampling<IntegerIndex> difference;

    public SamplingComplement(Sampling<IntegerIndex> sampling) {
        IntegerIndex min = new IntegerIndex(sampling.numDimensions());
        IntegerIndex max = new IntegerIndex(sampling.numDimensions());
        Bounds.find(sampling, min, max);
        SamplingCartesianIntegerGrid volume = new SamplingCartesianIntegerGrid(min, max);
        this.difference = new SamplingDifference<IntegerIndex>(volume, sampling, min);
    }

    @Override
    public int numDimensions() {
        return this.difference.numDimensions();
    }

    @Override
    public boolean contains(IntegerIndex samplePoint) {
        return this.difference.contains(samplePoint);
    }

    @Override
    public SamplingIterator<IntegerIndex> iterator() {
        return new Iterator();
    }

    private class Iterator
    implements SamplingIterator<IntegerIndex> {
        private final SamplingIterator<IntegerIndex> iter;

        private Iterator() {
            this.iter = SamplingComplement.this.difference.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void next(IntegerIndex value) {
            this.iter.next(value);
        }
    }
}

