/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import nom.bdezonia.zorbage.predicate.Predicate;
import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.DimensionCount;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;

public class SamplingConditional<T extends Allocatable<T> & Settable<T>>
implements Sampling<T> {
    private final Predicate<T> condition;
    private final Sampling<T> sampling;
    private final T example;

    public SamplingConditional(Predicate<T> condition, Sampling<T> sampling, T example) {
        this.condition = condition;
        this.sampling = sampling;
        this.example = (Allocatable)example.allocate();
    }

    @Override
    public int numDimensions() {
        return this.sampling.numDimensions();
    }

    @Override
    public boolean contains(T samplePoint) {
        if (this.condition.isTrue(samplePoint)) {
            return this.sampling.contains(samplePoint);
        }
        return false;
    }

    @Override
    public SamplingIterator<T> iterator() {
        return new Iterator();
    }

    private class Iterator
    implements SamplingIterator<T> {
        private SamplingIterator<T> iter1;
        private T index;
        private boolean cached;

        private Iterator() {
            this.iter1 = SamplingConditional.this.sampling.iterator();
            this.index = (Allocatable)SamplingConditional.this.example.allocate();
            this.cached = false;
        }

        private boolean positionToNext() {
            while (this.iter1.hasNext()) {
                this.iter1.next(this.index);
                if (!SamplingConditional.this.condition.isTrue(this.index)) continue;
                this.cached = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.cached) {
                return true;
            }
            return this.positionToNext();
        }

        @Override
        public void next(T value) {
            if (((DimensionCount)value).numDimensions() != SamplingConditional.this.numDimensions()) {
                throw new IllegalArgumentException("next() has bad output value dimensions");
            }
            if (!this.cached) {
                throw new IllegalArgumentException("next() called when do not hasNext()");
            }
            ((Settable)value).set(this.index);
            this.cached = false;
        }
    }
}

