/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import java.util.ArrayList;
import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.DimensionCount;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;

public class SamplingGeneral<U extends Duplicatable<U> & DimensionCount>
implements Sampling<U> {
    private final int numD;
    private final ArrayList<U> points;

    public SamplingGeneral(int numD) {
        this.numD = numD;
        this.points = new ArrayList();
    }

    public void add(U pt) {
        if (((DimensionCount)pt).numDimensions() != this.numDimensions()) {
            throw new IllegalArgumentException("mismatched dimensions in SamplingGeneral::add()");
        }
        this.points.add(pt.duplicate());
    }

    @Override
    public int numDimensions() {
        return this.numD;
    }

    @Override
    public boolean contains(U samplePoint) {
        if (((DimensionCount)samplePoint).numDimensions() != this.numDimensions()) {
            throw new IllegalArgumentException("mismatched dimensions in SamplingGeneral::contains()");
        }
        int pointsSize = this.points.size();
        for (int i = 0; i < pointsSize; ++i) {
            if (!((Duplicatable)this.points.get(i)).equals(samplePoint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SamplingIterator<U> iterator() {
        return new Iterator();
    }

    public static <T extends Settable<T> & Duplicatable<T>> SamplingGeneral<T> create(Sampling<T> other, T scratch) {
        SamplingGeneral<Duplicatable<T>> sampling = new SamplingGeneral<Duplicatable<T>>(other.numDimensions());
        SamplingIterator<T> iter = other.iterator();
        while (iter.hasNext()) {
            iter.next(scratch);
            sampling.add(scratch);
        }
        return sampling;
    }

    private class Iterator
    implements SamplingIterator<U> {
        private final java.util.Iterator<U> iter;

        private Iterator() {
            this.iter = SamplingGeneral.this.points.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void next(U value) {
            ((Settable)value).set(this.iter.next());
        }
    }
}

