/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import net.jafama.FastMath;
import nom.bdezonia.zorbage.misc.RealUtils;
import nom.bdezonia.zorbage.sampling.RealIndex;
import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingGeneral;
import nom.bdezonia.zorbage.sampling.SamplingIterator;

public class SamplingPolarRealGrid
implements Sampling<RealIndex> {
    private final SamplingGeneral<RealIndex> sampling;
    private final double TOL = 1.0E-6;

    public SamplingPolarRealGrid(double dr, int rCount, double dtheta, int thetaCount) {
        if (rCount < 1 || thetaCount < 1) {
            throw new IllegalArgumentException("counts must be >= 1 in polar grid");
        }
        this.sampling = new SamplingGeneral(2);
        RealIndex value = new RealIndex(this.sampling.numDimensions());
        for (int th = 0; th < thetaCount; ++th) {
            double angle = (double)th * dtheta;
            for (int r = 0; r < rCount; ++r) {
                double radius = (double)r * dr;
                value.set(0, FastMath.cos((double)angle) * radius);
                value.set(1, FastMath.sin((double)angle) * radius);
                if (r == 0 && (r != 0 || th != 0)) continue;
                this.sampling.add(value);
            }
        }
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public boolean contains(RealIndex samplePoint) {
        if (samplePoint.numDimensions() != 2) {
            throw new IllegalArgumentException("contains() sample point does not match dimensionality");
        }
        RealIndex tmp = new RealIndex(this.sampling.numDimensions());
        SamplingIterator<RealIndex> iter = this.sampling.iterator();
        while (iter.hasNext()) {
            iter.next(tmp);
            if (!(RealUtils.distance2d(samplePoint.get(0), samplePoint.get(1), tmp.get(0), tmp.get(1)) < 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SamplingIterator<RealIndex> iterator() {
        return this.sampling.iterator();
    }
}

