/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import net.jafama.FastMath;
import nom.bdezonia.zorbage.misc.RealUtils;
import nom.bdezonia.zorbage.sampling.RealIndex;
import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingGeneral;
import nom.bdezonia.zorbage.sampling.SamplingIterator;

public class SamplingSphericalRealGrid
implements Sampling<RealIndex> {
    private final SamplingGeneral<RealIndex> sampling;
    private final double TOL = 1.0E-6;

    public SamplingSphericalRealGrid(double dr, int rCount, double dtheta, int thetaCount, double dphi, int phiCount) {
        if (rCount < 1 || thetaCount < 1 || phiCount < 1) {
            throw new IllegalArgumentException("counts must be >= 1 in spherical grid");
        }
        this.sampling = new SamplingGeneral(3);
        RealIndex value = new RealIndex(this.sampling.numDimensions());
        boolean originAdded = false;
        for (int p = 0; p < phiCount; ++p) {
            double anglePhi = (double)p * dphi;
            for (int th = 0; th < thetaCount; ++th) {
                double angleTheta = (double)th * dtheta;
                for (int r = 0; r < rCount; ++r) {
                    double radius = (double)r * dr;
                    double sineTheta = FastMath.sin((double)angleTheta);
                    double cosineTheta = FastMath.cos((double)angleTheta);
                    double sinePhi = FastMath.sin((double)anglePhi);
                    double cosinePhi = FastMath.cos((double)anglePhi);
                    value.set(0, radius * sinePhi * cosineTheta);
                    value.set(1, radius * sinePhi * sineTheta);
                    value.set(2, radius * cosinePhi);
                    if (value.get(0) == 0.0 && value.get(1) == 0.0 && value.get(2) == 0.0) {
                        if (originAdded) continue;
                        this.sampling.add(value);
                        originAdded = true;
                        continue;
                    }
                    this.sampling.add(value);
                }
            }
        }
    }

    @Override
    public int numDimensions() {
        return 3;
    }

    @Override
    public boolean contains(RealIndex samplePoint) {
        if (samplePoint.numDimensions() != 3) {
            throw new IllegalArgumentException("contains() sample point does not match dimensionality");
        }
        RealIndex tmp = new RealIndex(this.sampling.numDimensions());
        SamplingIterator<RealIndex> iter = this.sampling.iterator();
        while (iter.hasNext()) {
            iter.next(tmp);
            if (!(RealUtils.distance3d(samplePoint.get(0), samplePoint.get(1), samplePoint.get(2), tmp.get(0), tmp.get(1), tmp.get(2)) < 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SamplingIterator<RealIndex> iterator() {
        return this.sampling.iterator();
    }
}

