/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.sampling;

import nom.bdezonia.zorbage.sampling.Sampling;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.DimensionCount;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;

public class SamplingUnion<T extends Allocatable<T> & DimensionCount>
implements Sampling<T> {
    private final Sampling<T> first;
    private final Sampling<T> second;
    private final T example;

    public SamplingUnion(Sampling<T> first, Sampling<T> second, T example) {
        if (first.numDimensions() != second.numDimensions()) {
            throw new IllegalArgumentException("num dimensions do not match in SamplingUnion");
        }
        if (first.numDimensions() != ((DimensionCount)example).numDimensions()) {
            throw new IllegalArgumentException("example index does not have correct dimensions");
        }
        this.first = first;
        this.second = second;
        this.example = (Allocatable)example.allocate();
    }

    @Override
    public int numDimensions() {
        return this.first.numDimensions();
    }

    @Override
    public boolean contains(T samplePoint) {
        return this.first.contains(samplePoint) || this.second.contains(samplePoint);
    }

    @Override
    public SamplingIterator<T> iterator() {
        return new Iterator();
    }

    private class Iterator
    implements SamplingIterator<T> {
        private final SamplingIterator<T> iter1;
        private final SamplingIterator<T> iter2;
        private final T index;
        private boolean cached;

        private Iterator() {
            this.iter1 = SamplingUnion.this.first.iterator();
            this.iter2 = SamplingUnion.this.second.iterator();
            this.index = (Allocatable)SamplingUnion.this.example.allocate();
            this.cached = false;
        }

        private boolean positionToNext() {
            if (this.iter1.hasNext()) {
                this.iter1.next(this.index);
                this.cached = true;
                return true;
            }
            while (this.iter2.hasNext()) {
                this.iter2.next(this.index);
                if (SamplingUnion.this.first.contains(this.index)) continue;
                this.cached = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.cached) {
                return true;
            }
            return this.positionToNext();
        }

        @Override
        public void next(T value) {
            if (((DimensionCount)value).numDimensions() != SamplingUnion.this.numDimensions()) {
                throw new IllegalArgumentException("next() has bad output value dimensions");
            }
            if (!this.cached) {
                throw new IllegalArgumentException("next() called when do not hasNext()");
            }
            ((Settable)value).set(this.index);
            this.cached = false;
        }
    }
}

