/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.bool;

import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.LogicalOperations;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.Unity;
import nom.bdezonia.zorbage.type.data.bool.BooleanMember;

public class BooleanAlgebra
implements Algebra<BooleanAlgebra, BooleanMember>,
Unity<BooleanMember>,
Bounded<BooleanMember>,
Ordered<BooleanMember>,
LogicalOperations<BooleanMember>,
Random<BooleanMember> {
    private final Procedure3<BooleanMember, BooleanMember, BooleanMember> AND = new Procedure3<BooleanMember, BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b, BooleanMember c) {
            c.setV(a.v() && b.v());
        }
    };
    private final Procedure3<BooleanMember, BooleanMember, BooleanMember> OR = new Procedure3<BooleanMember, BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b, BooleanMember c) {
            c.setV(a.v() || b.v());
        }
    };
    private final Procedure3<BooleanMember, BooleanMember, BooleanMember> XOR = new Procedure3<BooleanMember, BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b, BooleanMember c) {
            c.setV(a.v() ^ b.v());
        }
    };
    private final Procedure2<BooleanMember, BooleanMember> NOT = new Procedure2<BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b) {
            b.setV(!a.v());
        }
    };
    private final Procedure3<BooleanMember, BooleanMember, BooleanMember> ANDNOT = new Procedure3<BooleanMember, BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b, BooleanMember c) {
            c.setV(a.v() && !b.v());
        }
    };
    private final Procedure4<BooleanMember, BooleanMember, BooleanMember, BooleanMember> TERN = new Procedure4<BooleanMember, BooleanMember, BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b, BooleanMember c, BooleanMember d) {
            d.setV(a.v() ? b.v() : c.v());
        }
    };
    private final Function2<Boolean, BooleanMember, BooleanMember> LS = new Function2<Boolean, BooleanMember, BooleanMember>(){

        @Override
        public Boolean call(BooleanMember a, BooleanMember b) {
            return !a.v() && b.v();
        }
    };
    private final Function2<Boolean, BooleanMember, BooleanMember> LSE = new Function2<Boolean, BooleanMember, BooleanMember>(){

        @Override
        public Boolean call(BooleanMember a, BooleanMember b) {
            if (a.v()) {
                return b.v();
            }
            return true;
        }
    };
    private final Function2<Boolean, BooleanMember, BooleanMember> GR = new Function2<Boolean, BooleanMember, BooleanMember>(){

        @Override
        public Boolean call(BooleanMember a, BooleanMember b) {
            return a.v() && !b.v();
        }
    };
    private final Function2<Boolean, BooleanMember, BooleanMember> GRE = new Function2<Boolean, BooleanMember, BooleanMember>(){

        @Override
        public Boolean call(BooleanMember a, BooleanMember b) {
            if (a.v()) {
                return true;
            }
            return !b.v();
        }
    };
    private final Function2<Integer, BooleanMember, BooleanMember> CMP = new Function2<Integer, BooleanMember, BooleanMember>(){

        @Override
        public Integer call(BooleanMember a, BooleanMember b) {
            if (BooleanAlgebra.this.isLess().call(a, b).booleanValue()) {
                return -1;
            }
            if (BooleanAlgebra.this.isGreater().call(a, b).booleanValue()) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<Integer, BooleanMember> SIG = new Function1<Integer, BooleanMember>(){

        @Override
        public Integer call(BooleanMember a) {
            if (a.v()) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure1<BooleanMember> MAXB = new Procedure1<BooleanMember>(){

        @Override
        public void call(BooleanMember a) {
            a.setV(true);
        }
    };
    private final Procedure1<BooleanMember> MINB = new Procedure1<BooleanMember>(){

        @Override
        public void call(BooleanMember a) {
            a.setV(false);
        }
    };
    private final Function2<Boolean, BooleanMember, BooleanMember> EQ = new Function2<Boolean, BooleanMember, BooleanMember>(){

        @Override
        public Boolean call(BooleanMember a, BooleanMember b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, BooleanMember, BooleanMember> NEQ = new Function2<Boolean, BooleanMember, BooleanMember>(){

        @Override
        public Boolean call(BooleanMember a, BooleanMember b) {
            return a.v() != b.v();
        }
    };
    private final Procedure2<BooleanMember, BooleanMember> ASSIGN = new Procedure2<BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember from, BooleanMember to) {
            to.set(from);
        }
    };
    private final Procedure3<BooleanMember, BooleanMember, BooleanMember> MIN = new Procedure3<BooleanMember, BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b, BooleanMember c) {
            Min.compute(G.BOOL, a, b, c);
        }
    };
    private final Procedure3<BooleanMember, BooleanMember, BooleanMember> MAX = new Procedure3<BooleanMember, BooleanMember, BooleanMember>(){

        @Override
        public void call(BooleanMember a, BooleanMember b, BooleanMember c) {
            Max.compute(G.BOOL, a, b, c);
        }
    };
    private final Procedure1<BooleanMember> ONE = new Procedure1<BooleanMember>(){

        @Override
        public void call(BooleanMember a) {
            a.setV(true);
        }
    };
    private final Procedure1<BooleanMember> RAND = new Procedure1<BooleanMember>(){

        @Override
        public void call(BooleanMember a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextBoolean());
        }
    };
    private final Function1<Boolean, BooleanMember> ISZERO = new Function1<Boolean, BooleanMember>(){

        @Override
        public Boolean call(BooleanMember a) {
            return !a.v();
        }
    };
    private final Procedure1<BooleanMember> ZERO = new Procedure1<BooleanMember>(){

        @Override
        public void call(BooleanMember a) {
            a.setV(false);
        }
    };

    @Override
    public Procedure3<BooleanMember, BooleanMember, BooleanMember> logicalAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<BooleanMember, BooleanMember, BooleanMember> logicalOr() {
        return this.OR;
    }

    @Override
    public Procedure3<BooleanMember, BooleanMember, BooleanMember> logicalXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<BooleanMember, BooleanMember> logicalNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<BooleanMember, BooleanMember, BooleanMember> logicalAndNot() {
        return this.ANDNOT;
    }

    public Procedure4<BooleanMember, BooleanMember, BooleanMember, BooleanMember> ternary() {
        return this.TERN;
    }

    @Override
    public Function2<Boolean, BooleanMember, BooleanMember> isLess() {
        return this.LS;
    }

    @Override
    public Function2<Boolean, BooleanMember, BooleanMember> isLessEqual() {
        return this.LSE;
    }

    @Override
    public Function2<Boolean, BooleanMember, BooleanMember> isGreater() {
        return this.GR;
    }

    @Override
    public Function2<Boolean, BooleanMember, BooleanMember> isGreaterEqual() {
        return this.GRE;
    }

    @Override
    public Function2<Integer, BooleanMember, BooleanMember> compare() {
        return this.CMP;
    }

    @Override
    public Function1<Integer, BooleanMember> signum() {
        return this.SIG;
    }

    @Override
    public Procedure1<BooleanMember> maxBound() {
        return this.MAXB;
    }

    @Override
    public Procedure1<BooleanMember> minBound() {
        return this.MINB;
    }

    @Override
    public Function2<Boolean, BooleanMember, BooleanMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, BooleanMember, BooleanMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public BooleanMember construct() {
        return new BooleanMember();
    }

    @Override
    public BooleanMember construct(BooleanMember other) {
        return new BooleanMember(other);
    }

    @Override
    public BooleanMember construct(String s) {
        return new BooleanMember(s);
    }

    @Override
    public Procedure2<BooleanMember, BooleanMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<BooleanMember, BooleanMember, BooleanMember> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<BooleanMember, BooleanMember, BooleanMember> max() {
        return this.MAX;
    }

    @Override
    public Procedure1<BooleanMember> unity() {
        return this.ONE;
    }

    @Override
    public Procedure1<BooleanMember> random() {
        return this.RAND;
    }

    @Override
    public Function1<Boolean, BooleanMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<BooleanMember> zero() {
        return this.ZERO;
    }
}

