/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.bool;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.BitCoder;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;

public final class BooleanMember
implements BitCoder,
BooleanCoder,
Allocatable<BooleanMember>,
Duplicatable<BooleanMember>,
Settable<BooleanMember>,
Gettable<BooleanMember>,
UniversalRepresentation,
NumberMember<BooleanMember>,
PrimitiveConversion {
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private boolean v;

    public BooleanMember() {
        this.v = false;
    }

    public BooleanMember(boolean value) {
        this.v = value;
    }

    public BooleanMember(BooleanMember value) {
        this.set(value);
    }

    public BooleanMember(String value) {
        TensorStringRepresentation rep;
        OctonionRepresentation val;
        this.v = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("+") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase(ONE) ? true : (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("f") || value.equalsIgnoreCase("-") || value.equalsIgnoreCase("n") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase(ZERO) ? false : !(val = (rep = new TensorStringRepresentation(value)).firstValue()).r().equals(BigDecimal.ZERO));
    }

    public boolean v() {
        return this.v;
    }

    @Override
    public void setV(boolean val) {
        this.v = val;
    }

    @Override
    public void set(BooleanMember other) {
        this.v = other.v;
    }

    @Override
    public void get(BooleanMember other) {
        other.v = this.v;
    }

    public String toString() {
        if (this.v) {
            return ONE;
        }
        return ZERO;
    }

    @Override
    public int booleanCount() {
        return 1;
    }

    @Override
    public void fromBooleanArray(boolean[] arr, int index) {
        this.v = arr[index];
    }

    @Override
    public void toBooleanArray(boolean[] arr, int index) {
        arr[index] = this.v;
    }

    @Override
    public void fromBooleanFile(RandomAccessFile raf) throws IOException {
        this.v = raf.readBoolean();
    }

    @Override
    public void toBooleanFile(RandomAccessFile raf) throws IOException {
        raf.writeBoolean(this.v);
    }

    @Override
    public int bitCount() {
        return 1;
    }

    @Override
    public void fromBitArray(long[] arr, int index, int offset) {
        long bucket = arr[index];
        this.v = (bucket & 1L << offset) > 0L;
    }

    @Override
    public void toBitArray(long[] arr, int index, int offset) {
        long bucket = arr[index];
        bucket = this.v ? (bucket |= 1L << offset) : (bucket &= 1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
        arr[index] = bucket;
    }

    @Override
    public BooleanMember allocate() {
        return new BooleanMember();
    }

    @Override
    public BooleanMember duplicate() {
        return new BooleanMember(this);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(BigDecimal.valueOf(this.v() ? 1L : 0L)));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        BigDecimal d = rep.getValue().r();
        this.v = !d.equals(BigDecimal.ZERO);
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(BooleanMember value) {
        this.get(value);
    }

    @Override
    public void setV(BooleanMember value) {
        this.set(value);
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BYTE;
    }

    @Override
    public long dimension(int i) {
        return 0L;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        this.v = v != 0;
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        this.v = v != 0;
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        this.v = v != 0;
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        this.v = v != 0L;
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        this.v = !Float.isNaN(v) && v != 0.0f;
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        this.v = !Double.isNaN(v) && v != 0.0;
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        this.v = v.signum() != 0;
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        this.v = v.signum() != 0;
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v != 0;
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v != 0;
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v != 0;
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v != 0L;
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = !Float.isNaN(v) && v != 0.0f;
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = !Double.isNaN(v) && v != 0.0;
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v.signum() != 0;
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.v = v.signum() != 0;
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return (byte)(this.v ? 1 : 0);
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return (short)(this.v ? 1 : 0);
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v ? 1 : 0;
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v ? 1 : 0;
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v ? 1 : 0;
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v ? 1 : 0;
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v ? BigInteger.ONE : BigInteger.ZERO;
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return (byte)(this.v ? 1 : 0);
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return (short)(this.v ? 1 : 0);
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v ? 1 : 0;
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        return this.v ? 1 : 0;
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        return this.v ? 1 : 0;
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        return this.v ? 1 : 0;
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        return this.v ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        return this.v ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public void primitiveInit() {
        this.v = false;
    }
}

