/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.complex;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.ComplexNumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Field;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;
import nom.bdezonia.zorbage.type.algebra.InverseTrigonometric;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat16Algebra
implements Field<ComplexFloat16Algebra, ComplexFloat16Member>,
Norm<ComplexFloat16Member, Float16Member>,
RealConstants<ComplexFloat16Member>,
ImaginaryConstants<ComplexFloat16Member>,
Exponential<ComplexFloat16Member>,
Trigonometric<ComplexFloat16Member>,
InverseTrigonometric<ComplexFloat16Member>,
Hyperbolic<ComplexFloat16Member>,
InverseHyperbolic<ComplexFloat16Member>,
Roots<ComplexFloat16Member>,
Power<ComplexFloat16Member>,
Rounding<Float16Member, ComplexFloat16Member>,
Infinite<ComplexFloat16Member>,
NaN<ComplexFloat16Member>,
Conjugate<ComplexFloat16Member>,
Random<ComplexFloat16Member>,
RealUnreal<ComplexFloat16Member, Float16Member>,
Scale<ComplexFloat16Member, ComplexFloat16Member>,
ScaleByHighPrec<ComplexFloat16Member>,
ScaleByRational<ComplexFloat16Member>,
ScaleByDouble<ComplexFloat16Member>,
ScaleComponents<ComplexFloat16Member, Float16Member>,
Tolerance<Float16Member, ComplexFloat16Member> {
    private static final ComplexFloat16Member ONE = new ComplexFloat16Member(1.0f, 0.0f);
    private static final ComplexFloat16Member TWO = new ComplexFloat16Member(2.0f, 0.0f);
    private static final ComplexFloat16Member MINUS_ONE = new ComplexFloat16Member(-1.0f, 0.0f);
    private static final ComplexFloat16Member PI = new ComplexFloat16Member((float)Math.PI, 0.0f);
    private static final ComplexFloat16Member E = new ComplexFloat16Member((float)Math.E, 0.0f);
    private static final ComplexFloat16Member GAMMA = new ComplexFloat16Member(0.5772157f, 0.0f);
    private static final ComplexFloat16Member PHI = new ComplexFloat16Member(1.618034f, 0.0f);
    private static final ComplexFloat16Member ONE_HALF = new ComplexFloat16Member(0.5f, 0.0f);
    private static final ComplexFloat16Member ONE_THIRD = new ComplexFloat16Member(0.33333334f, 0.0f);
    private static final ComplexFloat16Member I = new ComplexFloat16Member(0.0f, 1.0f);
    private static final ComplexFloat16Member I_OVER_TWO = new ComplexFloat16Member(0.0f, 0.5f);
    private static final ComplexFloat16Member TWO_I = new ComplexFloat16Member(0.0f, 2.0f);
    private static final ComplexFloat16Member MINUS_I = new ComplexFloat16Member(0.0f, -1.0f);
    private static final ComplexFloat16Member MINUS_I_OVER_TWO = new ComplexFloat16Member(0.0f, -0.5f);
    private static final ComplexFloat16Member NaN_ = new ComplexFloat16Member(Float.NaN, Float.NaN);
    private final Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> MUL = new Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b, ComplexFloat16Member c) {
            double r = a.r() * b.r() - a.i() * b.i();
            double i = a.i() * b.r() + a.r() * b.i();
            c.setR((float)r);
            c.setI((float)i);
        }
    };
    private final Procedure3<Integer, ComplexFloat16Member, ComplexFloat16Member> POWER = new Procedure3<Integer, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(Integer power, ComplexFloat16Member a, ComplexFloat16Member b) {
            if (power == 0 && ComplexFloat16Algebra.this.isZero().call(a).booleanValue()) {
                ComplexFloat16Algebra.this.assign().call(NaN_, b);
                return;
            }
            double rToTheN = FastMath.pow((double)FastMath.hypot((double)a.r(), (double)a.i()), (double)power.intValue());
            double nTheta = (double)power.intValue() * ComplexFloat16Algebra.this.getArgument(a);
            b.setR((float)(rToTheN * FastMath.cos((double)nTheta)));
            b.setI((float)(rToTheN * FastMath.sin((double)nTheta)));
        }
    };
    private final Procedure1<ComplexFloat16Member> ZER = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> NEG = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            b.setR(-a.r());
            b.setI(-a.i());
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> ADD = new Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b, ComplexFloat16Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> SUB = new Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b, ComplexFloat16Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
        }
    };
    private final Function2<Boolean, ComplexFloat16Member, ComplexFloat16Member> EQ = new Function2<Boolean, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public Boolean call(ComplexFloat16Member a, ComplexFloat16Member b) {
            return a.r() == b.r() && a.i() == b.i();
        }
    };
    private final Function2<Boolean, ComplexFloat16Member, ComplexFloat16Member> NEQ = new Function2<Boolean, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public Boolean call(ComplexFloat16Member a, ComplexFloat16Member b) {
            return a.r() != b.r() || a.i() != b.i();
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ASSIGN = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member from, ComplexFloat16Member to) {
            to.set(from);
        }
    };
    private final Procedure1<ComplexFloat16Member> UNITY = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            ComplexFloat16Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> INV = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Algebra.this.divide().call(ONE, a, b);
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> DIVIDE = new Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b, ComplexFloat16Member c) {
            double mod2 = b.r() * b.r() + b.i() * b.i();
            double r = (double)(a.r() * b.r() + a.i() * b.i()) / mod2;
            double i = (double)(a.i() * b.r() - a.r() * b.i()) / mod2;
            c.setR((float)r);
            c.setI((float)i);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> CONJ = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            b.setR(a.r());
            b.setI(-a.i());
        }
    };
    private final Procedure2<ComplexFloat16Member, Float16Member> NORM = new Procedure2<ComplexFloat16Member, Float16Member>(){

        @Override
        public void call(ComplexFloat16Member a, Float16Member b) {
            b.setV((float)FastMath.hypot((double)a.r(), (double)a.i()));
        }
    };
    private final Procedure1<ComplexFloat16Member> PI_ = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            ComplexFloat16Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<ComplexFloat16Member> E_ = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            ComplexFloat16Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<ComplexFloat16Member> GAMMA_ = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            ComplexFloat16Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<ComplexFloat16Member> PHI_ = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            ComplexFloat16Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<ComplexFloat16Member> I_ = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            ComplexFloat16Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ASIN = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member ia = new ComplexFloat16Member();
            ComplexFloat16Member aSquared = new ComplexFloat16Member();
            ComplexFloat16Member miniSum = new ComplexFloat16Member();
            ComplexFloat16Member root = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Member logSum = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(I, a, ia);
            ComplexFloat16Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat16Algebra.this.subtract().call(ONE, aSquared, miniSum);
            ComplexFloat16Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat16Algebra.this.add().call(ia, root, sum);
            ComplexFloat16Algebra.this.log().call(sum, logSum);
            ComplexFloat16Algebra.this.multiply().call(MINUS_I, logSum, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ACOS = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member aSquared = new ComplexFloat16Member();
            ComplexFloat16Member miniSum = new ComplexFloat16Member();
            ComplexFloat16Member root = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Member logSum = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat16Algebra.this.subtract().call(aSquared, ONE, miniSum);
            ComplexFloat16Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat16Algebra.this.add().call(a, root, sum);
            ComplexFloat16Algebra.this.log().call(sum, logSum);
            ComplexFloat16Algebra.this.multiply().call(MINUS_I, logSum, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ATAN = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member ia = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Member diff = new ComplexFloat16Member();
            ComplexFloat16Member quotient = new ComplexFloat16Member();
            ComplexFloat16Member log = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(I, a, ia);
            ComplexFloat16Algebra.this.add().call(ONE, ia, sum);
            ComplexFloat16Algebra.this.subtract().call(ONE, ia, diff);
            ComplexFloat16Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat16Algebra.this.log().call(quotient, log);
            ComplexFloat16Algebra.this.multiply().call(MINUS_I_OVER_TWO, log, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ACSC = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member recipA = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.invert().call(a, recipA);
            ComplexFloat16Algebra.this.asin().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ASEC = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member recipA = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.invert().call(a, recipA);
            ComplexFloat16Algebra.this.acos().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ACOT = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member ia = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Member diff = new ComplexFloat16Member();
            ComplexFloat16Member quotient = new ComplexFloat16Member();
            ComplexFloat16Member log = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(I, a, ia);
            ComplexFloat16Algebra.this.add().call(ia, ONE, sum);
            ComplexFloat16Algebra.this.subtract().call(ia, ONE, diff);
            ComplexFloat16Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat16Algebra.this.log().call(quotient, log);
            ComplexFloat16Algebra.this.multiply().call(I_OVER_TWO, log, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ASINH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member aSquared = new ComplexFloat16Member();
            ComplexFloat16Member miniSum = new ComplexFloat16Member();
            ComplexFloat16Member root = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat16Algebra.this.add().call(aSquared, ONE, miniSum);
            ComplexFloat16Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat16Algebra.this.add().call(a, root, sum);
            ComplexFloat16Algebra.this.log().call(sum, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ACOSH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member aSquared = new ComplexFloat16Member();
            ComplexFloat16Member miniSum = new ComplexFloat16Member();
            ComplexFloat16Member root = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat16Algebra.this.subtract().call(aSquared, ONE, miniSum);
            ComplexFloat16Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat16Algebra.this.add().call(a, root, sum);
            ComplexFloat16Algebra.this.log().call(sum, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ATANH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Member diff = new ComplexFloat16Member();
            ComplexFloat16Member quotient = new ComplexFloat16Member();
            ComplexFloat16Member log = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.add().call(ONE, a, sum);
            ComplexFloat16Algebra.this.subtract().call(ONE, a, diff);
            ComplexFloat16Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat16Algebra.this.log().call(quotient, log);
            ComplexFloat16Algebra.this.multiply().call(ONE_HALF, log, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ACSCH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member recipA = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.invert().call(a, recipA);
            ComplexFloat16Algebra.this.asinh().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ASECH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member recipA = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.invert().call(a, recipA);
            ComplexFloat16Algebra.this.acosh().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> ACOTH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Member diff = new ComplexFloat16Member();
            ComplexFloat16Member quotient = new ComplexFloat16Member();
            ComplexFloat16Member log = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.add().call(a, ONE, sum);
            ComplexFloat16Algebra.this.subtract().call(a, ONE, diff);
            ComplexFloat16Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat16Algebra.this.log().call(quotient, log);
            ComplexFloat16Algebra.this.multiply().call(ONE_HALF, log, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SIN = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member IA = new ComplexFloat16Member();
            ComplexFloat16Member minusIA = new ComplexFloat16Member();
            ComplexFloat16Member expIA = new ComplexFloat16Member();
            ComplexFloat16Member expMinusIA = new ComplexFloat16Member();
            ComplexFloat16Member diff = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(a, I, IA);
            ComplexFloat16Algebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexFloat16Algebra.this.exp().call(IA, expIA);
            ComplexFloat16Algebra.this.exp().call(minusIA, expMinusIA);
            ComplexFloat16Algebra.this.subtract().call(expIA, expMinusIA, diff);
            ComplexFloat16Algebra.this.divide().call(diff, TWO_I, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> COS = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member IA = new ComplexFloat16Member();
            ComplexFloat16Member minusIA = new ComplexFloat16Member();
            ComplexFloat16Member expIA = new ComplexFloat16Member();
            ComplexFloat16Member expMinusIA = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(a, I, IA);
            ComplexFloat16Algebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexFloat16Algebra.this.exp().call(IA, expIA);
            ComplexFloat16Algebra.this.exp().call(minusIA, expMinusIA);
            ComplexFloat16Algebra.this.add().call(expIA, expMinusIA, sum);
            ComplexFloat16Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> SINCOS = new Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member s, ComplexFloat16Member c) {
            ComplexFloat16Member IA = new ComplexFloat16Member();
            ComplexFloat16Member minusIA = new ComplexFloat16Member();
            ComplexFloat16Member expIA = new ComplexFloat16Member();
            ComplexFloat16Member expMinusIA = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Member diff = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.multiply().call(a, I, IA);
            ComplexFloat16Algebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexFloat16Algebra.this.exp().call(IA, expIA);
            ComplexFloat16Algebra.this.exp().call(minusIA, expMinusIA);
            ComplexFloat16Algebra.this.subtract().call(expIA, expMinusIA, diff);
            ComplexFloat16Algebra.this.divide().call(diff, TWO_I, s);
            ComplexFloat16Algebra.this.add().call(expIA, expMinusIA, sum);
            ComplexFloat16Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> TAN = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member sin = new ComplexFloat16Member();
            ComplexFloat16Member cos = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.sinAndCos().call(a, sin, cos);
            ComplexFloat16Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> CSC = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member sin = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.sin().call(a, sin);
            ComplexFloat16Algebra.this.invert().call(sin, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SEC = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member cos = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.cos().call(a, cos);
            ComplexFloat16Algebra.this.invert().call(cos, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> COT = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member tan = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.tan().call(a, tan);
            ComplexFloat16Algebra.this.invert().call(tan, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SINH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member expA = new ComplexFloat16Member();
            ComplexFloat16Member minusA = new ComplexFloat16Member();
            ComplexFloat16Member expMinusA = new ComplexFloat16Member();
            ComplexFloat16Member diff = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.exp().call(a, expA);
            ComplexFloat16Algebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexFloat16Algebra.this.exp().call(minusA, expMinusA);
            ComplexFloat16Algebra.this.subtract().call(expA, expMinusA, diff);
            ComplexFloat16Algebra.this.divide().call(diff, TWO, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> COSH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member expA = new ComplexFloat16Member();
            ComplexFloat16Member minusA = new ComplexFloat16Member();
            ComplexFloat16Member expMinusA = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.exp().call(a, expA);
            ComplexFloat16Algebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexFloat16Algebra.this.exp().call(minusA, expMinusA);
            ComplexFloat16Algebra.this.add().call(expA, expMinusA, sum);
            ComplexFloat16Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> SINHCOSH = new Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member s, ComplexFloat16Member c) {
            ComplexFloat16Member expA = new ComplexFloat16Member();
            ComplexFloat16Member minusA = new ComplexFloat16Member();
            ComplexFloat16Member expMinusA = new ComplexFloat16Member();
            ComplexFloat16Member sum = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.exp().call(a, expA);
            ComplexFloat16Algebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexFloat16Algebra.this.exp().call(minusA, expMinusA);
            ComplexFloat16Algebra.this.subtract().call(expA, expMinusA, sum);
            ComplexFloat16Algebra.this.divide().call(sum, TWO, s);
            ComplexFloat16Algebra.this.add().call(expA, expMinusA, sum);
            ComplexFloat16Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> TANH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member sinh = new ComplexFloat16Member();
            ComplexFloat16Member cosh = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.sinhAndCosh().call(a, sinh, cosh);
            ComplexFloat16Algebra.this.divide().call(sinh, cosh, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> CSCH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member sinh = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.sinh().call(a, sinh);
            ComplexFloat16Algebra.this.invert().call(sinh, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SECH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member cosh = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.cosh().call(a, cosh);
            ComplexFloat16Algebra.this.invert().call(cosh, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> COTH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member tanh = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.tanh().call(a, tanh);
            ComplexFloat16Algebra.this.invert().call(tanh, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> EXP = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            double constant = FastMath.exp((double)a.r());
            b.setR((float)(constant * FastMath.cos((double)a.i())));
            b.setI((float)(constant * FastMath.sin((double)a.i())));
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> EXPM1 = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member tmp = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.exp().call(a, tmp);
            ComplexFloat16Algebra.this.subtract().call(tmp, ONE, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> LOG = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            double modulus = FastMath.hypot((double)a.r(), (double)a.i());
            double argument = ComplexFloat16Algebra.this.getArgument(a);
            b.setR((float)Math.log(modulus));
            b.setI((float)ComplexFloat16Algebra.this.getPrincipalArgument(argument));
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> LOG1P = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Member tmp = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.add().call(a, ONE, tmp);
            ComplexFloat16Algebra.this.log().call(tmp, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SQRT = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> CBRT = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            ComplexFloat16Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, ComplexFloat16Member, ComplexFloat16Member> ROUND = new Procedure4<Round.Mode, Float16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, ComplexFloat16Member a, ComplexFloat16Member b) {
            Float16Member tmp = new Float16Member();
            tmp.setV(a.r());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setI(tmp.v());
        }
    };
    private final Function1<Boolean, ComplexFloat16Member> ISNAN = new Function1<Boolean, ComplexFloat16Member>(){

        @Override
        public Boolean call(ComplexFloat16Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i());
        }
    };
    private final Procedure1<ComplexFloat16Member> NAN = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            a.setR(Float.NaN);
            a.setI(Float.NaN);
        }
    };
    private final Function1<Boolean, ComplexFloat16Member> ISINF = new Function1<Boolean, ComplexFloat16Member>(){

        @Override
        public Boolean call(ComplexFloat16Member a) {
            return ComplexFloat16Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()));
        }
    };
    private final Procedure1<ComplexFloat16Member> INF = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            a.setR(Float.POSITIVE_INFINITY);
            a.setI(Float.POSITIVE_INFINITY);
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> POW = new Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b, ComplexFloat16Member c) {
            ComplexFloat16Member logA = new ComplexFloat16Member();
            ComplexFloat16Member bLogA = new ComplexFloat16Member();
            ComplexFloat16Algebra.this.log().call(a, logA);
            ComplexFloat16Algebra.this.multiply().call(b, logA, bLogA);
            ComplexFloat16Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure1<ComplexFloat16Member> RAND = new Procedure1<ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextFloat());
            a.setI(rng.nextFloat());
        }
    };
    private Procedure2<ComplexFloat16Member, Float16Member> REAL = new Procedure2<ComplexFloat16Member, Float16Member>(){

        @Override
        public void call(ComplexFloat16Member a, Float16Member b) {
            b.setV(a.r());
        }
    };
    private Procedure2<ComplexFloat16Member, ComplexFloat16Member> UNREAL = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            b.setR(0.0f);
            b.setI(a.i());
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SINCH = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            Sinch.compute(G.CHLF, a, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SINCHPI = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            Sinchpi.compute(G.CHLF, a, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SINC = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            Sinc.compute(G.CHLF, a, b);
        }
    };
    private final Procedure2<ComplexFloat16Member, ComplexFloat16Member> SINCPI = new Procedure2<ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16Member a, ComplexFloat16Member b) {
            Sincpi.compute(G.CHLF, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat16Member> ISZERO = new Function1<Boolean, ComplexFloat16Member>(){

        @Override
        public Boolean call(ComplexFloat16Member a) {
            return a.r() == 0.0f && a.i() == 0.0f;
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexFloat16Member, ComplexFloat16Member> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(HighPrecisionMember a, ComplexFloat16Member b, ComplexFloat16Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.floatValue());
        }
    };
    private final Procedure3<RationalMember, ComplexFloat16Member, ComplexFloat16Member> SBR = new Procedure3<RationalMember, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(RationalMember a, ComplexFloat16Member b, ComplexFloat16Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.floatValue());
        }
    };
    private final Procedure3<Double, ComplexFloat16Member, ComplexFloat16Member> SBD = new Procedure3<Double, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(Double a, ComplexFloat16Member b, ComplexFloat16Member c) {
            c.setR((float)(a * (double)b.r()));
            c.setI((float)(a * (double)b.i()));
        }
    };
    private final Procedure3<Float16Member, ComplexFloat16Member, ComplexFloat16Member> SC = new Procedure3<Float16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public void call(Float16Member a, ComplexFloat16Member b, ComplexFloat16Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
        }
    };
    private final Function3<Boolean, Float16Member, ComplexFloat16Member, ComplexFloat16Member> WITHIN = new Function3<Boolean, Float16Member, ComplexFloat16Member, ComplexFloat16Member>(){

        @Override
        public Boolean call(Float16Member tol, ComplexFloat16Member a, ComplexFloat16Member b) {
            return ComplexNumberWithin.compute(G.HLF, tol, a, b);
        }
    };

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, ComplexFloat16Member, ComplexFloat16Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexFloat16Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexFloat16Member, ComplexFloat16Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat16Member, ComplexFloat16Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public ComplexFloat16Member construct() {
        return new ComplexFloat16Member();
    }

    @Override
    public ComplexFloat16Member construct(ComplexFloat16Member other) {
        return new ComplexFloat16Member(other);
    }

    @Override
    public ComplexFloat16Member construct(String s) {
        return new ComplexFloat16Member(s);
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<ComplexFloat16Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<ComplexFloat16Member, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<ComplexFloat16Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<ComplexFloat16Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<ComplexFloat16Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<ComplexFloat16Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<ComplexFloat16Member> I() {
        return this.I_;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> asin() {
        return this.ASIN;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> acos() {
        return this.ACOS;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> atan() {
        return this.ATAN;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> acsc() {
        return this.ACSC;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> asec() {
        return this.ASEC;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> acot() {
        return this.ACOT;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> asinh() {
        return this.ASINH;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> acosh() {
        return this.ACOSH;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> atanh() {
        return this.ATANH;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> acsch() {
        return this.ACSCH;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> asech() {
        return this.ASECH;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> acoth() {
        return this.ACOTH;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> sinAndCos() {
        return this.SINCOS;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> tan() {
        return this.TAN;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> csc() {
        return this.CSC;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sec() {
        return this.SEC;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> cot() {
        return this.COT;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> sinhAndCosh() {
        return this.SINHCOSH;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> tanh() {
        return this.TANH;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> csch() {
        return this.CSCH;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sech() {
        return this.SECH;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> coth() {
        return this.COTH;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> exp() {
        return this.EXP;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> expm1() {
        return this.EXPM1;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> log() {
        return this.LOG;
    }

    private double getArgument(ComplexFloat16Member a) {
        double x = a.r();
        double y = a.i();
        double theta = x == 0.0 ? (y > 0.0 ? 1.5707963267948966 : (y < 0.0 ? -1.5707963267948966 : Double.NaN)) : (y == 0.0 ? (x > 0.0 ? 0.0 : Math.PI) : FastMath.atan2((double)y, (double)x));
        return theta;
    }

    private double getPrincipalArgument(double angle) {
        double arg;
        for (arg = angle; arg <= -Math.PI; arg += Math.PI * 2) {
        }
        while (arg > Math.PI) {
            arg -= Math.PI * 2;
        }
        return arg;
    }

    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> log1p() {
        return this.LOG1P;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, ComplexFloat16Member, ComplexFloat16Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat16Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat16Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat16Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat16Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<ComplexFloat16Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<ComplexFloat16Member, Float16Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<ComplexFloat16Member, ComplexFloat16Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Function1<Boolean, ComplexFloat16Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16Member, ComplexFloat16Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat16Member, ComplexFloat16Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat16Member, ComplexFloat16Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat16Member, ComplexFloat16Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float16Member, ComplexFloat16Member, ComplexFloat16Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float16Member, ComplexFloat16Member, ComplexFloat16Member> within() {
        return this.WITHIN;
    }
}

