/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16Algebra;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat16CartesianTensorProduct
implements TensorProduct<ComplexFloat16CartesianTensorProduct, ComplexFloat16CartesianTensorProductMember, ComplexFloat16Algebra, ComplexFloat16Member>,
ConstructibleNdLong<ComplexFloat16CartesianTensorProductMember>,
Norm<ComplexFloat16CartesianTensorProductMember, Float16Member>,
Scale<ComplexFloat16CartesianTensorProductMember, ComplexFloat16Member>,
Rounding<Float16Member, ComplexFloat16CartesianTensorProductMember>,
Infinite<ComplexFloat16CartesianTensorProductMember>,
NaN<ComplexFloat16CartesianTensorProductMember>,
ScaleByHighPrec<ComplexFloat16CartesianTensorProductMember>,
ScaleByRational<ComplexFloat16CartesianTensorProductMember>,
ScaleByDouble<ComplexFloat16CartesianTensorProductMember>,
Tolerance<Float16Member, ComplexFloat16CartesianTensorProductMember> {
    private final Function2<Boolean, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> EQ = new Function2<Boolean, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CHLF, G.HLF.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> NEQ = new Function2<Boolean, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            return ComplexFloat16CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> ASSIGN = new Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember from, ComplexFloat16CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.CHLF, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<ComplexFloat16CartesianTensorProductMember> ZER = new Procedure1<ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> NEG = new Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CHLF, G.CHLF.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> ADDEL = new Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b, ComplexFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHLF, G.CHLF.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> SUBEL = new Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b, ComplexFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHLF, G.CHLF.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<ComplexFloat16CartesianTensorProductMember, Float16Member> NORM = new Procedure2<ComplexFloat16CartesianTensorProductMember, Float16Member>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, Float16Member b) {
            TensorNorm.compute(G.CHLF, G.HLF, a.rawData(), b);
        }
    };
    private final Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> CONJ = new Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CHLF, G.CHLF.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> SCALE = new Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16Member scalar, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.CHLF, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> ADDSCALAR = new Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16Member scalar, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.CHLF, scalar, G.CHLF.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> SUBSCALAR = new Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16Member scalar, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            ComplexFloat16Member tmp = G.CHLF.construct();
            G.CHLF.negate().call(scalar, tmp);
            ComplexFloat16CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> MULEL = new Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b, ComplexFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHLF, G.CHLF.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> DIVIDEEL = new Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b, ComplexFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHLF, G.CHLF.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> MUL = new Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b, ComplexFloat16CartesianTensorProductMember c) {
            ComplexFloat16CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorContract.compute(G.CHLF, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> SEMI = new Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.CHLF_TEN, G.CHLF, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> COMMA = new Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.CHLF_TEN, G.CHLF, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> POWER = new Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorPower.compute(G.CHLF_TEN, power, a, b);
        }
    };
    private final Procedure1<ComplexFloat16CartesianTensorProductMember> UNITY = new Procedure1<ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember result) {
            TensorUnity.compute(G.CHLF_TEN, G.CHLF, result);
        }
    };
    private final Function1<Boolean, ComplexFloat16CartesianTensorProductMember> ISNAN = new Function1<Boolean, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat16CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.CHLF, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat16CartesianTensorProductMember> NAN = new Procedure1<ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a) {
            FillNaN.compute(G.CHLF, a);
        }
    };
    private final Function1<Boolean, ComplexFloat16CartesianTensorProductMember> ISINF = new Function1<Boolean, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat16CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.CHLF, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat16CartesianTensorProductMember> INF = new Procedure1<ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a) {
            FillInfinite.compute(G.CHLF, a);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorRound.compute(G.CHLF_TEN, G.CHLF, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat16CartesianTensorProductMember> ISZERO = new Function1<Boolean, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat16CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.CHLF, a.rawData());
        }
    };
    private final Procedure3<RationalMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> SBR = new Procedure3<RationalMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.CHLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> SBD = new Procedure3<Double, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.CHLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.CHLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16Member tol, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CHLF, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> MULBYSCALAR = new Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16Member factor, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            ComplexFloat16CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16Member factor, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            ComplexFloat16Member invFactor = G.CHLF.construct();
            G.CHLF.invert().call(factor, invFactor);
            ComplexFloat16CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> RAISE = new Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> LOWER = new Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            ComplexFloat16CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b, ComplexFloat16CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            ComplexFloat16CartesianTensorProductMember tmp = ComplexFloat16CartesianTensorProduct.this.construct();
            ComplexFloat16CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            ComplexFloat16CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> OUTER = new Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat16CartesianTensorProductMember a, ComplexFloat16CartesianTensorProductMember b, ComplexFloat16CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.CHLF_TEN, G.CHLF, a, b, c);
        }
    };

    @Override
    public ComplexFloat16CartesianTensorProductMember construct() {
        return new ComplexFloat16CartesianTensorProductMember();
    }

    @Override
    public ComplexFloat16CartesianTensorProductMember construct(ComplexFloat16CartesianTensorProductMember other) {
        return new ComplexFloat16CartesianTensorProductMember(other);
    }

    @Override
    public ComplexFloat16CartesianTensorProductMember construct(String s) {
        return new ComplexFloat16CartesianTensorProductMember(s);
    }

    @Override
    public ComplexFloat16CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new ComplexFloat16CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<ComplexFloat16CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<ComplexFloat16CartesianTensorProductMember, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexFloat16CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, ComplexFloat16CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat16CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat16CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat16CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat16CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember, ComplexFloat16CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

