/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.complex;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.MatrixReshape;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class ComplexFloat16MatrixMember
implements MatrixMember<ComplexFloat16Member>,
Gettable<ComplexFloat16MatrixMember>,
Settable<ComplexFloat16MatrixMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<ComplexFloat16Member> {
    private static final ComplexFloat16Member ZERO = new ComplexFloat16Member(0.0f, 0.0f);
    private IndexedDataSource<ComplexFloat16Member> storage;
    private long rows;
    private long cols;
    private StorageConstruction s;
    private static ThreadLocal<ComplexFloat16Member> tmpComp = new ThreadLocal<ComplexFloat16Member>(){

        @Override
        protected ComplexFloat16Member initialValue() {
            return new ComplexFloat16Member();
        }
    };

    public ComplexFloat16MatrixMember() {
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(0L, 0L);
    }

    public ComplexFloat16MatrixMember(ComplexFloat16MatrixMember other) {
        this.set(other);
    }

    public ComplexFloat16MatrixMember(int r, int c, float[] vals) {
        if (vals.length != r * c * 2) {
            throw new IllegalArgumentException("input values do not match declared shape");
        }
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(r, c);
        ComplexFloat16Member tmp = new ComplexFloat16Member();
        int compCount = vals.length / 2;
        for (int i = 0; i < compCount; ++i) {
            tmp.setR(vals[2 * i]);
            tmp.setI(vals[2 * i + 1]);
            this.storage.set(i, tmp);
        }
    }

    public ComplexFloat16MatrixMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.firstMatrixValues();
        long[] dimensions = rep.dimensions();
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(dimensions[1], dimensions[0]);
        ComplexFloat16Member tmp = new ComplexFloat16Member();
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            OctonionRepresentation val = data.get(i);
            tmp.setR(val.r().floatValue());
            tmp.setI(val.i().floatValue());
            this.storage.set(i, tmp);
        }
    }

    public ComplexFloat16MatrixMember(StorageConstruction s, long d1, long d2) {
        this.rows = -1L;
        this.cols = -1L;
        this.s = s;
        this.init(d2, d1);
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public long rows() {
        return this.rows;
    }

    @Override
    public long cols() {
        return this.cols;
    }

    @Override
    public boolean alloc(long r, long c) {
        if (this.rows != r || this.cols != c) {
            this.rows = r;
            this.cols = c;
        }
        if (this.storage == null || this.storage.size() != r * c) {
            this.storage = Storage.allocate(this.s, r * c, new ComplexFloat16Member());
            return true;
        }
        return false;
    }

    @Override
    public void init(long r, long c) {
        if (!this.alloc(r, c)) {
            long storageSize = r * c;
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    @Override
    public void v(long r, long c, ComplexFloat16Member value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.get(index, value);
    }

    @Override
    public void setV(long r, long c, ComplexFloat16Member value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.set(index, value);
    }

    @Override
    public void set(ComplexFloat16MatrixMember other) {
        if (this == other) {
            return;
        }
        this.rows = other.rows;
        this.cols = other.cols;
        this.s = other.s;
        this.storage = (IndexedDataSource)other.storage.duplicate();
    }

    @Override
    public void get(ComplexFloat16MatrixMember other) {
        if (this == other) {
            return;
        }
        other.rows = this.rows;
        other.cols = this.cols;
        other.s = this.s;
        other.storage = (IndexedDataSource)this.storage.duplicate();
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        ComplexFloat16Member value = new ComplexFloat16Member();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = BigDecimal.valueOf(value.r());
            BigDecimal im = BigDecimal.valueOf(value.i());
            OctonionRepresentation o = new OctonionRepresentation(re, im);
            values.set(i, o);
        }
        rep.setMatrix(this.rows, this.cols, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        ComplexFloat16Member value = new ComplexFloat16Member();
        BigList<OctonionRepresentation> mat = rep.getMatrix();
        this.alloc(rep.getMatrixRowDim(), rep.getMatrixColDim());
        long matSize = mat.size();
        for (long i = 0L; i < matSize; ++i) {
            OctonionRepresentation o = mat.get(i);
            value.setR(o.r().floatValue());
            value.setI(o.i().floatValue());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        ComplexFloat16Member tmp = new ComplexFloat16Member();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (long r = 0L; r < this.rows; ++r) {
            builder.append('[');
            for (long c = 0L; c < this.cols; ++c) {
                if (c != 0L) {
                    builder.append(',');
                }
                this.v(r, c, tmp);
                builder.append(tmp.toString());
            }
            builder.append(']');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public void reshape(long rows, long cols) {
        MatrixReshape.compute(G.CHLF_MAT, G.CHLF, rows, cols, this);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d == 0) {
            return this.cols;
        }
        if (d == 1) {
            return this.rows;
        }
        return 1L;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.FLOAT;
    }

    @Override
    public int componentCount() {
        return 2;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR(v);
        } else {
            tmp.setI(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR(v);
        } else {
            tmp.setI(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR(v);
        } else {
            tmp.setI(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR(v);
        } else {
            tmp.setI(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR(v);
        } else {
            tmp.setI(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR((float)v);
        } else {
            tmp.setI((float)v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR(v.floatValue());
        } else {
            tmp.setI(v.floatValue());
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        long c = index.get(0);
        long r = index.get(1);
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(r, c, tmp);
        if (component == 0) {
            tmp.setR(v.floatValue());
        } else {
            tmp.setI(v.floatValue());
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR(v);
            } else {
                tmp.setI(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR(v);
            } else {
                tmp.setI(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR(v);
            } else {
                tmp.setI(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR(v);
            } else {
                tmp.setI(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR(v);
            } else {
                tmp.setI(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR((float)v);
            } else {
                tmp.setI((float)v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR(v.floatValue());
            } else {
                tmp.setI(v.floatValue());
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            ComplexFloat16Member tmp = tmpComp.get();
            this.v(r, c, tmp);
            if (component == 0) {
                tmp.setR(v.floatValue());
            } else {
                tmp.setI(v.floatValue());
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return 0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (byte)tmp.r();
        }
        return (byte)tmp.i();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return 0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (short)tmp.r();
        }
        return (short)tmp.i();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return 0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (int)tmp.r();
        }
        return (int)tmp.i();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return 0L;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (long)tmp.r();
        }
        return (long)tmp.i();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return 0.0f;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return tmp.r();
        }
        return tmp.i();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return 0.0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return tmp.r();
        }
        return tmp.i();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return BigInteger.ZERO;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return BigDecimal.valueOf(tmp.r()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.i()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 1) {
            return BigDecimal.ZERO;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return BigDecimal.valueOf(tmp.r());
        }
        return BigDecimal.valueOf(tmp.i());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (byte)tmp.r();
        }
        return (byte)tmp.i();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (short)tmp.r();
        }
        return (short)tmp.i();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (int)tmp.r();
        }
        return (int)tmp.i();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return (long)tmp.r();
        }
        return (long)tmp.i();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return tmp.r();
        }
        return tmp.i();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return tmp.r();
        }
        return tmp.i();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return BigDecimal.valueOf(tmp.r()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.i()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 1;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        ComplexFloat16Member tmp = tmpComp.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component == 0) {
            return BigDecimal.valueOf(tmp.r());
        }
        return BigDecimal.valueOf(tmp.i());
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<ComplexFloat16Member> rawData() {
        return this.storage;
    }
}

