/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.CrossProduct;
import nom.bdezonia.zorbage.algorithm.DotProduct;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.PerpDotProduct;
import nom.bdezonia.zorbage.algorithm.RModuleAdd;
import nom.bdezonia.zorbage.algorithm.RModuleAssign;
import nom.bdezonia.zorbage.algorithm.RModuleConjugate;
import nom.bdezonia.zorbage.algorithm.RModuleDefaultNorm;
import nom.bdezonia.zorbage.algorithm.RModuleDirectProduct;
import nom.bdezonia.zorbage.algorithm.RModuleEqual;
import nom.bdezonia.zorbage.algorithm.RModuleNegate;
import nom.bdezonia.zorbage.algorithm.RModuleRound;
import nom.bdezonia.zorbage.algorithm.RModuleScale;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByDouble;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByRational;
import nom.bdezonia.zorbage.algorithm.RModuleSubtract;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Products;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.VectorSpace;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16Algebra;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16MatrixMember;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16VectorMember;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat16Vector
implements VectorSpace<ComplexFloat16Vector, ComplexFloat16VectorMember, ComplexFloat16Algebra, ComplexFloat16Member>,
Constructible1dLong<ComplexFloat16VectorMember>,
Norm<ComplexFloat16VectorMember, Float16Member>,
Products<ComplexFloat16VectorMember, ComplexFloat16Member, ComplexFloat16MatrixMember>,
DirectProduct<ComplexFloat16VectorMember, ComplexFloat16MatrixMember>,
Rounding<Float16Member, ComplexFloat16VectorMember>,
Infinite<ComplexFloat16VectorMember>,
NaN<ComplexFloat16VectorMember>,
ScaleByHighPrec<ComplexFloat16VectorMember>,
ScaleByRational<ComplexFloat16VectorMember>,
ScaleByDouble<ComplexFloat16VectorMember>,
Tolerance<Float16Member, ComplexFloat16VectorMember> {
    private final Procedure1<ComplexFloat16VectorMember> ZER = new Procedure1<ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember> NEG = new Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b) {
            RModuleNegate.compute(G.CHLF, a, b);
        }
    };
    private final Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> ADD = new Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c) {
            RModuleAdd.compute(G.CHLF, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> SUB = new Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c) {
            RModuleSubtract.compute(G.CHLF, a, b, c);
        }
    };
    private final Function2<Boolean, ComplexFloat16VectorMember, ComplexFloat16VectorMember> EQ = new Function2<Boolean, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public Boolean call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b) {
            return RModuleEqual.compute(G.CHLF, a, b);
        }
    };
    private final Function2<Boolean, ComplexFloat16VectorMember, ComplexFloat16VectorMember> NEQ = new Function2<Boolean, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public Boolean call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b) {
            return ComplexFloat16Vector.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember> ASSIGN = new Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember from, ComplexFloat16VectorMember to) {
            RModuleAssign.compute(G.CHLF, from, to);
        }
    };
    private final Procedure2<ComplexFloat16VectorMember, Float16Member> NORM = new Procedure2<ComplexFloat16VectorMember, Float16Member>(){

        @Override
        public void call(ComplexFloat16VectorMember a, Float16Member b) {
            RModuleDefaultNorm.compute(G.CHLF, G.HLF, a, b);
        }
    };
    private final Procedure3<ComplexFloat16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember> SCALE = new Procedure3<ComplexFloat16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16Member scalar, ComplexFloat16VectorMember a, ComplexFloat16VectorMember b) {
            RModuleScale.compute(G.CHLF, scalar, a, b);
        }
    };
    private final Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> CROSS = new Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c) {
            CrossProduct.compute(G.CHLF_VEC, G.CHLF, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member> DOT = new Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b, ComplexFloat16Member c) {
            DotProduct.compute(G.CHLF_VEC, G.CHLF, G.HLF, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member> PERP = new Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b, ComplexFloat16Member c) {
            PerpDotProduct.compute(G.CHLF_VEC, G.CHLF, a, b, c);
        }
    };
    private final Procedure4<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> VTRIPLE = new Procedure4<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c, ComplexFloat16VectorMember d) {
            ComplexFloat16VectorMember b_cross_c = new ComplexFloat16VectorMember(new float[6]);
            ComplexFloat16Vector.this.crossProduct().call(b, c, b_cross_c);
            ComplexFloat16Vector.this.crossProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure4<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member> STRIPLE = new Procedure4<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c, ComplexFloat16Member d) {
            ComplexFloat16VectorMember b_cross_c = new ComplexFloat16VectorMember(new float[6]);
            ComplexFloat16Vector.this.crossProduct().call(b, c, b_cross_c);
            ComplexFloat16Vector.this.dotProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember> CONJ = new Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a, ComplexFloat16VectorMember b) {
            RModuleConjugate.compute(G.CHLF, a, b);
        }
    };
    private final Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16MatrixMember> VDP = new Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16MatrixMember>(){

        @Override
        public void call(ComplexFloat16VectorMember in1, ComplexFloat16VectorMember in2, ComplexFloat16MatrixMember out) {
            ComplexFloat16Vector.this.directProduct().call(in1, in2, out);
        }
    };
    private final Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16MatrixMember> DP = new Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16MatrixMember>(){

        @Override
        public void call(ComplexFloat16VectorMember in1, ComplexFloat16VectorMember in2, ComplexFloat16MatrixMember out) {
            RModuleDirectProduct.compute(G.CHLF, in1, in2, out);
        }
    };
    private final Function1<Boolean, ComplexFloat16VectorMember> ISNAN = new Function1<Boolean, ComplexFloat16VectorMember>(){

        @Override
        public Boolean call(ComplexFloat16VectorMember a) {
            return SequenceIsNan.compute(G.CHLF, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat16VectorMember> NAN = new Procedure1<ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a) {
            FillNaN.compute(G.CHLF, a);
        }
    };
    private final Function1<Boolean, ComplexFloat16VectorMember> ISINF = new Function1<Boolean, ComplexFloat16VectorMember>(){

        @Override
        public Boolean call(ComplexFloat16VectorMember a) {
            return SequenceIsInf.compute(G.CHLF, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat16VectorMember> INF = new Procedure1<ComplexFloat16VectorMember>(){

        @Override
        public void call(ComplexFloat16VectorMember a) {
            FillInfinite.compute(G.CHLF, a);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember> ROUND = new Procedure4<Round.Mode, Float16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, ComplexFloat16VectorMember a, ComplexFloat16VectorMember b) {
            RModuleRound.compute(G.CHLF, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat16VectorMember> ISZERO = new Function1<Boolean, ComplexFloat16VectorMember>(){

        @Override
        public Boolean call(ComplexFloat16VectorMember a) {
            return SequenceIsZero.compute(G.CHLF, a.rawData());
        }
    };
    private Procedure3<HighPrecisionMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c) {
            RModuleScaleByHighPrec.compute(G.CHLF, a, b, c);
        }
    };
    private Procedure3<RationalMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> SBR = new Procedure3<RationalMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(RationalMember a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c) {
            RModuleScaleByRational.compute(G.CHLF, a, b, c);
        }
    };
    private Procedure3<Double, ComplexFloat16VectorMember, ComplexFloat16VectorMember> SBD = new Procedure3<Double, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public void call(Double a, ComplexFloat16VectorMember b, ComplexFloat16VectorMember c) {
            RModuleScaleByDouble.compute(G.CHLF, a, b, c);
        }
    };
    private final Function3<Boolean, Float16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember> WITHIN = new Function3<Boolean, Float16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember>(){

        @Override
        public Boolean call(Float16Member tol, ComplexFloat16VectorMember a, ComplexFloat16VectorMember b) {
            return SequencesSimilar.compute(G.CHLF, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure1<ComplexFloat16VectorMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexFloat16VectorMember, ComplexFloat16VectorMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat16VectorMember, ComplexFloat16VectorMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public ComplexFloat16VectorMember construct() {
        return new ComplexFloat16VectorMember();
    }

    @Override
    public ComplexFloat16VectorMember construct(ComplexFloat16VectorMember other) {
        return new ComplexFloat16VectorMember(other);
    }

    @Override
    public ComplexFloat16VectorMember construct(String s) {
        return new ComplexFloat16VectorMember(s);
    }

    @Override
    public ComplexFloat16VectorMember construct(StorageConstruction s, long d1) {
        return new ComplexFloat16VectorMember(s, d1);
    }

    @Override
    public Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<ComplexFloat16VectorMember, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure3<ComplexFloat16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> crossProduct() {
        return this.CROSS;
    }

    @Override
    public Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member> dotProduct() {
        return this.DOT;
    }

    @Override
    public Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member> perpDotProduct() {
        return this.PERP;
    }

    @Override
    public Procedure4<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> vectorTripleProduct() {
        return this.VTRIPLE;
    }

    @Override
    public Procedure4<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16Member> scalarTripleProduct() {
        return this.STRIPLE;
    }

    @Override
    public Procedure2<ComplexFloat16VectorMember, ComplexFloat16VectorMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16MatrixMember> vectorDirectProduct() {
        return this.VDP;
    }

    @Override
    public Procedure3<ComplexFloat16VectorMember, ComplexFloat16VectorMember, ComplexFloat16MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Function1<Boolean, ComplexFloat16VectorMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat16VectorMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat16VectorMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat16VectorMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat16VectorMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat16VectorMember, ComplexFloat16VectorMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat16VectorMember, ComplexFloat16VectorMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float16Member, ComplexFloat16VectorMember, ComplexFloat16VectorMember> within() {
        return this.WITHIN;
    }
}

