/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.octonion;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.OctonionNumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OctonionConstants;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float16.complex.ComplexFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.octonion.OctonionFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class OctonionFloat16Algebra
implements SkewField<OctonionFloat16Algebra, OctonionFloat16Member>,
Conjugate<OctonionFloat16Member>,
Norm<OctonionFloat16Member, Float16Member>,
Infinite<OctonionFloat16Member>,
NaN<OctonionFloat16Member>,
Rounding<Float16Member, OctonionFloat16Member>,
RealConstants<OctonionFloat16Member>,
ImaginaryConstants<OctonionFloat16Member>,
QuaternionConstants<OctonionFloat16Member>,
OctonionConstants<OctonionFloat16Member>,
Random<OctonionFloat16Member>,
Exponential<OctonionFloat16Member>,
Trigonometric<OctonionFloat16Member>,
Hyperbolic<OctonionFloat16Member>,
Power<OctonionFloat16Member>,
Roots<OctonionFloat16Member>,
RealUnreal<OctonionFloat16Member, Float16Member>,
Scale<OctonionFloat16Member, OctonionFloat16Member>,
ScaleByHighPrec<OctonionFloat16Member>,
ScaleByRational<OctonionFloat16Member>,
ScaleByDouble<OctonionFloat16Member>,
ScaleComponents<OctonionFloat16Member, Float16Member>,
Tolerance<Float16Member, OctonionFloat16Member> {
    private static final OctonionFloat16Member ZERO = new OctonionFloat16Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member ONE_THIRD = new OctonionFloat16Member(0.33333334f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member ONE_HALF = new OctonionFloat16Member(0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member ONE = new OctonionFloat16Member(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member TWO = new OctonionFloat16Member(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member E = new OctonionFloat16Member((float)Math.E, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member PI = new OctonionFloat16Member((float)Math.PI, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member GAMMA = new OctonionFloat16Member(0.5772157f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member PHI = new OctonionFloat16Member(1.618034f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member I = new OctonionFloat16Member(0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member J = new OctonionFloat16Member(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member K = new OctonionFloat16Member(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member L = new OctonionFloat16Member(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member I0 = new OctonionFloat16Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private static final OctonionFloat16Member J0 = new OctonionFloat16Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    private static final OctonionFloat16Member K0 = new OctonionFloat16Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    private final Procedure1<OctonionFloat16Member> UNITY = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> MUL = new Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b, OctonionFloat16Member c) {
            OctonionFloat16Member tmp = new OctonionFloat16Member(ZERO);
            tmp.setR(a.r() * b.r());
            tmp.setI(a.r() * b.i());
            tmp.setJ(a.r() * b.j());
            tmp.setK(a.r() * b.k());
            tmp.setL(a.r() * b.l());
            tmp.setI0(a.r() * b.i0());
            tmp.setJ0(a.r() * b.j0());
            tmp.setK0(a.r() * b.k0());
            tmp.setI(tmp.i() + a.i() * b.r());
            tmp.setR(tmp.r() - a.i() * b.i());
            tmp.setK(tmp.k() + a.i() * b.j());
            tmp.setJ(tmp.j() - a.i() * b.k());
            tmp.setI0(tmp.i0() + a.i() * b.l());
            tmp.setL(tmp.l() - a.i() * b.i0());
            tmp.setK0(tmp.k0() - a.i() * b.j0());
            tmp.setJ0(tmp.j0() + a.i() * b.k0());
            tmp.setJ(tmp.j() + a.j() * b.r());
            tmp.setK(tmp.k() - a.j() * b.i());
            tmp.setR(tmp.r() - a.j() * b.j());
            tmp.setI(tmp.i() + a.j() * b.k());
            tmp.setJ0(tmp.j0() + a.j() * b.l());
            tmp.setK0(tmp.k0() + a.j() * b.i0());
            tmp.setL(tmp.l() - a.j() * b.j0());
            tmp.setI0(tmp.i0() - a.j() * b.k0());
            tmp.setK(tmp.k() + a.k() * b.r());
            tmp.setJ(tmp.j() + a.k() * b.i());
            tmp.setI(tmp.i() - a.k() * b.j());
            tmp.setR(tmp.r() - a.k() * b.k());
            tmp.setK0(tmp.k0() + a.k() * b.l());
            tmp.setJ0(tmp.j0() - a.k() * b.i0());
            tmp.setI0(tmp.i0() + a.k() * b.j0());
            tmp.setL(tmp.l() - a.k() * b.k0());
            tmp.setL(tmp.l() + a.l() * b.r());
            tmp.setI0(tmp.i0() - a.l() * b.i());
            tmp.setJ0(tmp.j0() - a.l() * b.j());
            tmp.setK0(tmp.k0() - a.l() * b.k());
            tmp.setR(tmp.r() - a.l() * b.l());
            tmp.setI(tmp.i() + a.l() * b.i0());
            tmp.setJ(tmp.j() + a.l() * b.j0());
            tmp.setK(tmp.k() + a.l() * b.k0());
            tmp.setI0(tmp.i0() + a.i0() * b.r());
            tmp.setL(tmp.l() + a.i0() * b.i());
            tmp.setK0(tmp.k0() - a.i0() * b.j());
            tmp.setJ0(tmp.j0() + a.i0() * b.k());
            tmp.setI(tmp.i() - a.i0() * b.l());
            tmp.setR(tmp.r() - a.i0() * b.i0());
            tmp.setK(tmp.k() - a.i0() * b.j0());
            tmp.setJ(tmp.j() + a.i0() * b.k0());
            tmp.setJ0(tmp.j0() + a.j0() * b.r());
            tmp.setK0(tmp.k0() + a.j0() * b.i());
            tmp.setL(tmp.l() + a.j0() * b.j());
            tmp.setI0(tmp.i0() - a.j0() * b.k());
            tmp.setJ(tmp.j() - a.j0() * b.l());
            tmp.setK(tmp.k() + a.j0() * b.i0());
            tmp.setR(tmp.r() - a.j0() * b.j0());
            tmp.setI(tmp.i() - a.j0() * b.k0());
            tmp.setK0(tmp.k0() + a.k0() * b.r());
            tmp.setJ0(tmp.j0() - a.k0() * b.i());
            tmp.setI0(tmp.i0() + a.k0() * b.j());
            tmp.setL(tmp.l() + a.k0() * b.k());
            tmp.setK(tmp.k() - a.k0() * b.l());
            tmp.setJ(tmp.j() - a.k0() * b.i0());
            tmp.setI(tmp.i() + a.k0() * b.j0());
            tmp.setR(tmp.r() - a.k0() * b.k0());
            OctonionFloat16Algebra.this.assign().call(tmp, c);
        }
    };
    private final Procedure3<Integer, OctonionFloat16Member, OctonionFloat16Member> POWER = new Procedure3<Integer, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(Integer power, OctonionFloat16Member a, OctonionFloat16Member b) {
            PowerAny.compute(G.OHLF, power, a, b);
        }
    };
    private final Procedure1<OctonionFloat16Member> ZER = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> NEG = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Algebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> ADD = new Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b, OctonionFloat16Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
            c.setJ(a.j() + b.j());
            c.setK(a.k() + b.k());
            c.setL(a.l() + b.l());
            c.setI0(a.i0() + b.i0());
            c.setJ0(a.j0() + b.j0());
            c.setK0(a.k0() + b.k0());
        }
    };
    private final Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> SUB = new Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b, OctonionFloat16Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
            c.setJ(a.j() - b.j());
            c.setK(a.k() - b.k());
            c.setL(a.l() - b.l());
            c.setI0(a.i0() - b.i0());
            c.setJ0(a.j0() - b.j0());
            c.setK0(a.k0() - b.k0());
        }
    };
    private Function2<Boolean, OctonionFloat16Member, OctonionFloat16Member> EQ = new Function2<Boolean, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public Boolean call(OctonionFloat16Member a, OctonionFloat16Member b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k() && a.l() == b.l() && a.i0() == b.i0() && a.j0() == b.j0() && a.k0() == b.k0();
        }
    };
    private Function2<Boolean, OctonionFloat16Member, OctonionFloat16Member> NEQ = new Function2<Boolean, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public Boolean call(OctonionFloat16Member a, OctonionFloat16Member b) {
            return OctonionFloat16Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<OctonionFloat16Member, OctonionFloat16Member> ASSIGN = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member from, OctonionFloat16Member to) {
            to.set(from);
        }
    };
    private Procedure2<OctonionFloat16Member, OctonionFloat16Member> INV = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            double norm2 = OctonionFloat16Algebra.this.norm2(a);
            OctonionFloat16Algebra.this.conjugate().call(a, b);
            b.setR((float)((double)b.r() / norm2));
            b.setI((float)((double)b.i() / norm2));
            b.setJ((float)((double)b.j() / norm2));
            b.setK((float)((double)b.k() / norm2));
            b.setL((float)((double)b.l() / norm2));
            b.setI0((float)((double)b.i0() / norm2));
            b.setJ0((float)((double)b.j0() / norm2));
            b.setK0((float)((double)b.k0() / norm2));
        }
    };
    private final Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> DIVIDE = new Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b, OctonionFloat16Member c) {
            OctonionFloat16Member tmp = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.invert().call(b, tmp);
            OctonionFloat16Algebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, OctonionFloat16Member, OctonionFloat16Member> ROUND = new Procedure4<Round.Mode, Float16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, OctonionFloat16Member a, OctonionFloat16Member b) {
            Float16Member tmp = new Float16Member();
            tmp.setV(a.r());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setI(tmp.v());
            tmp.setV(a.j());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setJ(tmp.v());
            tmp.setV(a.k());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setK(tmp.v());
            tmp.setV(a.l());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setL(tmp.v());
            tmp.setV(a.i0());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setI0(tmp.v());
            tmp.setV(a.j0());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setJ0(tmp.v());
            tmp.setV(a.k0());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setK0(tmp.v());
        }
    };
    private Function1<Boolean, OctonionFloat16Member> ISNAN = new Function1<Boolean, OctonionFloat16Member>(){

        @Override
        public Boolean call(OctonionFloat16Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i()) || Double.isNaN(a.j()) || Double.isNaN(a.k()) || Double.isNaN(a.l()) || Double.isNaN(a.i0()) || Double.isNaN(a.j0()) || Double.isNaN(a.k0());
        }
    };
    private final Procedure1<OctonionFloat16Member> NAN = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            a.setR(Float.NaN);
            a.setI(Float.NaN);
            a.setJ(Float.NaN);
            a.setK(Float.NaN);
            a.setL(Float.NaN);
            a.setI0(Float.NaN);
            a.setJ0(Float.NaN);
            a.setK0(Float.NaN);
        }
    };
    private Function1<Boolean, OctonionFloat16Member> ISINF = new Function1<Boolean, OctonionFloat16Member>(){

        @Override
        public Boolean call(OctonionFloat16Member a) {
            return OctonionFloat16Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()) || Double.isInfinite(a.j()) || Double.isInfinite(a.k()) || Double.isInfinite(a.l()) || Double.isInfinite(a.i0()) || Double.isInfinite(a.j0()) || Double.isInfinite(a.k0()));
        }
    };
    private final Procedure1<OctonionFloat16Member> INF = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            a.setR(Float.POSITIVE_INFINITY);
            a.setI(Float.POSITIVE_INFINITY);
            a.setJ(Float.POSITIVE_INFINITY);
            a.setK(Float.POSITIVE_INFINITY);
            a.setL(Float.POSITIVE_INFINITY);
            a.setI0(Float.POSITIVE_INFINITY);
            a.setJ0(Float.POSITIVE_INFINITY);
            a.setK0(Float.POSITIVE_INFINITY);
        }
    };
    private final Procedure2<OctonionFloat16Member, Float16Member> NORM = new Procedure2<OctonionFloat16Member, Float16Member>(){

        @Override
        public void call(OctonionFloat16Member a, Float16Member b) {
            b.setV((float)OctonionFloat16Algebra.this.norm(a));
        }
    };
    private Procedure2<OctonionFloat16Member, OctonionFloat16Member> CONJ = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            b.setR(a.r());
            b.setI(-a.i());
            b.setJ(-a.j());
            b.setK(-a.k());
            b.setL(-a.l());
            b.setI0(-a.i0());
            b.setJ0(-a.j0());
            b.setK0(-a.k0());
        }
    };
    private final Procedure1<OctonionFloat16Member> PI_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> E_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> GAMMA_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> PHI_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> I_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> J_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> K_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(K, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> L_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(L, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> I0_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(I0, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> J0_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(J0, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> K0_ = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            OctonionFloat16Algebra.this.assign().call(K0, a);
        }
    };
    private final Procedure1<OctonionFloat16Member> RAND = new Procedure1<OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextFloat());
            a.setI(rng.nextFloat());
            a.setJ(rng.nextFloat());
            a.setK(rng.nextFloat());
            a.setL(rng.nextFloat());
            a.setI0(rng.nextFloat());
            a.setJ0(rng.nextFloat());
            a.setK0(rng.nextFloat());
        }
    };
    private final Procedure2<OctonionFloat16Member, Float16Member> REAL = new Procedure2<OctonionFloat16Member, Float16Member>(){

        @Override
        public void call(OctonionFloat16Member a, Float16Member b) {
            b.setV(a.r());
        }
    };
    private Procedure2<OctonionFloat16Member, OctonionFloat16Member> UNREAL = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Algebra.this.assign().call(a, b);
            b.setR(0.0f);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> SINH = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Member negA = new OctonionFloat16Member();
            OctonionFloat16Member sum = new OctonionFloat16Member();
            OctonionFloat16Member tmp1 = new OctonionFloat16Member();
            OctonionFloat16Member tmp2 = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.negate().call(a, negA);
            OctonionFloat16Algebra.this.exp().call(a, tmp1);
            OctonionFloat16Algebra.this.exp().call(negA, tmp2);
            OctonionFloat16Algebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionFloat16Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private Procedure2<OctonionFloat16Member, OctonionFloat16Member> COSH = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Member negA = new OctonionFloat16Member();
            OctonionFloat16Member sum = new OctonionFloat16Member();
            OctonionFloat16Member tmp1 = new OctonionFloat16Member();
            OctonionFloat16Member tmp2 = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.negate().call(a, negA);
            OctonionFloat16Algebra.this.exp().call(a, tmp1);
            OctonionFloat16Algebra.this.exp().call(negA, tmp2);
            OctonionFloat16Algebra.this.add().call(tmp1, tmp2, sum);
            OctonionFloat16Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> SINHANDCOSH = new Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member s, OctonionFloat16Member c) {
            OctonionFloat16Member negA = new OctonionFloat16Member();
            OctonionFloat16Member sum = new OctonionFloat16Member();
            OctonionFloat16Member tmp1 = new OctonionFloat16Member();
            OctonionFloat16Member tmp2 = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.negate().call(a, negA);
            OctonionFloat16Algebra.this.exp().call(a, tmp1);
            OctonionFloat16Algebra.this.exp().call(negA, tmp2);
            OctonionFloat16Algebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionFloat16Algebra.this.divide().call(sum, TWO, s);
            OctonionFloat16Algebra.this.add().call(tmp1, tmp2, sum);
            OctonionFloat16Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> TANH = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Member s = new OctonionFloat16Member();
            OctonionFloat16Member c = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.sinhAndCosh().call(a, s, c);
            OctonionFloat16Algebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> SIN = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            OctonionFloat16Member tmp = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.unreal().call(a, tmp);
            OctonionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            b.setR((float)(sin * cosh));
            b.setI((float)(ws * (double)a.i()));
            b.setJ((float)(ws * (double)a.j()));
            b.setK((float)(ws * (double)a.k()));
            b.setL((float)(ws * (double)a.l()));
            b.setI0((float)(ws * (double)a.i0()));
            b.setJ0((float)(ws * (double)a.j0()));
            b.setK0((float)(ws * (double)a.k0()));
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> COS = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            OctonionFloat16Member tmp = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.unreal().call(a, tmp);
            OctonionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double wc = -sin * sinhc_pi;
            b.setR((float)(cos * cosh));
            b.setI((float)(wc * (double)a.i()));
            b.setJ((float)(wc * (double)a.j()));
            b.setK((float)(wc * (double)a.k()));
            b.setL((float)(wc * (double)a.l()));
            b.setI0((float)(wc * (double)a.i0()));
            b.setJ0((float)(wc * (double)a.j0()));
            b.setK0((float)(wc * (double)a.k0()));
        }
    };
    private final Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> SINANDCOS = new Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member s, OctonionFloat16Member c) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            OctonionFloat16Member tmp = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.unreal().call(a, tmp);
            OctonionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            double wc = -sin * sinhc_pi;
            s.setR((float)(sin * cosh));
            s.setI((float)(ws * (double)a.i()));
            s.setJ((float)(ws * (double)a.j()));
            s.setK((float)(ws * (double)a.k()));
            s.setL((float)(ws * (double)a.l()));
            s.setI0((float)(ws * (double)a.i0()));
            s.setJ0((float)(ws * (double)a.j0()));
            s.setK0((float)(ws * (double)a.k0()));
            c.setR((float)(cos * cosh));
            c.setI((float)(wc * (double)a.i()));
            c.setJ((float)(wc * (double)a.j()));
            c.setK((float)(wc * (double)a.k()));
            c.setL((float)(wc * (double)a.l()));
            c.setI0((float)(wc * (double)a.i0()));
            c.setJ0((float)(wc * (double)a.j0()));
            c.setK0((float)(wc * (double)a.k0()));
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> TAN = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Member sin = new OctonionFloat16Member();
            OctonionFloat16Member cos = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.sinAndCos().call(a, sin, cos);
            OctonionFloat16Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> EXP = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            OctonionFloat16Member tmp = new OctonionFloat16Member();
            double u = FastMath.exp((double)a.r());
            OctonionFloat16Algebra.this.unreal().call(a, tmp);
            OctonionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinc().call(z, z2);
            double w = z2.v();
            b.setR((float)(u * FastMath.cos((double)z.v())));
            b.setI((float)(u * w * (double)a.i()));
            b.setJ((float)(u * w * (double)a.j()));
            b.setK((float)(u * w * (double)a.k()));
            b.setL((float)(u * w * (double)a.l()));
            b.setI0((float)(u * w * (double)a.i0()));
            b.setJ0((float)(u * w * (double)a.j0()));
            b.setK0((float)(u * w * (double)a.k0()));
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> LOG = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Member unreal = new OctonionFloat16Member();
            ComplexFloat16Member tmp = new ComplexFloat16Member();
            Float16Member norm = new Float16Member();
            OctonionFloat16Algebra.this.assign().call(a, b);
            OctonionFloat16Algebra.this.unreal().call(a, unreal);
            OctonionFloat16Algebra.this.norm().call(unreal, norm);
            tmp.setR(a.r());
            tmp.setI(norm.v());
            G.CHLF.log().call(tmp, tmp);
            double factor = (double)norm.v() == 0.0 ? (double)tmp.i() : (double)(tmp.i() / norm.v());
            OctonionFloat16Algebra.this.multiplier(tmp.r(), factor, b);
        }
    };
    private final Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> POW = new Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b, OctonionFloat16Member c) {
            OctonionFloat16Member logA = new OctonionFloat16Member();
            OctonionFloat16Member bLogA = new OctonionFloat16Member();
            OctonionFloat16Algebra.this.log().call(a, logA);
            OctonionFloat16Algebra.this.multiply().call(b, logA, bLogA);
            OctonionFloat16Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> SINCH = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            Sinch.compute(G.OHLF, a, b);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> SINCHPI = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            Sinchpi.compute(G.OHLF, a, b);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> SINC = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            Sinc.compute(G.OHLF, a, b);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> SINCPI = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            Sincpi.compute(G.OHLF, a, b);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> SQRT = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<OctonionFloat16Member, OctonionFloat16Member> CBRT = new Procedure2<OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(OctonionFloat16Member a, OctonionFloat16Member b) {
            OctonionFloat16Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, OctonionFloat16Member> ISZERO = new Function1<Boolean, OctonionFloat16Member>(){

        @Override
        public Boolean call(OctonionFloat16Member a) {
            return a.r() == 0.0f && a.i() == 0.0f && a.j() == 0.0f && a.k() == 0.0f && a.l() == 0.0f && a.i0() == 0.0f && a.j0() == 0.0f && a.k0() == 0.0f;
        }
    };
    private final Procedure3<HighPrecisionMember, OctonionFloat16Member, OctonionFloat16Member> SBHP = new Procedure3<HighPrecisionMember, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(HighPrecisionMember a, OctonionFloat16Member b, OctonionFloat16Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j()));
            c.setJ(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k()));
            c.setK(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.l()));
            c.setL(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i0()));
            c.setI0(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j0()));
            c.setJ0(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k0()));
            c.setK0(tmp.floatValue());
        }
    };
    private final Procedure3<RationalMember, OctonionFloat16Member, OctonionFloat16Member> SBR = new Procedure3<RationalMember, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(RationalMember a, OctonionFloat16Member b, OctonionFloat16Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.j());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.k());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.l());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setL(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.i0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI0(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.j0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ0(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.k0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK0(tmp.floatValue());
        }
    };
    private final Procedure3<Double, OctonionFloat16Member, OctonionFloat16Member> SBD = new Procedure3<Double, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(Double a, OctonionFloat16Member b, OctonionFloat16Member c) {
            c.setR((float)(a * (double)b.r()));
            c.setI((float)(a * (double)b.i()));
            c.setJ((float)(a * (double)b.j()));
            c.setK((float)(a * (double)b.k()));
            c.setL((float)(a * (double)b.l()));
            c.setI0((float)(a * (double)b.i0()));
            c.setJ0((float)(a * (double)b.j0()));
            c.setK0((float)(a * (double)b.k0()));
        }
    };
    private final Procedure3<Float16Member, OctonionFloat16Member, OctonionFloat16Member> SC = new Procedure3<Float16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public void call(Float16Member a, OctonionFloat16Member b, OctonionFloat16Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
            c.setJ(a.v() * b.j());
            c.setK(a.v() * b.k());
            c.setL(a.v() * b.l());
            c.setI0(a.v() * b.i0());
            c.setJ0(a.v() * b.j0());
            c.setK0(a.v() * b.k0());
        }
    };
    private final Function3<Boolean, Float16Member, OctonionFloat16Member, OctonionFloat16Member> WITHIN = new Function3<Boolean, Float16Member, OctonionFloat16Member, OctonionFloat16Member>(){

        @Override
        public Boolean call(Float16Member tol, OctonionFloat16Member a, OctonionFloat16Member b) {
            return OctonionNumberWithin.compute(G.HLF, tol, a, b);
        }
    };

    @Override
    public Procedure1<OctonionFloat16Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, OctonionFloat16Member, OctonionFloat16Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<OctonionFloat16Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, OctonionFloat16Member, OctonionFloat16Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, OctonionFloat16Member, OctonionFloat16Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public OctonionFloat16Member construct() {
        return new OctonionFloat16Member();
    }

    @Override
    public OctonionFloat16Member construct(OctonionFloat16Member other) {
        return new OctonionFloat16Member(other);
    }

    @Override
    public OctonionFloat16Member construct(String s) {
        return new OctonionFloat16Member(s);
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, OctonionFloat16Member, OctonionFloat16Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, OctonionFloat16Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<OctonionFloat16Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, OctonionFloat16Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<OctonionFloat16Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<OctonionFloat16Member, Float16Member> norm() {
        return this.NORM;
    }

    private double norm(OctonionFloat16Member a) {
        double max = Math.max(Math.abs(a.r()), Math.abs(a.i()));
        max = Math.max(max, (double)Math.abs(a.j()));
        max = Math.max(max, (double)Math.abs(a.k()));
        max = Math.max(max, (double)Math.abs(a.l()));
        max = Math.max(max, (double)Math.abs(a.i0()));
        max = Math.max(max, (double)Math.abs(a.j0()));
        if ((max = Math.max(max, (double)Math.abs(a.k0()))) == 0.0) {
            return 0.0;
        }
        double sum = (double)a.r() / max * ((double)a.r() / max);
        sum += (double)a.i() / max * ((double)a.i() / max);
        sum += (double)a.j() / max * ((double)a.j() / max);
        sum += (double)a.k() / max * ((double)a.k() / max);
        sum += (double)a.l() / max * ((double)a.l() / max);
        sum += (double)a.i0() / max * ((double)a.i0() / max);
        sum += (double)a.j0() / max * ((double)a.j0() / max);
        return max * Math.sqrt(sum += (double)a.k0() / max * ((double)a.k0() / max));
    }

    private double norm2(OctonionFloat16Member a) {
        double norm = this.norm(a);
        return norm * norm;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure1<OctonionFloat16Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> I() {
        return this.I_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> J() {
        return this.J_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> K() {
        return this.K_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> L() {
        return this.L_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> I0() {
        return this.I0_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> J0() {
        return this.J0_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> K0() {
        return this.K0_;
    }

    @Override
    public Procedure1<OctonionFloat16Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<OctonionFloat16Member, Float16Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> tan() {
        return this.TAN;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> log() {
        return this.LOG;
    }

    private void multiplier(double r, double factor, OctonionFloat16Member result) {
        if (Double.isNaN(factor) || Double.isInfinite(factor)) {
            if (result.i() == 0.0f && result.j() == 0.0f && result.k() == 0.0f) {
                result.setR((float)r);
                result.setI((float)((double)result.i() * factor));
                result.setJ((float)((double)result.j() * factor));
                result.setK((float)((double)result.k() * factor));
                result.setL((float)((double)result.l() * factor));
                result.setI0((float)((double)result.i0() * factor));
                result.setJ0((float)((double)result.j0() * factor));
                result.setK0((float)((double)result.k0() * factor));
            } else {
                double signum = Math.signum(factor);
                result.setR((float)r);
                if (result.i() == 0.0f) {
                    result.setI((float)(signum * (double)result.i()));
                } else {
                    result.setI((float)(factor * (double)result.i()));
                }
                if (result.j() == 0.0f) {
                    result.setJ((float)(signum * (double)result.j()));
                } else {
                    result.setJ((float)(factor * (double)result.j()));
                }
                if (result.k() == 0.0f) {
                    result.setK((float)(signum * (double)result.k()));
                } else {
                    result.setK((float)(factor * (double)result.k()));
                }
                if (result.l() == 0.0f) {
                    result.setL((float)(signum * (double)result.l()));
                } else {
                    result.setL((float)(factor * (double)result.l()));
                }
                if (result.i0() == 0.0f) {
                    result.setI0((float)(signum * (double)result.i0()));
                } else {
                    result.setI0((float)(factor * (double)result.i0()));
                }
                if (result.j0() == 0.0f) {
                    result.setJ0((float)(signum * (double)result.j0()));
                } else {
                    result.setJ0((float)(factor * (double)result.j0()));
                }
                if (result.k0() == 0.0f) {
                    result.setK0((float)(signum * (double)result.k0()));
                } else {
                    result.setK0((float)(factor * (double)result.k0()));
                }
            }
        } else {
            result.setR((float)r);
            result.setI((float)((double)result.i() * factor));
            result.setJ((float)((double)result.j() * factor));
            result.setK((float)((double)result.k() * factor));
            result.setL((float)((double)result.l() * factor));
            result.setI0((float)((double)result.i0() * factor));
            result.setJ0((float)((double)result.j0() * factor));
            result.setK0((float)((double)result.k0() * factor));
        }
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<OctonionFloat16Member, OctonionFloat16Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, OctonionFloat16Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<OctonionFloat16Member, OctonionFloat16Member, OctonionFloat16Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, OctonionFloat16Member, OctonionFloat16Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, OctonionFloat16Member, OctonionFloat16Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, OctonionFloat16Member, OctonionFloat16Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float16Member, OctonionFloat16Member, OctonionFloat16Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float16Member, OctonionFloat16Member, OctonionFloat16Member> within() {
        return this.WITHIN;
    }
}

