/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.octonion;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetOctonion;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetOctonion;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Util;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;

public final class OctonionFloat16Member
implements NumberMember<OctonionFloat16Member>,
ShortCoder,
Allocatable<OctonionFloat16Member>,
Duplicatable<OctonionFloat16Member>,
Settable<OctonionFloat16Member>,
Gettable<OctonionFloat16Member>,
PrimitiveConversion,
UniversalRepresentation,
SetOctonion<Float16Member>,
GetOctonion<Float16Member> {
    private static final short ZERO = Float16Util.convertFloatToHFloat(0.0f);
    private short r;
    private short i;
    private short j;
    private short k;
    private short l;
    private short i0;
    private short j0;
    private short k0;

    public OctonionFloat16Member() {
        this.primitiveInit();
    }

    public OctonionFloat16Member(float r, float i, float j, float k, float l, float i0, float j0, float k0) {
        this.setR(r);
        this.setI(i);
        this.setJ(j);
        this.setK(k);
        this.setL(l);
        this.setI0(i0);
        this.setJ0(j0);
        this.setK0(k0);
    }

    public OctonionFloat16Member(OctonionFloat16Member value) {
        this.set(value);
    }

    public OctonionFloat16Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        this.setR(val.r().floatValue());
        this.setI(val.i().floatValue());
        this.setJ(val.j().floatValue());
        this.setK(val.k().floatValue());
        this.setL(val.l().floatValue());
        this.setI0(val.i0().floatValue());
        this.setJ0(val.j0().floatValue());
        this.setK0(val.k0().floatValue());
    }

    public float r() {
        return Float16Util.convertHFloatToFloat(this.r);
    }

    public float i() {
        return Float16Util.convertHFloatToFloat(this.i);
    }

    public float j() {
        return Float16Util.convertHFloatToFloat(this.j);
    }

    public float k() {
        return Float16Util.convertHFloatToFloat(this.k);
    }

    public float l() {
        return Float16Util.convertHFloatToFloat(this.l);
    }

    public float i0() {
        return Float16Util.convertHFloatToFloat(this.i0);
    }

    public float j0() {
        return Float16Util.convertHFloatToFloat(this.j0);
    }

    public float k0() {
        return Float16Util.convertHFloatToFloat(this.k0);
    }

    @Override
    public void setR(float val) {
        this.r = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setI(float val) {
        this.i = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setJ(float val) {
        this.j = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setK(float val) {
        this.k = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setL(float val) {
        this.l = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setI0(float val) {
        this.i0 = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setJ0(float val) {
        this.j0 = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setK0(float val) {
        this.k0 = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void set(OctonionFloat16Member other) {
        this.r = other.r;
        this.i = other.i;
        this.j = other.j;
        this.k = other.k;
        this.l = other.l;
        this.i0 = other.i0;
        this.j0 = other.j0;
        this.k0 = other.k0;
    }

    @Override
    public void get(OctonionFloat16Member other) {
        other.r = this.r;
        other.i = this.i;
        other.j = this.j;
        other.k = this.k;
        other.l = this.l;
        other.i0 = this.i0;
        other.j0 = this.j0;
        other.k0 = this.k0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(this.r());
        builder.append(',');
        builder.append(this.i());
        builder.append(',');
        builder.append(this.j());
        builder.append(',');
        builder.append(this.k());
        builder.append(',');
        builder.append(this.l());
        builder.append(',');
        builder.append(this.i0());
        builder.append(',');
        builder.append(this.j0());
        builder.append(',');
        builder.append(this.k0());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public int shortCount() {
        return 8;
    }

    @Override
    public void fromShortArray(short[] arr, int index) {
        this.r = arr[index];
        this.i = arr[index + 1];
        this.j = arr[index + 2];
        this.k = arr[index + 3];
        this.l = arr[index + 4];
        this.i0 = arr[index + 5];
        this.j0 = arr[index + 6];
        this.k0 = arr[index + 7];
    }

    @Override
    public void toShortArray(short[] arr, int index) {
        arr[index] = this.r;
        arr[index + 1] = this.i;
        arr[index + 2] = this.j;
        arr[index + 3] = this.k;
        arr[index + 4] = this.l;
        arr[index + 5] = this.i0;
        arr[index + 6] = this.j0;
        arr[index + 7] = this.k0;
    }

    @Override
    public void fromShortFile(RandomAccessFile raf) throws IOException {
        this.r = raf.readShort();
        this.i = raf.readShort();
        this.j = raf.readShort();
        this.k = raf.readShort();
        this.l = raf.readShort();
        this.i0 = raf.readShort();
        this.j0 = raf.readShort();
        this.k0 = raf.readShort();
    }

    @Override
    public void toShortFile(RandomAccessFile raf) throws IOException {
        raf.writeShort(this.r);
        raf.writeShort(this.i);
        raf.writeShort(this.j);
        raf.writeShort(this.k);
        raf.writeShort(this.l);
        raf.writeShort(this.i0);
        raf.writeShort(this.j0);
        raf.writeShort(this.k0);
    }

    @Override
    public OctonionFloat16Member allocate() {
        return new OctonionFloat16Member();
    }

    @Override
    public OctonionFloat16Member duplicate() {
        return new OctonionFloat16Member(this);
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(OctonionFloat16Member value) {
        this.get(value);
    }

    @Override
    public void setV(OctonionFloat16Member value) {
        this.set(value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(BigDecimal.valueOf(this.r()), BigDecimal.valueOf(this.i()), BigDecimal.valueOf(this.j()), BigDecimal.valueOf(this.k()), BigDecimal.valueOf(this.l()), BigDecimal.valueOf(this.i0()), BigDecimal.valueOf(this.j0()), BigDecimal.valueOf(this.k0())));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionRepresentation v = rep.getValue();
        this.setR(v.r().floatValue());
        this.setI(v.i().floatValue());
        this.setJ(v.j().floatValue());
        this.setK(v.k().floatValue());
        this.setL(v.l().floatValue());
        this.setI0(v.i0().floatValue());
        this.setJ0(v.j0().floatValue());
        this.setK0(v.k0().floatValue());
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.FLOAT;
    }

    @Override
    public long dimension(int i) {
        return 0L;
    }

    @Override
    public int componentCount() {
        return 8;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR((float)v);
                } else {
                    this.setI((float)v);
                }
            } else if (component == 2) {
                this.setJ((float)v);
            } else {
                this.setK((float)v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL((float)v);
            } else {
                this.setI0((float)v);
            }
        } else if (component == 6) {
            this.setJ0((float)v);
        } else {
            this.setK0((float)v);
        }
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.floatValue());
                } else {
                    this.setI(v.floatValue());
                }
            } else if (component == 2) {
                this.setJ(v.floatValue());
            } else {
                this.setK(v.floatValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.floatValue());
            } else {
                this.setI0(v.floatValue());
            }
        } else if (component == 6) {
            this.setJ0(v.floatValue());
        } else {
            this.setK0(v.floatValue());
        }
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.floatValue());
                } else {
                    this.setI(v.floatValue());
                }
            } else if (component == 2) {
                this.setJ(v.floatValue());
            } else {
                this.setK(v.floatValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.floatValue());
            } else {
                this.setI0(v.floatValue());
            }
        } else if (component == 6) {
            this.setJ0(v.floatValue());
        } else {
            this.setK0(v.floatValue());
        }
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR((float)v);
                } else {
                    this.setI((float)v);
                }
            } else if (component == 2) {
                this.setJ((float)v);
            } else {
                this.setK((float)v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL((float)v);
            } else {
                this.setI0((float)v);
            }
        } else if (component == 6) {
            this.setJ0((float)v);
        } else {
            this.setK0((float)v);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.floatValue());
                } else {
                    this.setI(v.floatValue());
                }
            } else if (component == 2) {
                this.setJ(v.floatValue());
            } else {
                this.setK(v.floatValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.floatValue());
            } else {
                this.setI0(v.floatValue());
            }
        } else if (component == 6) {
            this.setJ0(v.floatValue());
        } else {
            this.setK0(v.floatValue());
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.floatValue());
                } else {
                    this.setI(v.floatValue());
                }
            } else if (component == 2) {
                this.setJ(v.floatValue());
            } else {
                this.setK(v.floatValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.floatValue());
            } else {
                this.setI0(v.floatValue());
            }
        } else if (component == 6) {
            this.setJ0(v.floatValue());
        } else {
            this.setK0(v.floatValue());
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)this.r();
                }
                return (byte)this.i();
            }
            if (component == 2) {
                return (byte)this.j();
            }
            return (byte)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)this.l();
            }
            return (byte)this.i0();
        }
        if (component == 6) {
            return (byte)this.j0();
        }
        return (byte)this.k0();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)this.r();
                }
                return (short)this.i();
            }
            if (component == 2) {
                return (short)this.j();
            }
            return (short)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)this.l();
            }
            return (short)this.i0();
        }
        if (component == 6) {
            return (short)this.j0();
        }
        return (short)this.k0();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)this.r();
                }
                return (int)this.i();
            }
            if (component == 2) {
                return (int)this.j();
            }
            return (int)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)this.l();
            }
            return (int)this.i0();
        }
        if (component == 6) {
            return (int)this.j0();
        }
        return (int)this.k0();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)this.r();
                }
                return (long)this.i();
            }
            if (component == 2) {
                return (long)this.j();
            }
            return (long)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)this.l();
            }
            return (long)this.i0();
        }
        if (component == 6) {
            return (long)this.j0();
        }
        return (long)this.k0();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return this.r();
                }
                return this.i();
            }
            if (component == 2) {
                return this.j();
            }
            return this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return this.l();
            }
            return this.i0();
        }
        if (component == 6) {
            return this.j0();
        }
        return this.k0();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return this.r();
                }
                return this.i();
            }
            if (component == 2) {
                return this.j();
            }
            return this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return this.l();
            }
            return this.i0();
        }
        if (component == 6) {
            return this.j0();
        }
        return this.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r()).toBigInteger();
                }
                return BigDecimal.valueOf(this.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j()).toBigInteger();
            }
            return BigDecimal.valueOf(this.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r());
                }
                return BigDecimal.valueOf(this.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j());
            }
            return BigDecimal.valueOf(this.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l());
            }
            return BigDecimal.valueOf(this.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0());
        }
        return BigDecimal.valueOf(this.k0());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)this.r();
                }
                return (byte)this.i();
            }
            if (component == 2) {
                return (byte)this.j();
            }
            return (byte)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)this.l();
            }
            return (byte)this.i0();
        }
        if (component == 6) {
            return (byte)this.j0();
        }
        return (byte)this.k0();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)this.r();
                }
                return (short)this.i();
            }
            if (component == 2) {
                return (short)this.j();
            }
            return (short)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)this.l();
            }
            return (short)this.i0();
        }
        if (component == 6) {
            return (short)this.j0();
        }
        return (short)this.k0();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)this.r();
                }
                return (int)this.i();
            }
            if (component == 2) {
                return (int)this.j();
            }
            return (int)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)this.l();
            }
            return (int)this.i0();
        }
        if (component == 6) {
            return (int)this.j0();
        }
        return (int)this.k0();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)this.r();
                }
                return (long)this.i();
            }
            if (component == 2) {
                return (long)this.j();
            }
            return (long)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)this.l();
            }
            return (long)this.i0();
        }
        if (component == 6) {
            return (long)this.j0();
        }
        return (long)this.k0();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return this.r();
                }
                return this.i();
            }
            if (component == 2) {
                return this.j();
            }
            return this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return this.l();
            }
            return this.i0();
        }
        if (component == 6) {
            return this.j0();
        }
        return this.k0();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return this.r();
                }
                return this.i();
            }
            if (component == 2) {
                return this.j();
            }
            return this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return this.l();
            }
            return this.i0();
        }
        if (component == 6) {
            return this.j0();
        }
        return this.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r()).toBigInteger();
                }
                return BigDecimal.valueOf(this.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j()).toBigInteger();
            }
            return BigDecimal.valueOf(this.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r());
                }
                return BigDecimal.valueOf(this.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j());
            }
            return BigDecimal.valueOf(this.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l());
            }
            return BigDecimal.valueOf(this.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0());
        }
        return BigDecimal.valueOf(this.k0());
    }

    @Override
    public void primitiveInit() {
        this.j0 = this.k0 = ZERO;
        this.i0 = this.k0;
        this.l = this.k0;
        this.k = this.k0;
        this.j = this.k0;
        this.i = this.k0;
        this.r = this.k0;
    }

    @Override
    public void setR(Float16Member val) {
        this.r = val.encV();
    }

    @Override
    public void setI(Float16Member val) {
        this.i = val.encV();
    }

    @Override
    public void setJ(Float16Member val) {
        this.j = val.encV();
    }

    @Override
    public void setK(Float16Member val) {
        this.k = val.encV();
    }

    @Override
    public void setL(Float16Member val) {
        this.l = val.encV();
    }

    @Override
    public void setI0(Float16Member val) {
        this.i0 = val.encV();
    }

    @Override
    public void setJ0(Float16Member val) {
        this.j0 = val.encV();
    }

    @Override
    public void setK0(Float16Member val) {
        this.k0 = val.encV();
    }

    @Override
    public void getR(Float16Member v) {
        v.setEncV(this.r);
    }

    @Override
    public void getI(Float16Member v) {
        v.setEncV(this.i);
    }

    @Override
    public void getJ(Float16Member v) {
        v.setEncV(this.j);
    }

    @Override
    public void getK(Float16Member v) {
        v.setEncV(this.k);
    }

    @Override
    public void getL(Float16Member v) {
        v.setEncV(this.l);
    }

    @Override
    public void getI0(Float16Member v) {
        v.setEncV(this.i0);
    }

    @Override
    public void getJ0(Float16Member v) {
        v.setEncV(this.j0);
    }

    @Override
    public void getK0(Float16Member v) {
        v.setEncV(this.k0);
    }
}

