/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.octonion;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.RModuleReshape;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.octonion.OctonionFloat16Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class OctonionFloat16RModuleMember
implements RModuleMember<OctonionFloat16Member>,
Gettable<OctonionFloat16RModuleMember>,
Settable<OctonionFloat16RModuleMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<OctonionFloat16Member> {
    private static final OctonionFloat16Member ZERO = new OctonionFloat16Member();
    private IndexedDataSource<OctonionFloat16Member> storage;
    private StorageConstruction s;
    private static ThreadLocal<OctonionFloat16Member> tmpOct = new ThreadLocal<OctonionFloat16Member>(){

        @Override
        protected OctonionFloat16Member initialValue() {
            return new OctonionFloat16Member();
        }
    };

    public OctonionFloat16RModuleMember() {
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, 0L, new OctonionFloat16Member());
    }

    public OctonionFloat16RModuleMember(float[] vals) {
        int count = vals.length / 8;
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, count, new OctonionFloat16Member());
        OctonionFloat16Member value = new OctonionFloat16Member();
        for (int i = 0; i < count; ++i) {
            int index = 8 * i;
            value.setR(vals[index]);
            value.setI(vals[index + 1]);
            value.setJ(vals[index + 2]);
            value.setK(vals[index + 3]);
            value.setL(vals[index + 4]);
            value.setI0(vals[index + 5]);
            value.setJ0(vals[index + 6]);
            value.setK0(vals[index + 7]);
            this.storage.set(i, value);
        }
    }

    public OctonionFloat16RModuleMember(OctonionFloat16RModuleMember other) {
        this.set(other);
    }

    public OctonionFloat16RModuleMember(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        BigList<OctonionRepresentation> data = rep.firstVectorValues();
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, data.size(), new OctonionFloat16Member());
        OctonionFloat16Member tmp = new OctonionFloat16Member();
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            OctonionRepresentation val = data.get(i);
            tmp.setR(val.r().floatValue());
            tmp.setI(val.i().floatValue());
            tmp.setJ(val.j().floatValue());
            tmp.setK(val.k().floatValue());
            tmp.setL(val.l().floatValue());
            tmp.setI0(val.i0().floatValue());
            tmp.setJ0(val.j0().floatValue());
            tmp.setK0(val.k0().floatValue());
            this.storage.set(i, tmp);
        }
    }

    public OctonionFloat16RModuleMember(StorageConstruction s, long d1) {
        this.s = s;
        this.alloc(d1);
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public void v(long i, OctonionFloat16Member v) {
        this.storage.get(i, v);
    }

    @Override
    public void setV(long i, OctonionFloat16Member v) {
        this.storage.set(i, v);
    }

    @Override
    public void set(OctonionFloat16RModuleMember other) {
        if (this == other) {
            return;
        }
        this.storage = (IndexedDataSource)other.storage.duplicate();
        this.s = other.s;
    }

    @Override
    public void get(OctonionFloat16RModuleMember other) {
        if (this == other) {
            return;
        }
        other.storage = (IndexedDataSource)this.storage.duplicate();
        other.s = this.s;
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        OctonionFloat16Member value = new OctonionFloat16Member();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(this.length());
        for (long i = 0L; i < this.length(); ++i) {
            this.storage.get(i, value);
            BigDecimal r = BigDecimal.valueOf(value.r());
            BigDecimal im = BigDecimal.valueOf(value.i());
            BigDecimal j = BigDecimal.valueOf(value.j());
            BigDecimal k = BigDecimal.valueOf(value.k());
            BigDecimal l = BigDecimal.valueOf(value.l());
            BigDecimal i0 = BigDecimal.valueOf(value.i0());
            BigDecimal j0 = BigDecimal.valueOf(value.j0());
            BigDecimal k0 = BigDecimal.valueOf(value.k0());
            OctonionRepresentation o = new OctonionRepresentation(r, im, j, k, l, i0, j0, k0);
            values.set(i, o);
        }
        rep.setRModule(this.length(), values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionFloat16Member value = new OctonionFloat16Member();
        BigList<OctonionRepresentation> rmod = rep.getRModule();
        long rmodSize = rmod.size();
        this.init(rmodSize);
        for (long i = 0L; i < rmodSize; ++i) {
            OctonionRepresentation o = rmod.get(i);
            value.setR(o.r().floatValue());
            value.setI(o.i().floatValue());
            value.setJ(o.j().floatValue());
            value.setK(o.k().floatValue());
            value.setL(o.l().floatValue());
            value.setI0(o.i0().floatValue());
            value.setJ0(o.j0().floatValue());
            value.setK0(o.k0().floatValue());
            this.storage.set(i, value);
        }
    }

    @Override
    public long length() {
        return this.storage.size();
    }

    public String toString() {
        OctonionFloat16Member tmp = new OctonionFloat16Member();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            if (i != 0L) {
                builder.append(',');
            }
            this.v(i, tmp);
            builder.append(tmp.toString());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean alloc(long size) {
        if (this.storage == null || this.storage.size() != size) {
            this.storage = Storage.allocate(this.s, size, new OctonionFloat16Member());
            return true;
        }
        return false;
    }

    @Override
    public void init(long size) {
        if (!this.alloc(size)) {
            for (long i = 0L; i < size; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public void reshape(long len) {
        RModuleReshape.compute(G.OHLF_RMOD, G.OHLF, len, this);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d == 0) {
            return this.storage.size();
        }
        return 1L;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.FLOAT;
    }

    @Override
    public int componentCount() {
        return 8;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR((float)v);
                } else {
                    tmp.setI((float)v);
                }
            } else if (component == 2) {
                tmp.setJ((float)v);
            } else {
                tmp.setK((float)v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL((float)v);
            } else {
                tmp.setI0((float)v);
            }
        } else if (component == 6) {
            tmp.setJ0((float)v);
        } else {
            tmp.setK0((float)v);
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v.floatValue());
                } else {
                    tmp.setI(v.floatValue());
                }
            } else if (component == 2) {
                tmp.setJ(v.floatValue());
            } else {
                tmp.setK(v.floatValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v.floatValue());
            } else {
                tmp.setI0(v.floatValue());
            }
        } else if (component == 6) {
            tmp.setJ0(v.floatValue());
        } else {
            tmp.setK0(v.floatValue());
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        OctonionFloat16Member tmp = tmpOct.get();
        long i = index.get(0);
        this.v(i, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v.floatValue());
                } else {
                    tmp.setI(v.floatValue());
                }
            } else if (component == 2) {
                tmp.setJ(v.floatValue());
            } else {
                tmp.setK(v.floatValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v.floatValue());
            } else {
                tmp.setI0(v.floatValue());
            }
        } else if (component == 6) {
            tmp.setJ0(v.floatValue());
        } else {
            tmp.setK0(v.floatValue());
        }
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR((float)v);
                    } else {
                        tmp.setI((float)v);
                    }
                } else if (component == 2) {
                    tmp.setJ((float)v);
                } else {
                    tmp.setK((float)v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL((float)v);
                } else {
                    tmp.setI0((float)v);
                }
            } else if (component == 6) {
                tmp.setJ0((float)v);
            } else {
                tmp.setK0((float)v);
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v.floatValue());
                    } else {
                        tmp.setI(v.floatValue());
                    }
                } else if (component == 2) {
                    tmp.setJ(v.floatValue());
                } else {
                    tmp.setK(v.floatValue());
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v.floatValue());
                } else {
                    tmp.setI0(v.floatValue());
                }
            } else if (component == 6) {
                tmp.setJ0(v.floatValue());
            } else {
                tmp.setK0(v.floatValue());
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat16Member tmp = tmpOct.get();
            long i = index.get(0);
            this.v(i, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v.floatValue());
                    } else {
                        tmp.setI(v.floatValue());
                    }
                } else if (component == 2) {
                    tmp.setJ(v.floatValue());
                } else {
                    tmp.setK(v.floatValue());
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v.floatValue());
                } else {
                    tmp.setI0(v.floatValue());
                }
            } else if (component == 6) {
                tmp.setJ0(v.floatValue());
            } else {
                tmp.setK0(v.floatValue());
            }
            this.setV(i, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)tmp.r();
                }
                return (byte)tmp.i();
            }
            if (component == 2) {
                return (byte)tmp.j();
            }
            return (byte)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)tmp.l();
            }
            return (byte)tmp.i0();
        }
        if (component == 6) {
            return (byte)tmp.j0();
        }
        return (byte)tmp.k0();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)tmp.r();
                }
                return (short)tmp.i();
            }
            if (component == 2) {
                return (short)tmp.j();
            }
            return (short)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)tmp.l();
            }
            return (short)tmp.i0();
        }
        if (component == 6) {
            return (short)tmp.j0();
        }
        return (short)tmp.k0();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)tmp.r();
                }
                return (int)tmp.i();
            }
            if (component == 2) {
                return (int)tmp.j();
            }
            return (int)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)tmp.l();
            }
            return (int)tmp.i0();
        }
        if (component == 6) {
            return (int)tmp.j0();
        }
        return (int)tmp.k0();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0L;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)tmp.r();
                }
                return (long)tmp.i();
            }
            if (component == 2) {
                return (long)tmp.j();
            }
            return (long)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)tmp.l();
            }
            return (long)tmp.i0();
        }
        if (component == 6) {
            return (long)tmp.j0();
        }
        return (long)tmp.k0();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0.0f;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0.0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return BigInteger.ZERO;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r()).toBigInteger();
                }
                return BigDecimal.valueOf(tmp.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return BigDecimal.ZERO;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r());
                }
                return BigDecimal.valueOf(tmp.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j());
            }
            return BigDecimal.valueOf(tmp.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l());
            }
            return BigDecimal.valueOf(tmp.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0());
        }
        return BigDecimal.valueOf(tmp.k0());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)tmp.r();
                }
                return (byte)tmp.i();
            }
            if (component == 2) {
                return (byte)tmp.j();
            }
            return (byte)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)tmp.l();
            }
            return (byte)tmp.i0();
        }
        if (component == 6) {
            return (byte)tmp.j0();
        }
        return (byte)tmp.k0();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)tmp.r();
                }
                return (short)tmp.i();
            }
            if (component == 2) {
                return (short)tmp.j();
            }
            return (short)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)tmp.l();
            }
            return (short)tmp.i0();
        }
        if (component == 6) {
            return (short)tmp.j0();
        }
        return (short)tmp.k0();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)tmp.r();
                }
                return (int)tmp.i();
            }
            if (component == 2) {
                return (int)tmp.j();
            }
            return (int)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)tmp.l();
            }
            return (int)tmp.i0();
        }
        if (component == 6) {
            return (int)tmp.j0();
        }
        return (int)tmp.k0();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)tmp.r();
                }
                return (long)tmp.i();
            }
            if (component == 2) {
                return (long)tmp.j();
            }
            return (long)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)tmp.l();
            }
            return (long)tmp.i0();
        }
        if (component == 6) {
            return (long)tmp.j0();
        }
        return (long)tmp.k0();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r()).toBigInteger();
                }
                return BigDecimal.valueOf(tmp.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        OctonionFloat16Member tmp = tmpOct.get();
        this.v(index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r());
                }
                return BigDecimal.valueOf(tmp.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j());
            }
            return BigDecimal.valueOf(tmp.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l());
            }
            return BigDecimal.valueOf(tmp.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0());
        }
        return BigDecimal.valueOf(tmp.k0());
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<OctonionFloat16Member> rawData() {
        return this.storage;
    }
}

