/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.quaternion;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.QuaternionNumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float16.quaternion.QuaternionFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat16Algebra
implements SkewField<QuaternionFloat16Algebra, QuaternionFloat16Member>,
RealConstants<QuaternionFloat16Member>,
ImaginaryConstants<QuaternionFloat16Member>,
QuaternionConstants<QuaternionFloat16Member>,
Norm<QuaternionFloat16Member, Float16Member>,
Conjugate<QuaternionFloat16Member>,
Infinite<QuaternionFloat16Member>,
NaN<QuaternionFloat16Member>,
Rounding<Float16Member, QuaternionFloat16Member>,
Random<QuaternionFloat16Member>,
Exponential<QuaternionFloat16Member>,
Trigonometric<QuaternionFloat16Member>,
Hyperbolic<QuaternionFloat16Member>,
Power<QuaternionFloat16Member>,
Roots<QuaternionFloat16Member>,
RealUnreal<QuaternionFloat16Member, Float16Member>,
Scale<QuaternionFloat16Member, QuaternionFloat16Member>,
ScaleByHighPrec<QuaternionFloat16Member>,
ScaleByRational<QuaternionFloat16Member>,
ScaleByDouble<QuaternionFloat16Member>,
ScaleComponents<QuaternionFloat16Member, Float16Member>,
Tolerance<Float16Member, QuaternionFloat16Member> {
    private static final QuaternionFloat16Member ZERO = new QuaternionFloat16Member(0.0f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member ONE_THIRD = new QuaternionFloat16Member(0.33333334f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member ONE_HALF = new QuaternionFloat16Member(0.5f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member ONE = new QuaternionFloat16Member(1.0f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member TWO = new QuaternionFloat16Member(2.0f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member E = new QuaternionFloat16Member((float)Math.E, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member PI = new QuaternionFloat16Member((float)Math.PI, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member GAMMA = new QuaternionFloat16Member(0.5772157f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member PHI = new QuaternionFloat16Member(1.618034f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member I = new QuaternionFloat16Member(0.0f, 1.0f, 0.0f, 0.0f);
    private static final QuaternionFloat16Member J = new QuaternionFloat16Member(0.0f, 0.0f, 1.0f, 0.0f);
    private static final QuaternionFloat16Member K = new QuaternionFloat16Member(0.0f, 0.0f, 0.0f, 1.0f);
    private final Procedure1<QuaternionFloat16Member> UNITY = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> MUL = new Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            double r = a.r() * b.r() - a.i() * b.i() - a.j() * b.j() - a.k() * b.k();
            double i = a.r() * b.i() + a.i() * b.r() + a.j() * b.k() - a.k() * b.j();
            double j = a.r() * b.j() - a.i() * b.k() + a.j() * b.r() + a.k() * b.i();
            double k = a.r() * b.k() + a.i() * b.j() - a.j() * b.i() + a.k() * b.r();
            c.setR((float)r);
            c.setI((float)i);
            c.setJ((float)j);
            c.setK((float)k);
        }
    };
    private final Procedure3<Integer, QuaternionFloat16Member, QuaternionFloat16Member> POWER = new Procedure3<Integer, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(Integer power, QuaternionFloat16Member a, QuaternionFloat16Member b) {
            PowerAny.compute(G.QHLF, power, a, b);
        }
    };
    private final Procedure1<QuaternionFloat16Member> ZER = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> NEG = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Algebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> ADD = new Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
            c.setJ(a.j() + b.j());
            c.setK(a.k() + b.k());
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> SUB = new Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
            c.setJ(a.j() - b.j());
            c.setK(a.k() - b.k());
        }
    };
    private final Function2<Boolean, QuaternionFloat16Member, QuaternionFloat16Member> EQ = new Function2<Boolean, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public Boolean call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k();
        }
    };
    private final Function2<Boolean, QuaternionFloat16Member, QuaternionFloat16Member> NEQ = new Function2<Boolean, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public Boolean call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            return QuaternionFloat16Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> ASSIGN = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member from, QuaternionFloat16Member to) {
            to.set(from);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> INV = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Member c = new QuaternionFloat16Member();
            QuaternionFloat16Member scale = new QuaternionFloat16Member();
            Float16Member nval = new Float16Member();
            QuaternionFloat16Algebra.this.norm().call(a, nval);
            scale.setR((float)(1.0 / (double)(nval.v() * nval.v())));
            QuaternionFloat16Algebra.this.conjugate().call(a, c);
            QuaternionFloat16Algebra.this.multiply().call(scale, c, b);
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> DIVIDE = new Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            QuaternionFloat16Member tmp = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.invert().call(b, tmp);
            QuaternionFloat16Algebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> CONJ = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            b.setR(a.r());
            b.setI(-a.i());
            b.setJ(-a.j());
            b.setK(-a.k());
        }
    };
    private final Procedure2<QuaternionFloat16Member, Float16Member> NORM = new Procedure2<QuaternionFloat16Member, Float16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, Float16Member b) {
            double max = Math.max(Math.abs(a.r()), Math.abs(a.i()));
            max = Math.max(max, (double)Math.abs(a.j()));
            if ((max = Math.max(max, (double)Math.abs(a.k()))) == 0.0) {
                b.setV(0.0f);
            } else {
                double sum = (double)a.r() / max * ((double)a.r() / max);
                sum += (double)a.i() / max * ((double)a.i() / max);
                sum += (double)a.j() / max * ((double)a.j() / max);
                b.setV((float)(max * Math.sqrt(sum += (double)a.k() / max * ((double)a.k() / max))));
            }
        }
    };
    private final Procedure1<QuaternionFloat16Member> PI_ = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<QuaternionFloat16Member> E_ = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<QuaternionFloat16Member> GAMMA_ = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<QuaternionFloat16Member> PHI_ = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<QuaternionFloat16Member> I_ = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<QuaternionFloat16Member> J_ = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<QuaternionFloat16Member> K_ = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            QuaternionFloat16Algebra.this.assign().call(K, a);
        }
    };
    private Procedure4<Round.Mode, Float16Member, QuaternionFloat16Member, QuaternionFloat16Member> ROUND = new Procedure4<Round.Mode, Float16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Float16Member tmp = new Float16Member();
            tmp.setV(a.r());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setI(tmp.v());
            tmp.setV(a.j());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setJ(tmp.v());
            tmp.setV(a.k());
            Round.compute(G.HLF, mode, delta, tmp, tmp);
            b.setK(tmp.v());
        }
    };
    private Function1<Boolean, QuaternionFloat16Member> ISNAN = new Function1<Boolean, QuaternionFloat16Member>(){

        @Override
        public Boolean call(QuaternionFloat16Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i()) || Double.isNaN(a.j()) || Double.isNaN(a.k());
        }
    };
    private final Procedure1<QuaternionFloat16Member> NAN = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            a.setR(Float.NaN);
            a.setI(Float.NaN);
            a.setJ(Float.NaN);
            a.setK(Float.NaN);
        }
    };
    private Function1<Boolean, QuaternionFloat16Member> ISINF = new Function1<Boolean, QuaternionFloat16Member>(){

        @Override
        public Boolean call(QuaternionFloat16Member a) {
            return QuaternionFloat16Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()) || Double.isInfinite(a.j()) || Double.isInfinite(a.k()));
        }
    };
    private final Procedure1<QuaternionFloat16Member> INF = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            a.setR(Float.POSITIVE_INFINITY);
            a.setI(Float.POSITIVE_INFINITY);
            a.setJ(Float.POSITIVE_INFINITY);
            a.setK(Float.POSITIVE_INFINITY);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> EXP = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            QuaternionFloat16Member tmp = new QuaternionFloat16Member();
            double u = FastMath.exp((double)a.r());
            QuaternionFloat16Algebra.this.unreal().call(a, tmp);
            QuaternionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinc().call(z, z2);
            double w = z2.v();
            b.setR((float)(u * FastMath.cos((double)z.v())));
            b.setI((float)(u * w * (double)a.i()));
            b.setJ((float)(u * w * (double)a.j()));
            b.setK((float)(u * w * (double)a.k()));
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> LOG = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Float16Member norm = new Float16Member();
            Float16Member term = new Float16Member();
            Float16Member v1 = new Float16Member();
            Float16Member v2 = new Float16Member();
            Float16Member v3 = new Float16Member();
            QuaternionFloat16Algebra.this.norm().call(a, norm);
            Float16Member multiplier = new Float16Member(a.r() / norm.v());
            v1.setV(a.i() * multiplier.v());
            v2.setV(a.j() * multiplier.v());
            v3.setV(a.k() * multiplier.v());
            G.HLF.acos().call(multiplier, term);
            b.setR((float)Math.log(norm.v()));
            b.setI(v1.v() * term.v());
            b.setJ(v2.v() * term.v());
            b.setK(v3.v() * term.v());
        }
    };
    private final Procedure1<QuaternionFloat16Member> RAND = new Procedure1<QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextFloat());
            a.setI(rng.nextFloat());
            a.setJ(rng.nextFloat());
            a.setK(rng.nextFloat());
        }
    };
    private final Procedure2<QuaternionFloat16Member, Float16Member> REAL = new Procedure2<QuaternionFloat16Member, Float16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, Float16Member b) {
            b.setV(a.r());
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> UNREAL = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Algebra.this.assign().call(a, b);
            b.setR(0.0f);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> SINH = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Member negA = new QuaternionFloat16Member();
            QuaternionFloat16Member sum = new QuaternionFloat16Member();
            QuaternionFloat16Member tmp1 = new QuaternionFloat16Member();
            QuaternionFloat16Member tmp2 = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.negate().call(a, negA);
            QuaternionFloat16Algebra.this.exp().call(a, tmp1);
            QuaternionFloat16Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat16Algebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionFloat16Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> COSH = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Member negA = new QuaternionFloat16Member();
            QuaternionFloat16Member sum = new QuaternionFloat16Member();
            QuaternionFloat16Member tmp1 = new QuaternionFloat16Member();
            QuaternionFloat16Member tmp2 = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.negate().call(a, negA);
            QuaternionFloat16Algebra.this.exp().call(a, tmp1);
            QuaternionFloat16Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat16Algebra.this.add().call(tmp1, tmp2, sum);
            QuaternionFloat16Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> SINHANDCOSH = new Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member s, QuaternionFloat16Member c) {
            QuaternionFloat16Member negA = new QuaternionFloat16Member();
            QuaternionFloat16Member sum = new QuaternionFloat16Member();
            QuaternionFloat16Member tmp1 = new QuaternionFloat16Member();
            QuaternionFloat16Member tmp2 = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.negate().call(a, negA);
            QuaternionFloat16Algebra.this.exp().call(a, tmp1);
            QuaternionFloat16Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat16Algebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionFloat16Algebra.this.divide().call(sum, TWO, s);
            QuaternionFloat16Algebra.this.add().call(tmp1, tmp2, sum);
            QuaternionFloat16Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> TANH = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Member s = new QuaternionFloat16Member();
            QuaternionFloat16Member c = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.sinhAndCosh().call(a, s, c);
            QuaternionFloat16Algebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> SIN = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            QuaternionFloat16Member tmp = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.unreal().call(a, tmp);
            QuaternionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            b.setR((float)(sin * cosh));
            b.setI((float)(ws * (double)a.i()));
            b.setJ((float)(ws * (double)a.j()));
            b.setK((float)(ws * (double)a.k()));
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> COS = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            QuaternionFloat16Member tmp = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.unreal().call(a, tmp);
            QuaternionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double wc = -sin * sinhc_pi;
            b.setR((float)(cos * cosh));
            b.setI((float)(wc * (double)a.i()));
            b.setJ((float)(wc * (double)a.j()));
            b.setK((float)(wc * (double)a.k()));
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> SINANDCOS = new Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member s, QuaternionFloat16Member c) {
            Float16Member z = new Float16Member();
            Float16Member z2 = new Float16Member();
            QuaternionFloat16Member tmp = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.unreal().call(a, tmp);
            QuaternionFloat16Algebra.this.norm().call(tmp, z);
            G.HLF.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            double wc = -sin * sinhc_pi;
            s.setR((float)(sin * cosh));
            s.setI((float)(ws * (double)a.i()));
            s.setJ((float)(ws * (double)a.j()));
            s.setK((float)(ws * (double)a.k()));
            c.setR((float)(cos * cosh));
            c.setI((float)(wc * (double)a.i()));
            c.setJ((float)(wc * (double)a.j()));
            c.setK((float)(wc * (double)a.k()));
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> TAN = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Member sin = new QuaternionFloat16Member();
            QuaternionFloat16Member cos = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.sinAndCos().call(a, sin, cos);
            QuaternionFloat16Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> POW = new Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            QuaternionFloat16Member logA = new QuaternionFloat16Member();
            QuaternionFloat16Member bLogA = new QuaternionFloat16Member();
            QuaternionFloat16Algebra.this.log().call(a, logA);
            QuaternionFloat16Algebra.this.multiply().call(b, logA, bLogA);
            QuaternionFloat16Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> SINCH = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Sinch.compute(G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> SINCHPI = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Sinchpi.compute(G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> SINC = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Sinc.compute(G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> SINCPI = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            Sincpi.compute(G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> SQRT = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> CBRT = new Procedure2<QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16Member b) {
            QuaternionFloat16Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat16Member> ISZERO = new Function1<Boolean, QuaternionFloat16Member>(){

        @Override
        public Boolean call(QuaternionFloat16Member a) {
            return a.r() == 0.0f && a.i() == 0.0f && a.j() == 0.0f && a.k() == 0.0f;
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionFloat16Member, QuaternionFloat16Member> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j()));
            c.setJ(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k()));
            c.setK(tmp.floatValue());
        }
    };
    private final Procedure3<RationalMember, QuaternionFloat16Member, QuaternionFloat16Member> SBR = new Procedure3<RationalMember, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(RationalMember a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.j());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.k());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp.floatValue());
        }
    };
    private final Procedure3<Double, QuaternionFloat16Member, QuaternionFloat16Member> SBD = new Procedure3<Double, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(Double a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            c.setR((float)(a * (double)b.r()));
            c.setI((float)(a * (double)b.i()));
            c.setJ((float)(a * (double)b.j()));
            c.setK((float)(a * (double)b.k()));
        }
    };
    private final Procedure3<Float16Member, QuaternionFloat16Member, QuaternionFloat16Member> SC = new Procedure3<Float16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public void call(Float16Member a, QuaternionFloat16Member b, QuaternionFloat16Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
            c.setJ(a.v() * b.j());
            c.setK(a.v() * b.k());
        }
    };
    private final Function3<Boolean, Float16Member, QuaternionFloat16Member, QuaternionFloat16Member> WITHIN = new Function3<Boolean, Float16Member, QuaternionFloat16Member, QuaternionFloat16Member>(){

        @Override
        public Boolean call(Float16Member tol, QuaternionFloat16Member a, QuaternionFloat16Member b) {
            return QuaternionNumberWithin.compute(G.HLF, tol, a, b);
        }
    };

    @Override
    public Procedure1<QuaternionFloat16Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat16Member, QuaternionFloat16Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, QuaternionFloat16Member, QuaternionFloat16Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat16Member, QuaternionFloat16Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public QuaternionFloat16Member construct() {
        return new QuaternionFloat16Member();
    }

    @Override
    public QuaternionFloat16Member construct(QuaternionFloat16Member other) {
        return new QuaternionFloat16Member(other);
    }

    @Override
    public QuaternionFloat16Member construct(String s) {
        return new QuaternionFloat16Member(s);
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> I() {
        return this.I_;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> J() {
        return this.J_;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> K() {
        return this.K_;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, QuaternionFloat16Member, QuaternionFloat16Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> log() {
        return this.LOG;
    }

    @Override
    public Procedure1<QuaternionFloat16Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, Float16Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<QuaternionFloat16Member, QuaternionFloat16Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16Member, QuaternionFloat16Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat16Member, QuaternionFloat16Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat16Member, QuaternionFloat16Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat16Member, QuaternionFloat16Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float16Member, QuaternionFloat16Member, QuaternionFloat16Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float16Member, QuaternionFloat16Member, QuaternionFloat16Member> within() {
        return this.WITHIN;
    }
}

