/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.quaternion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorLikeProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.quaternion.QuaternionFloat16Algebra;
import nom.bdezonia.zorbage.type.data.float16.quaternion.QuaternionFloat16CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float16.quaternion.QuaternionFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat16CartesianTensorProduct
implements TensorLikeProduct<QuaternionFloat16CartesianTensorProduct, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16Algebra, QuaternionFloat16Member>,
ConstructibleNdLong<QuaternionFloat16CartesianTensorProductMember>,
Norm<QuaternionFloat16CartesianTensorProductMember, Float16Member>,
Scale<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16Member>,
Rounding<Float16Member, QuaternionFloat16CartesianTensorProductMember>,
Infinite<QuaternionFloat16CartesianTensorProductMember>,
NaN<QuaternionFloat16CartesianTensorProductMember>,
ScaleByHighPrec<QuaternionFloat16CartesianTensorProductMember>,
ScaleByRational<QuaternionFloat16CartesianTensorProductMember>,
ScaleByDouble<QuaternionFloat16CartesianTensorProductMember>,
Tolerance<Float16Member, QuaternionFloat16CartesianTensorProductMember> {
    private final Function2<Boolean, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> EQ = new Function2<Boolean, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QHLF, G.HLF.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> NEQ = new Function2<Boolean, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            return QuaternionFloat16CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> ASSIGN = new Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember from, QuaternionFloat16CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.QHLF, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<QuaternionFloat16CartesianTensorProductMember> ZER = new Procedure1<QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> NEG = new Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QHLF, G.QHLF.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> ADDEL = new Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b, QuaternionFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHLF, G.QHLF.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> SUBEL = new Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b, QuaternionFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHLF, G.QHLF.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<QuaternionFloat16CartesianTensorProductMember, Float16Member> NORM = new Procedure2<QuaternionFloat16CartesianTensorProductMember, Float16Member>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, Float16Member b) {
            TensorNorm.compute(G.QHLF, G.HLF, a.rawData(), b);
        }
    };
    private final Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> CONJ = new Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QHLF, G.QHLF.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> SCALE = new Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16Member scalar, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.QHLF, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> ADDSCALAR = new Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16Member scalar, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.QHLF, scalar, G.QHLF.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> SUBSCALAR = new Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16Member scalar, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            QuaternionFloat16Member tmp = G.QHLF.construct();
            G.QHLF.negate().call(scalar, tmp);
            QuaternionFloat16CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> MULEL = new Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b, QuaternionFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHLF, G.QHLF.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> DIVIDEEL = new Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b, QuaternionFloat16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QHLF, G.QHLF.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> MUL = new Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b, QuaternionFloat16CartesianTensorProductMember c) {
            QuaternionFloat16CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorContract.compute(G.QHLF, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> SEMI = new Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.QHLF_TEN, G.QHLF, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> COMMA = new Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.QHLF_TEN, G.QHLF, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> POWER = new Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorPower.compute(G.QHLF_TEN, power, a, b);
        }
    };
    private final Procedure1<QuaternionFloat16CartesianTensorProductMember> UNITY = new Procedure1<QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember result) {
            TensorUnity.compute(G.QHLF_TEN, G.QHLF, result);
        }
    };
    private final Function1<Boolean, QuaternionFloat16CartesianTensorProductMember> ISNAN = new Function1<Boolean, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat16CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.QHLF, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat16CartesianTensorProductMember> NAN = new Procedure1<QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a) {
            FillNaN.compute(G.QHLF, a);
        }
    };
    private final Function1<Boolean, QuaternionFloat16CartesianTensorProductMember> ISINF = new Function1<Boolean, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat16CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.QHLF, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat16CartesianTensorProductMember> INF = new Procedure1<QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a) {
            FillInfinite.compute(G.QHLF, a);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorRound.compute(G.QHLF_TEN, G.QHLF, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat16CartesianTensorProductMember> ISZERO = new Function1<Boolean, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat16CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.QHLF, a.rawData());
        }
    };
    private final Procedure3<RationalMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> SBR = new Procedure3<RationalMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.QHLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> SBD = new Procedure3<Double, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.QHLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.QHLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16Member tol, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QHLF, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> MULBYSCALAR = new Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16Member factor, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            QuaternionFloat16CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16Member factor, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            QuaternionFloat16Member invFactor = G.QHLF.construct();
            G.QHLF.invert().call(factor, invFactor);
            QuaternionFloat16CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> RAISE = new Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> LOWER = new Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            QuaternionFloat16CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b, QuaternionFloat16CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            QuaternionFloat16CartesianTensorProductMember tmp = QuaternionFloat16CartesianTensorProduct.this.construct();
            QuaternionFloat16CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            QuaternionFloat16CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> OUTER = new Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat16CartesianTensorProductMember a, QuaternionFloat16CartesianTensorProductMember b, QuaternionFloat16CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.QHLF_TEN, G.QHLF, a, b, c);
        }
    };

    @Override
    public QuaternionFloat16CartesianTensorProductMember construct() {
        return new QuaternionFloat16CartesianTensorProductMember();
    }

    @Override
    public QuaternionFloat16CartesianTensorProductMember construct(QuaternionFloat16CartesianTensorProductMember other) {
        return new QuaternionFloat16CartesianTensorProductMember(other);
    }

    @Override
    public QuaternionFloat16CartesianTensorProductMember construct(String s) {
        return new QuaternionFloat16CartesianTensorProductMember(s);
    }

    @Override
    public QuaternionFloat16CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new QuaternionFloat16CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<QuaternionFloat16CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<QuaternionFloat16CartesianTensorProductMember, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat16CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat16CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat16CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember, QuaternionFloat16CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

