/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.quaternion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.quaternion.QuaternionFloat16Algebra;
import nom.bdezonia.zorbage.type.data.float16.quaternion.QuaternionFloat16MatrixMember;
import nom.bdezonia.zorbage.type.data.float16.quaternion.QuaternionFloat16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat16Matrix
implements RingWithUnity<QuaternionFloat16Matrix, QuaternionFloat16MatrixMember>,
MatrixRing<QuaternionFloat16Matrix, QuaternionFloat16MatrixMember, QuaternionFloat16Algebra, QuaternionFloat16Member>,
Constructible2dLong<QuaternionFloat16MatrixMember>,
Rounding<Float16Member, QuaternionFloat16MatrixMember>,
Norm<QuaternionFloat16MatrixMember, Float16Member>,
DirectProduct<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>,
Exponential<QuaternionFloat16MatrixMember>,
Trigonometric<QuaternionFloat16MatrixMember>,
Hyperbolic<QuaternionFloat16MatrixMember>,
RealConstants<QuaternionFloat16MatrixMember>,
Infinite<QuaternionFloat16MatrixMember>,
NaN<QuaternionFloat16MatrixMember>,
ScaleByHighPrec<QuaternionFloat16MatrixMember>,
ScaleByRational<QuaternionFloat16MatrixMember>,
ScaleByDouble<QuaternionFloat16MatrixMember>,
Tolerance<Float16Member, QuaternionFloat16MatrixMember> {
    private final Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> MUL = new Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            MatrixMultiply.compute(G.QHLF, a, b, c);
        }
    };
    private final Procedure3<Integer, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> POWER = new Procedure3<Integer, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(Integer power, QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            MatrixPower.compute(power, G.QHLF, G.QHLF_RMOD, G.QHLF_MAT, a, b);
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> ZER = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> NEG = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            MatrixNegate.compute(G.QHLF, a, b);
        }
    };
    private final Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> ADD = new Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            MatrixAddition.compute(G.QHLF, a, b, c);
        }
    };
    private final Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SUB = new Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            MatrixSubtraction.compute(G.QHLF, a, b, c);
        }
    };
    private final Function2<Boolean, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> EQ = new Function2<Boolean, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            return MatrixEqual.compute(G.QHLF, a, b);
        }
    };
    private final Function2<Boolean, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> NEQ = new Function2<Boolean, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            return QuaternionFloat16Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> ASSIGN = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember from, QuaternionFloat16MatrixMember to) {
            MatrixAssign.compute(G.QHLF, from, to);
        }
    };
    private Procedure2<QuaternionFloat16MatrixMember, Float16Member> NORM = new Procedure2<QuaternionFloat16MatrixMember, Float16Member>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, Float16Member b) {
            MatrixSpectralNorm.compute(G.QHLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> ROUND = new Procedure4<Round.Mode, Float16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            MatrixRound.compute(G.QHLF, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat16MatrixMember> ISNAN = new Function1<Boolean, QuaternionFloat16MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat16MatrixMember a) {
            return SequenceIsNan.compute(G.QHLF, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> NAN = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            FillNaN.compute(G.QHLF, a);
        }
    };
    private final Function1<Boolean, QuaternionFloat16MatrixMember> ISINF = new Function1<Boolean, QuaternionFloat16MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat16MatrixMember a) {
            return SequenceIsInf.compute(G.QHLF, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> INF = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            FillInfinite.compute(G.QHLF, a);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> CONJ = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            MatrixConjugate.compute(G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> TRANSP = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            MatrixTranspose.compute(G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> CONJTRANSP = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            QuaternionFloat16MatrixMember tmp = new QuaternionFloat16MatrixMember();
            QuaternionFloat16Matrix.this.conjugate().call(a, tmp);
            QuaternionFloat16Matrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16Member> DET = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16Member>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16Member b) {
            MatrixDeterminant.compute(G.QHLF_MAT, G.QHLF, a, b);
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> UNITY = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            MatrixUnity.compute(G.QHLF, a);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> INV = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            MatrixInvert.compute(G.QHLF, G.QHLF_RMOD, G.QHLF_MAT, a, b);
        }
    };
    private final Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> DIVIDE = new Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            QuaternionFloat16MatrixMember invB = QuaternionFloat16Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            QuaternionFloat16Matrix.this.invert().call(b, invB);
            QuaternionFloat16Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> DP = new Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember in1, QuaternionFloat16MatrixMember in2, QuaternionFloat16MatrixMember out) {
            MatrixDirectProduct.compute(G.QHLF, in1, in2, out);
        }
    };
    private final Procedure3<QuaternionFloat16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SCALE = new Procedure3<QuaternionFloat16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16Member a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            MatrixScale.compute(G.QHLF, a, b, c);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SINH = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.QHLF_MAT, G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> COSH = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.QHLF_MAT, G.QHLF, a, b);
        }
    };
    private final Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SINHANDCOSH = new Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember s, QuaternionFloat16MatrixMember c) {
            QuaternionFloat16Matrix.this.sinh().call(a, s);
            QuaternionFloat16Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> TANH = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            QuaternionFloat16MatrixMember s = G.QHLF_MAT.construct();
            QuaternionFloat16MatrixMember c = G.QHLF_MAT.construct();
            QuaternionFloat16Matrix.this.sinhAndCosh().call(a, s, c);
            QuaternionFloat16Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SINCH = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            Sinch.compute(G.QHLF_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SINCHPI = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            Sinchpi.compute(G.QHLF_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SIN = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            TaylorEstimateSin.compute(18, G.QHLF_MAT, G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> COS = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            TaylorEstimateCos.compute(18, G.QHLF_MAT, G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> TAN = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            QuaternionFloat16MatrixMember s = G.QHLF_MAT.construct();
            QuaternionFloat16MatrixMember c = G.QHLF_MAT.construct();
            QuaternionFloat16Matrix.this.sinAndCos().call(a, s, c);
            QuaternionFloat16Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SINANDCOS = new Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember s, QuaternionFloat16MatrixMember c) {
            QuaternionFloat16Matrix.this.sin().call(a, s);
            QuaternionFloat16Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SINC = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            Sinc.compute(G.QHLF_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SINCPI = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            Sincpi.compute(G.QHLF_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> EXP = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            TaylorEstimateExp.compute(35, G.QHLF_MAT, G.QHLF, a, b);
        }
    };
    private final Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> LOG = new Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            TaylorEstimateLog.compute(8, G.QHLF_MAT, G.QHLF, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat16MatrixMember> ISZERO = new Function1<Boolean, QuaternionFloat16MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat16MatrixMember a) {
            return SequenceIsZero.compute(G.QHLF, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> PI = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            QuaternionFloat16Member pi = G.QHLF.construct();
            G.QHLF.PI().call(pi);
            MatrixConstantDiagonal.compute(G.QHLF, pi, a);
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> E = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            QuaternionFloat16Member e = G.QHLF.construct();
            G.QHLF.E().call(e);
            MatrixConstantDiagonal.compute(G.QHLF, e, a);
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> PHI = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            QuaternionFloat16Member phi = G.QHLF.construct();
            G.QHLF.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.QHLF, phi, a);
        }
    };
    private final Procedure1<QuaternionFloat16MatrixMember> GAMMA = new Procedure1<QuaternionFloat16MatrixMember>(){

        @Override
        public void call(QuaternionFloat16MatrixMember a) {
            QuaternionFloat16Member gamma = G.QHLF.construct();
            G.QHLF.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.QHLF, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.QHLF, a, b, c);
        }
    };
    private Procedure3<RationalMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SBR = new Procedure3<RationalMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(RationalMember a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            MatrixScaleByRational.compute(G.QHLF, a, b, c);
        }
    };
    private Procedure3<Double, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> SBD = new Procedure3<Double, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public void call(Double a, QuaternionFloat16MatrixMember b, QuaternionFloat16MatrixMember c) {
            MatrixScaleByDouble.compute(G.QHLF, a, b, c);
        }
    };
    private final Function3<Boolean, Float16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> WITHIN = new Function3<Boolean, Float16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember>(){

        @Override
        public Boolean call(Float16Member tol, QuaternionFloat16MatrixMember a, QuaternionFloat16MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.QHLF, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public QuaternionFloat16MatrixMember construct() {
        return new QuaternionFloat16MatrixMember();
    }

    @Override
    public QuaternionFloat16MatrixMember construct(QuaternionFloat16MatrixMember other) {
        return new QuaternionFloat16MatrixMember(other);
    }

    @Override
    public QuaternionFloat16MatrixMember construct(String s) {
        return new QuaternionFloat16MatrixMember(s);
    }

    @Override
    public QuaternionFloat16MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new QuaternionFloat16MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<QuaternionFloat16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, QuaternionFloat16MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<QuaternionFloat16MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float16Member, QuaternionFloat16MatrixMember, QuaternionFloat16MatrixMember> within() {
        return this.WITHIN;
    }
}

