/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.quaternion;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetQuaternion;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetQuaternion;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Util;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;

public final class QuaternionFloat16Member
implements NumberMember<QuaternionFloat16Member>,
ShortCoder,
Allocatable<QuaternionFloat16Member>,
Duplicatable<QuaternionFloat16Member>,
Settable<QuaternionFloat16Member>,
Gettable<QuaternionFloat16Member>,
PrimitiveConversion,
UniversalRepresentation,
SetQuaternion<Float16Member>,
GetQuaternion<Float16Member> {
    private static final short ZERO = Float16Util.convertFloatToHFloat(0.0f);
    private short r;
    private short i;
    private short j;
    private short k;

    public QuaternionFloat16Member() {
        this.primitiveInit();
    }

    public QuaternionFloat16Member(float r, float i, float j, float k) {
        this.setR(r);
        this.setI(i);
        this.setJ(j);
        this.setK(k);
    }

    public QuaternionFloat16Member(QuaternionFloat16Member value) {
        this.set(value);
    }

    public QuaternionFloat16Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        this.setR(val.r().floatValue());
        this.setI(val.i().floatValue());
        this.setJ(val.j().floatValue());
        this.setK(val.k().floatValue());
    }

    public float r() {
        return Float16Util.convertHFloatToFloat(this.r);
    }

    public float i() {
        return Float16Util.convertHFloatToFloat(this.i);
    }

    public float j() {
        return Float16Util.convertHFloatToFloat(this.j);
    }

    public float k() {
        return Float16Util.convertHFloatToFloat(this.k);
    }

    @Override
    public void setR(float val) {
        this.r = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setI(float val) {
        this.i = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setJ(float val) {
        this.j = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void setK(float val) {
        this.k = Float16Util.convertFloatToHFloat(val);
    }

    @Override
    public void set(QuaternionFloat16Member other) {
        this.r = other.r;
        this.i = other.i;
        this.j = other.j;
        this.k = other.k;
    }

    @Override
    public void get(QuaternionFloat16Member other) {
        other.r = this.r;
        other.i = this.i;
        other.j = this.j;
        other.k = this.k;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(this.r());
        builder.append(',');
        builder.append(this.i());
        builder.append(',');
        builder.append(this.j());
        builder.append(',');
        builder.append(this.k());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public int shortCount() {
        return 4;
    }

    @Override
    public void fromShortArray(short[] arr, int index) {
        this.r = arr[index];
        this.i = arr[index + 1];
        this.j = arr[index + 2];
        this.k = arr[index + 3];
    }

    @Override
    public void toShortArray(short[] arr, int index) {
        arr[index] = this.r;
        arr[index + 1] = this.i;
        arr[index + 2] = this.j;
        arr[index + 3] = this.k;
    }

    @Override
    public void fromShortFile(RandomAccessFile raf) throws IOException {
        this.r = raf.readShort();
        this.i = raf.readShort();
        this.j = raf.readShort();
        this.k = raf.readShort();
    }

    @Override
    public void toShortFile(RandomAccessFile raf) throws IOException {
        raf.writeShort(this.r);
        raf.writeShort(this.i);
        raf.writeShort(this.j);
        raf.writeShort(this.k);
    }

    @Override
    public QuaternionFloat16Member allocate() {
        return new QuaternionFloat16Member();
    }

    @Override
    public QuaternionFloat16Member duplicate() {
        return new QuaternionFloat16Member(this);
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(QuaternionFloat16Member value) {
        this.get(value);
    }

    @Override
    public void setV(QuaternionFloat16Member value) {
        this.set(value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(BigDecimal.valueOf(this.r()), BigDecimal.valueOf(this.i()), BigDecimal.valueOf(this.j()), BigDecimal.valueOf(this.k())));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionRepresentation v = rep.getValue();
        this.setR(v.r().floatValue());
        this.setI(v.i().floatValue());
        this.setJ(v.j().floatValue());
        this.setK(v.k().floatValue());
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.FLOAT;
    }

    @Override
    public long dimension(int i) {
        return 0L;
    }

    @Override
    public int componentCount() {
        return 4;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        if (component < 2) {
            if (component == 0) {
                this.setR((float)v);
            } else {
                this.setI((float)v);
            }
        } else if (component == 2) {
            this.setJ((float)v);
        } else {
            this.setK((float)v);
        }
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v.floatValue());
            } else {
                this.setI(v.floatValue());
            }
        } else if (component == 2) {
            this.setJ(v.floatValue());
        } else {
            this.setK(v.floatValue());
        }
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v.floatValue());
            } else {
                this.setI(v.floatValue());
            }
        } else if (component == 2) {
            this.setJ(v.floatValue());
        } else {
            this.setK(v.floatValue());
        }
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR((float)v);
            } else {
                this.setI((float)v);
            }
        } else if (component == 2) {
            this.setJ((float)v);
        } else {
            this.setK((float)v);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v.floatValue());
            } else {
                this.setI(v.floatValue());
            }
        } else if (component == 2) {
            this.setJ(v.floatValue());
        } else {
            this.setK(v.floatValue());
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v.floatValue());
            } else {
                this.setI(v.floatValue());
            }
        } else if (component == 2) {
            this.setJ(v.floatValue());
        } else {
            this.setK(v.floatValue());
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (byte)this.r();
            }
            return (byte)this.i();
        }
        if (component == 2) {
            return (byte)this.j();
        }
        return (byte)this.k();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (short)this.r();
            }
            return (short)this.i();
        }
        if (component == 2) {
            return (short)this.j();
        }
        return (short)this.k();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (int)this.r();
            }
            return (int)this.i();
        }
        if (component == 2) {
            return (int)this.j();
        }
        return (int)this.k();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (long)this.r();
            }
            return (long)this.i();
        }
        if (component == 2) {
            return (long)this.j();
        }
        return (long)this.k();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i()).toBigInteger();
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r());
            }
            return BigDecimal.valueOf(this.i());
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j());
        }
        return BigDecimal.valueOf(this.k());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return (byte)this.r();
            }
            return (byte)this.i();
        }
        if (component == 2) {
            return (byte)this.j();
        }
        return (byte)this.k();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return (short)this.r();
            }
            return (short)this.i();
        }
        if (component == 2) {
            return (short)this.j();
        }
        return (short)this.k();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return (int)this.r();
            }
            return (int)this.i();
        }
        if (component == 2) {
            return (int)this.j();
        }
        return (int)this.k();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        if (component < 2) {
            if (component == 0) {
                return (long)this.r();
            }
            return (long)this.i();
        }
        if (component == 2) {
            return (long)this.j();
        }
        return (long)this.k();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i()).toBigInteger();
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r());
            }
            return BigDecimal.valueOf(this.i());
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j());
        }
        return BigDecimal.valueOf(this.k());
    }

    @Override
    public void primitiveInit() {
        this.j = this.k = ZERO;
        this.i = this.k;
        this.r = this.k;
    }

    @Override
    public void setR(Float16Member val) {
        this.r = val.encV();
    }

    @Override
    public void setI(Float16Member val) {
        this.i = val.encV();
    }

    @Override
    public void setJ(Float16Member val) {
        this.j = val.encV();
    }

    @Override
    public void setK(Float16Member val) {
        this.k = val.encV();
    }

    @Override
    public void getR(Float16Member v) {
        v.setEncV(this.r);
    }

    @Override
    public void getI(Float16Member v) {
        v.setEncV(this.i);
    }

    @Override
    public void getJ(Float16Member v) {
        v.setEncV(this.j);
    }

    @Override
    public void getK(Float16Member v) {
        v.setEncV(this.k);
    }
}

