/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.real;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;
import nom.bdezonia.zorbage.type.algebra.InverseTrigonometric;
import nom.bdezonia.zorbage.type.algebra.ModularDivision;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OrderedField;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Util;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float16Algebra
implements OrderedField<Float16Algebra, Float16Member>,
Bounded<Float16Member>,
Norm<Float16Member, Float16Member>,
RealConstants<Float16Member>,
Exponential<Float16Member>,
Trigonometric<Float16Member>,
InverseTrigonometric<Float16Member>,
Hyperbolic<Float16Member>,
InverseHyperbolic<Float16Member>,
Infinite<Float16Member>,
NaN<Float16Member>,
Roots<Float16Member>,
Power<Float16Member>,
Rounding<Float16Member, Float16Member>,
Random<Float16Member>,
RealUnreal<Float16Member, Float16Member>,
ModularDivision<Float16Member>,
Conjugate<Float16Member>,
Scale<Float16Member, Float16Member>,
ScaleByHighPrec<Float16Member>,
ScaleByRational<Float16Member>,
ScaleByDouble<Float16Member>,
ScaleComponents<Float16Member, Float16Member>,
Tolerance<Float16Member, Float16Member> {
    private static final Float16Member PI = new Float16Member((float)Math.PI);
    private static final Float16Member E = new Float16Member((float)Math.E);
    private static final Float16Member GAMMA = new Float16Member(0.5772157f);
    private static final Float16Member PHI = new Float16Member(1.618034f);
    private final Function2<Boolean, Float16Member, Float16Member> EQ = new Function2<Boolean, Float16Member, Float16Member>(){

        @Override
        public Boolean call(Float16Member a, Float16Member b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, Float16Member, Float16Member> NEQ = new Function2<Boolean, Float16Member, Float16Member>(){

        @Override
        public Boolean call(Float16Member a, Float16Member b) {
            return a.v() != b.v();
        }
    };
    private final Procedure2<Float16Member, Float16Member> ASSIGN = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member from, Float16Member to) {
            to.set(from);
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> ADD = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            c.setV(a.v() + b.v());
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> SUB = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            c.setV(a.v() - b.v());
        }
    };
    private final Procedure1<Float16Member> ZER = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float16Member, Float16Member> NEG = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV(-a.v());
        }
    };
    private final Procedure1<Float16Member> UN = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            a.setV(1.0f);
        }
    };
    private final Procedure2<Float16Member, Float16Member> INV = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV(1.0f / a.v());
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> DIVIDE = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            c.setV(a.v() / b.v());
        }
    };
    private final Function2<Boolean, Float16Member, Float16Member> LS = new Function2<Boolean, Float16Member, Float16Member>(){

        @Override
        public Boolean call(Float16Member a, Float16Member b) {
            return a.v() < b.v();
        }
    };
    private final Function2<Boolean, Float16Member, Float16Member> LE = new Function2<Boolean, Float16Member, Float16Member>(){

        @Override
        public Boolean call(Float16Member a, Float16Member b) {
            return a.v() <= b.v();
        }
    };
    private final Function2<Boolean, Float16Member, Float16Member> GR = new Function2<Boolean, Float16Member, Float16Member>(){

        @Override
        public Boolean call(Float16Member a, Float16Member b) {
            return a.v() > b.v();
        }
    };
    private final Function2<Boolean, Float16Member, Float16Member> GRE = new Function2<Boolean, Float16Member, Float16Member>(){

        @Override
        public Boolean call(Float16Member a, Float16Member b) {
            return a.v() >= b.v();
        }
    };
    private final Function2<Integer, Float16Member, Float16Member> CMP = new Function2<Integer, Float16Member, Float16Member>(){

        @Override
        public Integer call(Float16Member a, Float16Member b) {
            float y;
            float x = a.v();
            if (x < (y = b.v())) {
                return -1;
            }
            if (x > y) {
                return 1;
            }
            return 0;
        }
    };
    private final Function1<Integer, Float16Member> SIG = new Function1<Integer, Float16Member>(){

        @Override
        public Integer call(Float16Member a) {
            float x = a.v();
            if (x < 0.0f) {
                return -1;
            }
            if (x > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    private Procedure1<Float16Member> MAXB = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            a.setV(Float16Util.convertHFloatToFloat((short)31743));
        }
    };
    private Procedure1<Float16Member> MINB = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            a.setV(Float16Util.convertHFloatToFloat((short)-1025));
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> MUL = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<Integer, Float16Member, Float16Member> POWER = new Procedure3<Integer, Float16Member, Float16Member>(){

        @Override
        public void call(Integer power, Float16Member a, Float16Member b) {
            if (power == 0 && a.v() == 0.0f) {
                b.setV(Float.NaN);
            } else {
                b.setV((float)FastMath.pow((double)a.v(), (double)power.intValue()));
            }
        }
    };
    private final Procedure2<Float16Member, Float16Member> ABS = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV(Math.abs(a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> NRM = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Float16Algebra.this.abs().call(a, b);
        }
    };
    private final Procedure1<Float16Member> _PI = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            Float16Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<Float16Member> _E = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            Float16Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<Float16Member> _GAMMA = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            Float16Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<Float16Member> _PHI = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            Float16Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure2<Float16Member, Float16Member> EXP = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.exp((double)a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> EXPM1 = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.expm1((double)a.v()));
        }
    };
    private Procedure2<Float16Member, Float16Member> LOG = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)Math.log(a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> LOG1P = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)Math.log1p(a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> COS = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.cos((double)a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> SIN = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.sin((double)a.v()));
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> SINCOS = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member s, Float16Member c) {
            Float16Algebra.this.sin().call(a, s);
            Float16Algebra.this.cos().call(a, c);
        }
    };
    private Procedure2<Float16Member, Float16Member> TAN = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.tan((double)a.v()));
        }
    };
    private Procedure2<Float16Member, Float16Member> CSC = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)(1.0 / FastMath.sin((double)a.v())));
        }
    };
    private Procedure2<Float16Member, Float16Member> SEC = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)(1.0 / FastMath.cos((double)a.v())));
        }
    };
    private Procedure2<Float16Member, Float16Member> COT = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)(1.0 / FastMath.tan((double)a.v())));
        }
    };
    private Procedure2<Float16Member, Float16Member> COSH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.cosh((double)a.v()));
        }
    };
    private Procedure2<Float16Member, Float16Member> SINH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.sinh((double)a.v()));
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> SINHCOSH = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member s, Float16Member c) {
            Float16Algebra.this.sinh().call(a, s);
            Float16Algebra.this.cosh().call(a, c);
        }
    };
    private final Procedure2<Float16Member, Float16Member> TANH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.tanh((double)a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> CSCH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)(1.0 / FastMath.sinh((double)a.v())));
        }
    };
    private final Procedure2<Float16Member, Float16Member> SECH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)(1.0 / FastMath.cosh((double)a.v())));
        }
    };
    private final Procedure2<Float16Member, Float16Member> COTH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)(1.0 / FastMath.tanh((double)a.v())));
        }
    };
    private final Procedure2<Float16Member, Float16Member> ACOS = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.acos((double)a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> ASIN = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.asin((double)a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> ATAN = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.atan((double)a.v()));
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> ATAN2 = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            c.setV((float)FastMath.atan2((double)a.v(), (double)b.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> ACSC = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Float16Member tmp = new Float16Member(1.0f / a.v());
            Float16Algebra.this.asin().call(tmp, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> ASEC = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Float16Member tmp = new Float16Member(1.0f / a.v());
            Float16Algebra.this.acos().call(tmp, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> ACOT = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Float16Member tmp = new Float16Member(1.0f / a.v());
            Float16Algebra.this.atan().call(tmp, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> ACOSH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            float x = a.v();
            b.setV((float)Math.log((double)x + Math.sqrt(x * x - 1.0f)));
        }
    };
    private final Procedure2<Float16Member, Float16Member> ASINH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            float x = a.v();
            b.setV((float)Math.log((double)x + Math.sqrt(x * x + 1.0f)));
        }
    };
    private final Procedure2<Float16Member, Float16Member> ATANH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            float x = a.v();
            b.setV((float)(0.5 * (-Math.log(1.0f - x) + Math.log(1.0f + x))));
        }
    };
    private final Procedure2<Float16Member, Float16Member> ACSCH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Float16Member tmp = new Float16Member(1.0f / a.v());
            Float16Algebra.this.asinh().call(tmp, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> ASECH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Float16Member tmp = new Float16Member(1.0f / a.v());
            Float16Algebra.this.acosh().call(tmp, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> ACOTH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Float16Member tmp = new Float16Member(1.0f / a.v());
            Float16Algebra.this.atanh().call(tmp, b);
        }
    };
    private final Function1<Boolean, Float16Member> ISNAN = new Function1<Boolean, Float16Member>(){

        @Override
        public Boolean call(Float16Member a) {
            return Float.isNaN(a.v());
        }
    };
    private final Procedure1<Float16Member> NAN = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            a.setV(Float.NaN);
        }
    };
    private final Function1<Boolean, Float16Member> ISINF = new Function1<Boolean, Float16Member>(){

        @Override
        public Boolean call(Float16Member a) {
            return Float.isInfinite(a.v());
        }
    };
    private final Procedure1<Float16Member> INF = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            a.setV(Float.POSITIVE_INFINITY);
        }
    };
    private final Procedure1<Float16Member> NINF = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            a.setV(Float.NEGATIVE_INFINITY);
        }
    };
    private final Procedure2<Float16Member, Float16Member> SQRT = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)Math.sqrt(a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> CBRT = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)FastMath.cbrt((double)a.v()));
        }
    };
    private final Procedure4<Round.Mode, Float16Member, Float16Member, Float16Member> ROUND = new Procedure4<Round.Mode, Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, Float16Member a, Float16Member b) {
            Round.compute(G.HLF, mode, delta, a, b);
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> MIN = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            Min.compute(G.HLF, a, b, c);
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> MAX = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            Max.compute(G.HLF, a, b, c);
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> POW = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            if (a.v() == 0.0f && b.v() == 0.0f) {
                c.setV(Float.NaN);
            } else {
                c.setV((float)FastMath.pow((double)a.v(), (double)b.v()));
            }
        }
    };
    private final Procedure2<Float16Member, Float16Member> LOG10 = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)Math.log10(a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> DEG = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)Math.toDegrees(a.v()));
        }
    };
    private final Procedure2<Float16Member, Float16Member> RAD = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV((float)Math.toRadians(a.v()));
        }
    };
    private final Procedure1<Float16Member> RAND = new Procedure1<Float16Member>(){

        @Override
        public void call(Float16Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextFloat());
        }
    };
    private final Procedure2<Float16Member, Float16Member> REAL = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV(a.v());
        }
    };
    private final Procedure2<Float16Member, Float16Member> UNREAL = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            b.setV(0.0f);
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> DIV = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member d) {
            double v = a.v() / b.v();
            v = v > 0.0 ? Math.floor(v) : Math.ceil(v);
            d.setV((float)v);
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> MOD = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member m) {
            m.setV(a.v() % b.v());
        }
    };
    private final Procedure4<Float16Member, Float16Member, Float16Member, Float16Member> DIVMOD = new Procedure4<Float16Member, Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member d, Float16Member m) {
            Float16Algebra.this.div().call(a, b, d);
            Float16Algebra.this.mod().call(a, b, m);
        }
    };
    private final Procedure2<Float16Member, Float16Member> SINCH = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Sinch.compute(G.HLF, a, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> SINCHPI = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Sinchpi.compute(G.HLF, a, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> SINC = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Sinc.compute(G.HLF, a, b);
        }
    };
    private final Procedure2<Float16Member, Float16Member> SINCPI = new Procedure2<Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b) {
            Sincpi.compute(G.HLF, a, b);
        }
    };
    private final Function1<Boolean, Float16Member> ISZERO = new Function1<Boolean, Float16Member>(){

        @Override
        public Boolean call(Float16Member a) {
            return a.v() == 0.0f;
        }
    };
    private final Procedure3<HighPrecisionMember, Float16Member, Float16Member> SBHP = new Procedure3<HighPrecisionMember, Float16Member, Float16Member>(){

        @Override
        public void call(HighPrecisionMember a, Float16Member b, Float16Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.v()));
            c.setV(tmp.floatValue());
        }
    };
    private final Procedure3<RationalMember, Float16Member, Float16Member> SBR = new Procedure3<RationalMember, Float16Member, Float16Member>(){

        @Override
        public void call(RationalMember a, Float16Member b, Float16Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.v());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setV(tmp.floatValue());
        }
    };
    private final Procedure3<Double, Float16Member, Float16Member> SBD = new Procedure3<Double, Float16Member, Float16Member>(){

        @Override
        public void call(Double a, Float16Member b, Float16Member c) {
            c.setV((float)(a * (double)b.v()));
        }
    };
    private final Procedure3<Float16Member, Float16Member, Float16Member> SC = new Procedure3<Float16Member, Float16Member, Float16Member>(){

        @Override
        public void call(Float16Member a, Float16Member b, Float16Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Function3<Boolean, Float16Member, Float16Member, Float16Member> WITHIN = new Function3<Boolean, Float16Member, Float16Member, Float16Member>(){

        @Override
        public Boolean call(Float16Member tol, Float16Member a, Float16Member b) {
            return NumberWithin.compute(G.HLF, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, Float16Member, Float16Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float16Member, Float16Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Float16Member construct() {
        return new Float16Member();
    }

    @Override
    public Float16Member construct(Float16Member other) {
        return new Float16Member(other);
    }

    @Override
    public Float16Member construct(String s) {
        return new Float16Member(s);
    }

    @Override
    public Procedure2<Float16Member, Float16Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<Float16Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure1<Float16Member> unity() {
        return this.UN;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Function2<Boolean, Float16Member, Float16Member> isLess() {
        return this.LS;
    }

    @Override
    public Function2<Boolean, Float16Member, Float16Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, Float16Member, Float16Member> isGreater() {
        return this.GR;
    }

    @Override
    public Function2<Boolean, Float16Member, Float16Member> isGreaterEqual() {
        return this.GRE;
    }

    @Override
    public Function2<Integer, Float16Member, Float16Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<Integer, Float16Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure1<Float16Member> maxBound() {
        return this.MAXB;
    }

    @Override
    public Procedure1<Float16Member> minBound() {
        return this.MINB;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, Float16Member, Float16Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> norm() {
        return this.NRM;
    }

    @Override
    public Procedure1<Float16Member> PI() {
        return this._PI;
    }

    @Override
    public Procedure1<Float16Member> E() {
        return this._E;
    }

    @Override
    public Procedure1<Float16Member> GAMMA() {
        return this._GAMMA;
    }

    @Override
    public Procedure1<Float16Member> PHI() {
        return this._PHI;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> exp() {
        return this.EXP;
    }

    public Procedure2<Float16Member, Float16Member> expm1() {
        return this.EXPM1;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> log() {
        return this.LOG;
    }

    public Procedure2<Float16Member, Float16Member> log1p() {
        return this.LOG1P;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> sinAndCos() {
        return this.SINCOS;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> tan() {
        return this.TAN;
    }

    public Procedure2<Float16Member, Float16Member> csc() {
        return this.CSC;
    }

    public Procedure2<Float16Member, Float16Member> sec() {
        return this.SEC;
    }

    public Procedure2<Float16Member, Float16Member> cot() {
        return this.COT;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> sinhAndCosh() {
        return this.SINHCOSH;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> tanh() {
        return this.TANH;
    }

    public Procedure2<Float16Member, Float16Member> csch() {
        return this.CSCH;
    }

    public Procedure2<Float16Member, Float16Member> sech() {
        return this.SECH;
    }

    public Procedure2<Float16Member, Float16Member> coth(Float16Member a, Float16Member b) {
        return this.COTH;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> acos() {
        return this.ACOS;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> asin() {
        return this.ASIN;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> atan() {
        return this.ATAN;
    }

    public Procedure3<Float16Member, Float16Member, Float16Member> atan2() {
        return this.ATAN2;
    }

    public Procedure2<Float16Member, Float16Member> acsc() {
        return this.ACSC;
    }

    public Procedure2<Float16Member, Float16Member> asec() {
        return this.ASEC;
    }

    public Procedure2<Float16Member, Float16Member> acot() {
        return this.ACOT;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> acosh() {
        return this.ACOSH;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> asinh() {
        return this.ASINH;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> atanh() {
        return this.ATANH;
    }

    public Procedure2<Float16Member, Float16Member> acsch() {
        return this.ACSCH;
    }

    public Procedure2<Float16Member, Float16Member> asech() {
        return this.ASECH;
    }

    public Procedure2<Float16Member, Float16Member> acoth() {
        return this.ACOTH;
    }

    @Override
    public Function1<Boolean, Float16Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float16Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float16Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float16Member> infinite() {
        return this.INF;
    }

    public Procedure1<Float16Member> negInfinite() {
        return this.NINF;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, Float16Member, Float16Member> round() {
        return this.ROUND;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> pow() {
        return this.POW;
    }

    public Procedure2<Float16Member, Float16Member> log10() {
        return this.LOG10;
    }

    public Procedure2<Float16Member, Float16Member> toDegrees() {
        return this.DEG;
    }

    public Procedure2<Float16Member, Float16Member> toRadians() {
        return this.RAD;
    }

    @Override
    public Procedure1<Float16Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<Float16Member, Float16Member, Float16Member, Float16Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Function1<Boolean, Float16Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure2<Float16Member, Float16Member> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float16Member, Float16Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float16Member, Float16Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float16Member, Float16Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float16Member, Float16Member, Float16Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float16Member, Float16Member, Float16Member> within() {
        return this.WITHIN;
    }
}

