/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Algebra;
import nom.bdezonia.zorbage.type.data.float16.real.Float16CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float16CartesianTensorProduct
implements TensorProduct<Float16CartesianTensorProduct, Float16CartesianTensorProductMember, Float16Algebra, Float16Member>,
ConstructibleNdLong<Float16CartesianTensorProductMember>,
Norm<Float16CartesianTensorProductMember, Float16Member>,
Scale<Float16CartesianTensorProductMember, Float16Member>,
Rounding<Float16Member, Float16CartesianTensorProductMember>,
Infinite<Float16CartesianTensorProductMember>,
NaN<Float16CartesianTensorProductMember>,
ScaleByHighPrec<Float16CartesianTensorProductMember>,
ScaleByRational<Float16CartesianTensorProductMember>,
ScaleByDouble<Float16CartesianTensorProductMember>,
Tolerance<Float16Member, Float16CartesianTensorProductMember> {
    private final Function2<Boolean, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> EQ = new Function2<Boolean, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.HLF, G.HLF.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> NEQ = new Function2<Boolean, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            return Float16CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> ASSIGN = new Procedure2<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember from, Float16CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.HLF, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<Float16CartesianTensorProductMember> ZER = new Procedure1<Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> NEG = new Procedure2<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.HLF, G.HLF.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> ADDEL = new Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b, Float16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HLF, G.HLF.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> SUBEL = new Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b, Float16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HLF, G.HLF.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<Float16CartesianTensorProductMember, Float16Member> NORM = new Procedure2<Float16CartesianTensorProductMember, Float16Member>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16Member b) {
            TensorNorm.compute(G.HLF, G.HLF, a.rawData(), b);
        }
    };
    private final Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> SCALE = new Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16Member scalar, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.HLF, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> ADDSCALAR = new Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16Member scalar, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.HLF, scalar, G.HLF.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> SUBSCALAR = new Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16Member scalar, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            Float16Member tmp = G.HLF.construct();
            G.HLF.negate().call(scalar, tmp);
            Float16CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> MULEL = new Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b, Float16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HLF, G.HLF.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> DIVIDEEL = new Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b, Float16CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.HLF, G.HLF.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> MUL = new Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b, Float16CartesianTensorProductMember c) {
            Float16CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorContract.compute(G.HLF, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> SEMI = new Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.HLF_TEN, G.HLF, index, a, b);
        }
    };
    private final Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> COMMA = new Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.HLF_TEN, G.HLF, index, a, b);
        }
    };
    private final Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> POWER = new Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorPower.compute(G.HLF_TEN, power, a, b);
        }
    };
    private final Procedure1<Float16CartesianTensorProductMember> UNITY = new Procedure1<Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember result) {
            TensorUnity.compute(G.HLF_TEN, G.HLF, result);
        }
    };
    private final Function1<Boolean, Float16CartesianTensorProductMember> ISNAN = new Function1<Boolean, Float16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure1<Float16CartesianTensorProductMember> NAN = new Procedure1<Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a) {
            FillNaN.compute(G.HLF, a);
        }
    };
    private final Function1<Boolean, Float16CartesianTensorProductMember> ISINF = new Function1<Boolean, Float16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure1<Float16CartesianTensorProductMember> INF = new Procedure1<Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a) {
            FillInfinite.compute(G.HLF, a);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorRound.compute(G.HLF_TEN, G.HLF, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float16CartesianTensorProductMember> ISZERO = new Function1<Boolean, Float16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure3<RationalMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> SBR = new Procedure3<RationalMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.HLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> SBD = new Procedure3<Double, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.HLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.HLF, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float16Member tol, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.HLF, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> MULBYSCALAR = new Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16Member factor, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            Float16CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16Member factor, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            Float16Member invFactor = G.HLF.construct();
            G.HLF.invert().call(factor, invFactor);
            Float16CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> RAISE = new Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> LOWER = new Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            Float16CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b, Float16CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            Float16CartesianTensorProductMember tmp = Float16CartesianTensorProduct.this.construct();
            Float16CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            Float16CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> OUTER = new Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember>(){

        @Override
        public void call(Float16CartesianTensorProductMember a, Float16CartesianTensorProductMember b, Float16CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.HLF_TEN, G.HLF, a, b, c);
        }
    };

    @Override
    public Float16CartesianTensorProductMember construct() {
        return new Float16CartesianTensorProductMember();
    }

    @Override
    public Float16CartesianTensorProductMember construct(Float16CartesianTensorProductMember other) {
        return new Float16CartesianTensorProductMember(other);
    }

    @Override
    public Float16CartesianTensorProductMember construct(String s) {
        return new Float16CartesianTensorProductMember(s);
    }

    @Override
    public Float16CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new Float16CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<Float16CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<Float16CartesianTensorProductMember, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<Float16CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, Float16CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float16CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float16CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float16CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float16CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<Float16Member, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<Float16CartesianTensorProductMember, Float16CartesianTensorProductMember, Float16CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

