/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.real;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.misc.LongUtils;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class Float16CartesianTensorProductMember
implements TensorMember<Float16Member>,
Gettable<Float16CartesianTensorProductMember>,
Settable<Float16CartesianTensorProductMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<Float16Member> {
    private static final Float16Member ZERO = new Float16Member();
    private int rank;
    private long dimCount;
    private IndexedDataSource<Float16Member> storage;
    private long[] dims;
    private long[] multipliers;
    private StorageConstruction s;
    private static ThreadLocal<Float16Member> tmpFloat = new ThreadLocal<Float16Member>(){

        @Override
        protected Float16Member initialValue() {
            return new Float16Member();
        }
    };

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        return this.rank;
    }

    @Override
    public int upperRank() {
        return 0;
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return true;
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return false;
    }

    @Override
    public long dimension() {
        return this.dimCount;
    }

    public Float16CartesianTensorProductMember() {
        this.rank = 0;
        this.dimCount = 0L;
        this.dims = new long[0];
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, 1L, new Float16Member());
        this.multipliers = this.calcMultipliers();
    }

    public Float16CartesianTensorProductMember(int rank, long dimCount) {
        if (rank < 0) {
            throw new IllegalArgumentException("bad rank in tensor constructor");
        }
        if (dimCount < 0L) {
            throw new IllegalArgumentException("bad dimensionality in tensor constructor");
        }
        this.rank = rank;
        this.dimCount = dimCount;
        this.dims = new long[rank];
        for (int i = 0; i < rank; ++i) {
            this.dims[i] = dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new Float16Member());
        this.multipliers = this.calcMultipliers();
    }

    public Float16CartesianTensorProductMember(int rank, long dimCount, float[] vals) {
        this(rank, dimCount);
        if ((long)vals.length != this.storage.size()) {
            throw new IllegalArgumentException("incorrect number of values given in tensor constructor");
        }
        Float16Member value = new Float16Member();
        for (int i = 0; i < vals.length; ++i) {
            value.setV(vals[i]);
            this.storage.set(i, value);
        }
    }

    public Float16CartesianTensorProductMember(long[] dims) {
        this.rank = dims.length;
        long max = 0L;
        for (long d : dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new Float16Member());
        this.multipliers = this.calcMultipliers();
    }

    public Float16CartesianTensorProductMember(long[] dims, float[] vals) {
        this(dims);
        long numElems = LongUtils.numElements(dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        if ((long)vals.length != numElems) {
            throw new IllegalArgumentException("incorrect number of values provided to tensor constructor");
        }
        Float16Member value = new Float16Member();
        if (numElems == 1L) {
            value.setV(vals[0]);
            this.storage.set(0L, value);
        } else {
            int i;
            long[] point1 = new long[dims.length];
            long[] point2 = new long[dims.length];
            for (i = 0; i < dims.length; ++i) {
                point2[i] = dims[i] - 1L;
            }
            i = 0;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                value.setV(vals[i]);
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                ++i;
            }
        }
    }

    public Float16CartesianTensorProductMember(Float16CartesianTensorProductMember other) {
        this.set(other);
    }

    public Float16CartesianTensorProductMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.values();
        long[] tmpDims = (long[])rep.dimensions().clone();
        this.rank = tmpDims.length;
        long max = 0L;
        for (long d : tmpDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new Float16Member());
        this.multipliers = this.calcMultipliers();
        Float16Member value = new Float16Member();
        if (numElems == 1L) {
            OctonionRepresentation val = data.get(0L);
            value.setV(val.r().floatValue());
            this.storage.set(0L, value);
        } else {
            long[] point1 = new long[tmpDims.length];
            long[] point2 = new long[tmpDims.length];
            for (int i = 0; i < tmpDims.length; ++i) {
                point2[i] = tmpDims[i] - 1L;
            }
            long i = 0L;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(this.dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                OctonionRepresentation val = data.get(i);
                value.setV(val.r().floatValue());
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                ++i;
            }
        }
    }

    public Float16CartesianTensorProductMember(StorageConstruction s, long[] nd) {
        this.rank = this.dims.length;
        long max = 0L;
        for (long d : this.dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        this.s = s;
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.storage = Storage.allocate(s, numElems, new Float16Member());
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public void set(Float16CartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        this.rank = other.rank;
        this.dimCount = other.dimCount;
        this.dims = (long[])other.dims.clone();
        this.multipliers = (long[])other.multipliers.clone();
        this.storage = (IndexedDataSource)other.storage.duplicate();
        this.s = other.s;
    }

    @Override
    public void get(Float16CartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        other.rank = this.rank;
        other.dimCount = this.dimCount;
        other.dims = (long[])this.dims.clone();
        other.multipliers = (long[])this.multipliers.clone();
        other.storage = (IndexedDataSource)this.storage.duplicate();
        other.s = this.s;
    }

    @Override
    public boolean alloc(long[] newDims) {
        boolean theSame = true;
        if (newDims.length != this.dims.length) {
            theSame = false;
        } else {
            for (int i = 0; i < newDims.length; ++i) {
                if (newDims[i] == this.dims[i]) continue;
                theSame = false;
                break;
            }
        }
        if (theSame) {
            return false;
        }
        this.rank = newDims.length;
        long max = 0L;
        for (long d : newDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        long newCount = LongUtils.numElements(this.dims);
        if (newCount == 0L) {
            newCount = 1L;
        }
        if (this.storage == null || newCount != this.storage.size()) {
            this.storage = Storage.allocate(this.s, newCount, new Float16Member());
            return true;
        }
        return false;
    }

    @Override
    public void init(long[] newDims) {
        if (!this.alloc(newDims)) {
            long storageSize = this.storage.size();
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    public long numElems() {
        return this.storage.size();
    }

    void v(long index, Float16Member value) {
        this.storage.get(index, value);
    }

    @Override
    public void v(IntegerIndex index, Float16Member value) {
        long idx = this.indexToLong(index);
        this.storage.get(idx, value);
    }

    void setV(long index, Float16Member value) {
        this.storage.set(index, value);
    }

    @Override
    public void setV(IntegerIndex index, Float16Member value) {
        long idx = this.indexToLong(index);
        this.storage.set(idx, value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        Float16Member value = new Float16Member();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = BigDecimal.valueOf(value.v());
            OctonionRepresentation o = new OctonionRepresentation(re);
            values.set(i, o);
        }
        rep.setTensor(this.dims, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        Float16Member value = new Float16Member();
        BigList<OctonionRepresentation> tensor = rep.getTensor();
        this.init(rep.getTensorDims());
        long tensorSize = tensor.size();
        for (long i = 0L; i < tensorSize; ++i) {
            OctonionRepresentation o = tensor.get(i);
            value.setV(o.r().floatValue());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Float16Member tmp = new Float16Member();
        IntegerIndex index = new IntegerIndex(this.dims.length);
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, tmp);
            this.longToIntegerIndex(i, index);
            int j = 0;
            while (j < index.numDimensions() && index.get(j++) == 0L) {
                builder.append('[');
            }
            if (index.get(0) != 0L) {
                builder.append(',');
            }
            builder.append(tmp.v());
            j = 0;
            while (j < index.numDimensions() && index.get(j) == this.dims[j++] - 1L) {
                builder.append(']');
            }
        }
        return builder.toString();
    }

    private long[] calcMultipliers() {
        if (this.dims.length == 0) {
            return new long[0];
        }
        long[] result = new long[this.dims.length - 1];
        long mult = 1L;
        for (int i = 0; i < result.length; ++i) {
            result[i] = mult;
            mult *= this.dims[i];
        }
        return result;
    }

    private long indexToLong(IntegerIndex idx) {
        if (idx.numDimensions() == 0) {
            throw new IllegalArgumentException("null index");
        }
        if (idx.numDimensions() >= this.dims.length && this.indexOob(idx, 0)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        long index = 0L;
        long mult = 1L;
        for (int i = 0; i < this.dims.length; ++i) {
            index += mult * idx.get(i);
            mult *= this.dims[i];
        }
        return index;
    }

    private void longToIntegerIndex(long idx, IntegerIndex result) {
        int i;
        if (idx < 0L) {
            throw new IllegalArgumentException("negative index in tensor addressing");
        }
        if (idx >= this.storage.size()) {
            throw new IllegalArgumentException("index beyond end of tensor storage");
        }
        if (result.numDimensions() < this.dims.length) {
            throw new IllegalArgumentException("mismatched dims in tensor member");
        }
        for (i = this.dims.length; i < result.numDimensions(); ++i) {
            result.set(i, 0L);
        }
        for (i = this.dims.length - 1; i >= 0; --i) {
            result.set(i, idx / this.multipliers[i]);
            idx %= this.multipliers[i];
        }
    }

    private boolean indexOob(IntegerIndex idx, int component) {
        long index;
        int i;
        if (component < 0) {
            throw new IllegalArgumentException("negative component specified in indexOob");
        }
        if (component > 0) {
            return true;
        }
        for (i = 0; i < this.dims.length; ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index < this.dims[i]) continue;
            return true;
        }
        for (i = this.dims.length; i < idx.numDimensions(); ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int numDimensions() {
        return this.dims.length;
    }

    @Override
    public void reshape(long[] dims) {
        if (Arrays.equals(this.dims, dims)) {
            return;
        }
        throw new IllegalArgumentException("to implement");
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d >= this.dims.length) {
            return 1L;
        }
        return this.dims[d];
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.FLOAT;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV((float)v);
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV(v.floatValue());
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        Float16Member tmp = tmpFloat.get();
        tmp.setV(v.floatValue());
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        if (this.indexOob(index, component)) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV((float)v);
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV(v.floatValue());
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float16Member tmp = tmpFloat.get();
            tmp.setV(v.floatValue());
            this.setV(index, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return (byte)tmp.v();
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return (short)tmp.v();
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return (int)tmp.v();
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return (long)tmp.v();
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return tmp.v();
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return tmp.v();
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return BigDecimal.valueOf(tmp.v()).toBigInteger();
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float16Member tmp = tmpFloat.get();
            this.v(index, tmp);
            return BigDecimal.valueOf(tmp.v());
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return (byte)tmp.v();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return (short)tmp.v();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return (int)tmp.v();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0L;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return (long)tmp.v();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0f;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return tmp.v();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return tmp.v();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigInteger.ZERO;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return BigDecimal.valueOf(tmp.v()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigDecimal.ZERO;
        }
        Float16Member tmp = tmpFloat.get();
        this.v(index, tmp);
        return BigDecimal.valueOf(tmp.v());
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<Float16Member> rawData() {
        return this.storage;
    }
}

