/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Algebra;
import nom.bdezonia.zorbage.type.data.float16.real.Float16MatrixMember;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float16Matrix
implements RingWithUnity<Float16Matrix, Float16MatrixMember>,
MatrixRing<Float16Matrix, Float16MatrixMember, Float16Algebra, Float16Member>,
Constructible2dLong<Float16MatrixMember>,
Rounding<Float16Member, Float16MatrixMember>,
Norm<Float16MatrixMember, Float16Member>,
DirectProduct<Float16MatrixMember, Float16MatrixMember>,
Exponential<Float16MatrixMember>,
Trigonometric<Float16MatrixMember>,
Hyperbolic<Float16MatrixMember>,
RealConstants<Float16MatrixMember>,
Infinite<Float16MatrixMember>,
NaN<Float16MatrixMember>,
ScaleByHighPrec<Float16MatrixMember>,
ScaleByRational<Float16MatrixMember>,
ScaleByDouble<Float16MatrixMember>,
Tolerance<Float16Member, Float16MatrixMember> {
    private final Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> MUL = new Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b, Float16MatrixMember c) {
            MatrixMultiply.compute(G.HLF, a, b, c);
        }
    };
    private final Procedure3<Integer, Float16MatrixMember, Float16MatrixMember> POWER = new Procedure3<Integer, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Integer power, Float16MatrixMember a, Float16MatrixMember b) {
            MatrixPower.compute(power, G.HLF, G.HLF_VEC, G.HLF_MAT, a, b);
        }
    };
    private final Procedure1<Float16MatrixMember> ZER = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> NEG = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            MatrixNegate.compute(G.HLF, a, b);
        }
    };
    private final Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> ADD = new Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b, Float16MatrixMember c) {
            MatrixAddition.compute(G.HLF, a, b, c);
        }
    };
    private final Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> SUB = new Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b, Float16MatrixMember c) {
            MatrixSubtraction.compute(G.HLF, a, b, c);
        }
    };
    private final Function2<Boolean, Float16MatrixMember, Float16MatrixMember> EQ = new Function2<Boolean, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public Boolean call(Float16MatrixMember a, Float16MatrixMember b) {
            return MatrixEqual.compute(G.HLF, a, b);
        }
    };
    private final Function2<Boolean, Float16MatrixMember, Float16MatrixMember> NEQ = new Function2<Boolean, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public Boolean call(Float16MatrixMember a, Float16MatrixMember b) {
            return Float16Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> ASSIGN = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember from, Float16MatrixMember to) {
            MatrixAssign.compute(G.HLF, from, to);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16Member> NORM = new Procedure2<Float16MatrixMember, Float16Member>(){

        @Override
        public void call(Float16MatrixMember a, Float16Member b) {
            MatrixSpectralNorm.compute(G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, Float16MatrixMember, Float16MatrixMember> ROUND = new Procedure4<Round.Mode, Float16Member, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, Float16MatrixMember a, Float16MatrixMember b) {
            MatrixRound.compute(G.HLF, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float16MatrixMember> ISNAN = new Function1<Boolean, Float16MatrixMember>(){

        @Override
        public Boolean call(Float16MatrixMember a) {
            return SequenceIsNan.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure1<Float16MatrixMember> NAN = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            FillNaN.compute(G.HLF, a);
        }
    };
    private final Function1<Boolean, Float16MatrixMember> ISINF = new Function1<Boolean, Float16MatrixMember>(){

        @Override
        public Boolean call(Float16MatrixMember a) {
            return SequenceIsInf.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure1<Float16MatrixMember> INF = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            FillInfinite.compute(G.HLF, a);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> TRANSP = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            MatrixTranspose.compute(G.HLF, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> CONJTRANSP = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            Float16Matrix.this.transpose().call(a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16Member> DET = new Procedure2<Float16MatrixMember, Float16Member>(){

        @Override
        public void call(Float16MatrixMember a, Float16Member b) {
            MatrixDeterminant.compute(G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure1<Float16MatrixMember> UNITY = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            MatrixUnity.compute(G.HLF, a);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> INV = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            MatrixInvert.compute(G.HLF, G.HLF_VEC, G.HLF_MAT, a, b);
        }
    };
    private final Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> DIVIDE = new Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b, Float16MatrixMember c) {
            Float16MatrixMember invB = Float16Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            Float16Matrix.this.invert().call(b, invB);
            Float16Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> DP = new Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember in1, Float16MatrixMember in2, Float16MatrixMember out) {
            MatrixDirectProduct.compute(G.HLF, in1, in2, out);
        }
    };
    private final Procedure3<Float16Member, Float16MatrixMember, Float16MatrixMember> SCALE = new Procedure3<Float16Member, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16Member a, Float16MatrixMember b, Float16MatrixMember c) {
            MatrixScale.compute(G.HLF, a, b, c);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> SINH = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> COSH = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> SINHANDCOSH = new Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember s, Float16MatrixMember c) {
            Float16Matrix.this.sinh().call(a, s);
            Float16Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> TANH = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            Float16MatrixMember s = G.HLF_MAT.construct();
            Float16MatrixMember c = G.HLF_MAT.construct();
            Float16Matrix.this.sinhAndCosh().call(a, s, c);
            Float16Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> SINCH = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            Sinch.compute(G.HLF_MAT, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> SINCHPI = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            Sinchpi.compute(G.HLF_MAT, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> SIN = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            TaylorEstimateSin.compute(18, G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> COS = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            TaylorEstimateCos.compute(18, G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> TAN = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            Float16MatrixMember s = G.HLF_MAT.construct();
            Float16MatrixMember c = G.HLF_MAT.construct();
            Float16Matrix.this.sinAndCos().call(a, s, c);
            Float16Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> SINANDCOS = new Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember s, Float16MatrixMember c) {
            Float16Matrix.this.sin().call(a, s);
            Float16Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> SINC = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            Sinc.compute(G.HLF_MAT, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> SINCPI = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            Sincpi.compute(G.HLF_MAT, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> EXP = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            TaylorEstimateExp.compute(35, G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Procedure2<Float16MatrixMember, Float16MatrixMember> LOG = new Procedure2<Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a, Float16MatrixMember b) {
            TaylorEstimateLog.compute(8, G.HLF_MAT, G.HLF, a, b);
        }
    };
    private final Function1<Boolean, Float16MatrixMember> ISZERO = new Function1<Boolean, Float16MatrixMember>(){

        @Override
        public Boolean call(Float16MatrixMember a) {
            return SequenceIsZero.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure1<Float16MatrixMember> PI = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            Float16Member pi = G.HLF.construct();
            G.HLF.PI().call(pi);
            MatrixConstantDiagonal.compute(G.HLF, pi, a);
        }
    };
    private final Procedure1<Float16MatrixMember> E = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            Float16Member e = G.HLF.construct();
            G.HLF.E().call(e);
            MatrixConstantDiagonal.compute(G.HLF, e, a);
        }
    };
    private final Procedure1<Float16MatrixMember> PHI = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            Float16Member phi = G.HLF.construct();
            G.HLF.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.HLF, phi, a);
        }
    };
    private final Procedure1<Float16MatrixMember> GAMMA = new Procedure1<Float16MatrixMember>(){

        @Override
        public void call(Float16MatrixMember a) {
            Float16Member gamma = G.HLF.construct();
            G.HLF.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.HLF, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, Float16MatrixMember, Float16MatrixMember> SBHP = new Procedure3<HighPrecisionMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, Float16MatrixMember b, Float16MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.HLF, a, b, c);
        }
    };
    private Procedure3<RationalMember, Float16MatrixMember, Float16MatrixMember> SBR = new Procedure3<RationalMember, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(RationalMember a, Float16MatrixMember b, Float16MatrixMember c) {
            MatrixScaleByRational.compute(G.HLF, a, b, c);
        }
    };
    private Procedure3<Double, Float16MatrixMember, Float16MatrixMember> SBD = new Procedure3<Double, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public void call(Double a, Float16MatrixMember b, Float16MatrixMember c) {
            MatrixScaleByDouble.compute(G.HLF, a, b, c);
        }
    };
    private final Function3<Boolean, Float16Member, Float16MatrixMember, Float16MatrixMember> WITHIN = new Function3<Boolean, Float16Member, Float16MatrixMember, Float16MatrixMember>(){

        @Override
        public Boolean call(Float16Member tol, Float16MatrixMember a, Float16MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.HLF, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, Float16MatrixMember, Float16MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<Float16MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, Float16MatrixMember, Float16MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float16MatrixMember, Float16MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Float16MatrixMember construct() {
        return new Float16MatrixMember();
    }

    @Override
    public Float16MatrixMember construct(Float16MatrixMember other) {
        return new Float16MatrixMember(other);
    }

    @Override
    public Float16MatrixMember construct(String s) {
        return new Float16MatrixMember(s);
    }

    @Override
    public Float16MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new Float16MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, Float16MatrixMember, Float16MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float16MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float16MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float16MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float16MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<Float16MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<Float16Member, Float16MatrixMember, Float16MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<Float16MatrixMember, Float16MatrixMember, Float16MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<Float16MatrixMember, Float16MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, Float16MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<Float16MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<Float16MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<Float16MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<Float16MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float16MatrixMember, Float16MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float16MatrixMember, Float16MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float16MatrixMember, Float16MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float16Member, Float16MatrixMember, Float16MatrixMember> within() {
        return this.WITHIN;
    }
}

