/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float16.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.CrossProduct;
import nom.bdezonia.zorbage.algorithm.DotProduct;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.PerpDotProduct;
import nom.bdezonia.zorbage.algorithm.RModuleAdd;
import nom.bdezonia.zorbage.algorithm.RModuleAssign;
import nom.bdezonia.zorbage.algorithm.RModuleDefaultNorm;
import nom.bdezonia.zorbage.algorithm.RModuleDirectProduct;
import nom.bdezonia.zorbage.algorithm.RModuleEqual;
import nom.bdezonia.zorbage.algorithm.RModuleNegate;
import nom.bdezonia.zorbage.algorithm.RModuleRound;
import nom.bdezonia.zorbage.algorithm.RModuleScale;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByDouble;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByRational;
import nom.bdezonia.zorbage.algorithm.RModuleSubtract;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Products;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.VectorSpace;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Algebra;
import nom.bdezonia.zorbage.type.data.float16.real.Float16MatrixMember;
import nom.bdezonia.zorbage.type.data.float16.real.Float16Member;
import nom.bdezonia.zorbage.type.data.float16.real.Float16VectorMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float16Vector
implements VectorSpace<Float16Vector, Float16VectorMember, Float16Algebra, Float16Member>,
Constructible1dLong<Float16VectorMember>,
Norm<Float16VectorMember, Float16Member>,
Products<Float16VectorMember, Float16Member, Float16MatrixMember>,
DirectProduct<Float16VectorMember, Float16MatrixMember>,
Rounding<Float16Member, Float16VectorMember>,
Infinite<Float16VectorMember>,
NaN<Float16VectorMember>,
ScaleByHighPrec<Float16VectorMember>,
ScaleByRational<Float16VectorMember>,
ScaleByDouble<Float16VectorMember>,
Tolerance<Float16Member, Float16VectorMember> {
    private final Procedure1<Float16VectorMember> ZER = new Procedure1<Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float16VectorMember, Float16VectorMember> NEG = new Procedure2<Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b) {
            RModuleNegate.compute(G.HLF, a, b);
        }
    };
    private final Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember> ADD = new Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b, Float16VectorMember c) {
            RModuleAdd.compute(G.HLF, a, b, c);
        }
    };
    private final Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember> SUB = new Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b, Float16VectorMember c) {
            RModuleSubtract.compute(G.HLF, a, b, c);
        }
    };
    private final Function2<Boolean, Float16VectorMember, Float16VectorMember> EQ = new Function2<Boolean, Float16VectorMember, Float16VectorMember>(){

        @Override
        public Boolean call(Float16VectorMember a, Float16VectorMember b) {
            return RModuleEqual.compute(G.HLF, a, b);
        }
    };
    private final Function2<Boolean, Float16VectorMember, Float16VectorMember> NEQ = new Function2<Boolean, Float16VectorMember, Float16VectorMember>(){

        @Override
        public Boolean call(Float16VectorMember a, Float16VectorMember b) {
            return Float16Vector.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float16VectorMember, Float16VectorMember> ASSIGN = new Procedure2<Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember from, Float16VectorMember to) {
            RModuleAssign.compute(G.HLF, from, to);
        }
    };
    private Procedure2<Float16VectorMember, Float16Member> NORM = new Procedure2<Float16VectorMember, Float16Member>(){

        @Override
        public void call(Float16VectorMember a, Float16Member b) {
            RModuleDefaultNorm.compute(G.HLF, G.HLF, a, b);
        }
    };
    private final Procedure3<Float16Member, Float16VectorMember, Float16VectorMember> SCALE = new Procedure3<Float16Member, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Float16Member scalar, Float16VectorMember a, Float16VectorMember b) {
            RModuleScale.compute(G.HLF, scalar, a, b);
        }
    };
    private final Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember> CROSS = new Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b, Float16VectorMember c) {
            CrossProduct.compute(G.HLF_VEC, G.HLF, a, b, c);
        }
    };
    private final Procedure3<Float16VectorMember, Float16VectorMember, Float16Member> DOT = new Procedure3<Float16VectorMember, Float16VectorMember, Float16Member>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b, Float16Member c) {
            DotProduct.compute(G.HLF_VEC, G.HLF, G.HLF, a, b, c);
        }
    };
    private final Procedure3<Float16VectorMember, Float16VectorMember, Float16Member> PERP = new Procedure3<Float16VectorMember, Float16VectorMember, Float16Member>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b, Float16Member c) {
            PerpDotProduct.compute(G.HLF_VEC, G.HLF, a, b, c);
        }
    };
    private final Procedure4<Float16VectorMember, Float16VectorMember, Float16VectorMember, Float16VectorMember> VTRIPLE = new Procedure4<Float16VectorMember, Float16VectorMember, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b, Float16VectorMember c, Float16VectorMember d) {
            Float16VectorMember b_cross_c = new Float16VectorMember(new float[3]);
            Float16Vector.this.crossProduct().call(b, c, b_cross_c);
            Float16Vector.this.crossProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure4<Float16VectorMember, Float16VectorMember, Float16VectorMember, Float16Member> STRIPLE = new Procedure4<Float16VectorMember, Float16VectorMember, Float16VectorMember, Float16Member>(){

        @Override
        public void call(Float16VectorMember a, Float16VectorMember b, Float16VectorMember c, Float16Member d) {
            Float16VectorMember b_cross_c = new Float16VectorMember(new float[3]);
            Float16Vector.this.crossProduct().call(b, c, b_cross_c);
            Float16Vector.this.dotProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure3<Float16VectorMember, Float16VectorMember, Float16MatrixMember> VDP = new Procedure3<Float16VectorMember, Float16VectorMember, Float16MatrixMember>(){

        @Override
        public void call(Float16VectorMember in1, Float16VectorMember in2, Float16MatrixMember out) {
            Float16Vector.this.directProduct().call(in1, in2, out);
        }
    };
    private final Procedure3<Float16VectorMember, Float16VectorMember, Float16MatrixMember> DP = new Procedure3<Float16VectorMember, Float16VectorMember, Float16MatrixMember>(){

        @Override
        public void call(Float16VectorMember in1, Float16VectorMember in2, Float16MatrixMember out) {
            RModuleDirectProduct.compute(G.HLF, in1, in2, out);
        }
    };
    private final Function1<Boolean, Float16VectorMember> ISNAN = new Function1<Boolean, Float16VectorMember>(){

        @Override
        public Boolean call(Float16VectorMember a) {
            return SequenceIsNan.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure1<Float16VectorMember> NAN = new Procedure1<Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a) {
            FillNaN.compute(G.HLF, a);
        }
    };
    private final Function1<Boolean, Float16VectorMember> ISINF = new Function1<Boolean, Float16VectorMember>(){

        @Override
        public Boolean call(Float16VectorMember a) {
            return SequenceIsInf.compute(G.HLF, a.rawData());
        }
    };
    private final Procedure1<Float16VectorMember> INF = new Procedure1<Float16VectorMember>(){

        @Override
        public void call(Float16VectorMember a) {
            FillInfinite.compute(G.HLF, a);
        }
    };
    private final Procedure4<Round.Mode, Float16Member, Float16VectorMember, Float16VectorMember> ROUND = new Procedure4<Round.Mode, Float16Member, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Round.Mode mode, Float16Member delta, Float16VectorMember a, Float16VectorMember b) {
            RModuleRound.compute(G.HLF, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float16VectorMember> ISZERO = new Function1<Boolean, Float16VectorMember>(){

        @Override
        public Boolean call(Float16VectorMember a) {
            return SequenceIsZero.compute(G.HLF, a.rawData());
        }
    };
    private Procedure3<HighPrecisionMember, Float16VectorMember, Float16VectorMember> SBHP = new Procedure3<HighPrecisionMember, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(HighPrecisionMember a, Float16VectorMember b, Float16VectorMember c) {
            RModuleScaleByHighPrec.compute(G.HLF, a, b, c);
        }
    };
    private Procedure3<RationalMember, Float16VectorMember, Float16VectorMember> SBR = new Procedure3<RationalMember, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(RationalMember a, Float16VectorMember b, Float16VectorMember c) {
            RModuleScaleByRational.compute(G.HLF, a, b, c);
        }
    };
    private Procedure3<Double, Float16VectorMember, Float16VectorMember> SBD = new Procedure3<Double, Float16VectorMember, Float16VectorMember>(){

        @Override
        public void call(Double a, Float16VectorMember b, Float16VectorMember c) {
            RModuleScaleByDouble.compute(G.HLF, a, b, c);
        }
    };
    private final Function3<Boolean, Float16Member, Float16VectorMember, Float16VectorMember> WITHIN = new Function3<Boolean, Float16Member, Float16VectorMember, Float16VectorMember>(){

        @Override
        public Boolean call(Float16Member tol, Float16VectorMember a, Float16VectorMember b) {
            return SequencesSimilar.compute(G.HLF, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure1<Float16VectorMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float16VectorMember, Float16VectorMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, Float16VectorMember, Float16VectorMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float16VectorMember, Float16VectorMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Float16VectorMember construct() {
        return new Float16VectorMember();
    }

    @Override
    public Float16VectorMember construct(Float16VectorMember other) {
        return new Float16VectorMember(other);
    }

    @Override
    public Float16VectorMember construct(String s) {
        return new Float16VectorMember(s);
    }

    @Override
    public Float16VectorMember construct(StorageConstruction s, long d1) {
        return new Float16VectorMember(s, d1);
    }

    @Override
    public Procedure2<Float16VectorMember, Float16VectorMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<Float16VectorMember, Float16Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure3<Float16Member, Float16VectorMember, Float16VectorMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<Float16VectorMember, Float16VectorMember, Float16VectorMember> crossProduct() {
        return this.CROSS;
    }

    @Override
    public Procedure3<Float16VectorMember, Float16VectorMember, Float16Member> dotProduct() {
        return this.DOT;
    }

    @Override
    public Procedure3<Float16VectorMember, Float16VectorMember, Float16Member> perpDotProduct() {
        return this.PERP;
    }

    @Override
    public Procedure4<Float16VectorMember, Float16VectorMember, Float16VectorMember, Float16VectorMember> vectorTripleProduct() {
        return this.VTRIPLE;
    }

    @Override
    public Procedure4<Float16VectorMember, Float16VectorMember, Float16VectorMember, Float16Member> scalarTripleProduct() {
        return this.STRIPLE;
    }

    @Override
    public Procedure2<Float16VectorMember, Float16VectorMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float16VectorMember, Float16VectorMember, Float16MatrixMember> vectorDirectProduct() {
        return this.VDP;
    }

    @Override
    public Procedure3<Float16VectorMember, Float16VectorMember, Float16MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Function1<Boolean, Float16VectorMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float16VectorMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float16VectorMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float16VectorMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float16Member, Float16VectorMember, Float16VectorMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float16VectorMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float16VectorMember, Float16VectorMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float16VectorMember, Float16VectorMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float16VectorMember, Float16VectorMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float16Member, Float16VectorMember, Float16VectorMember> within() {
        return this.WITHIN;
    }
}

