/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32Algebra;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat32CartesianTensorProduct
implements TensorProduct<ComplexFloat32CartesianTensorProduct, ComplexFloat32CartesianTensorProductMember, ComplexFloat32Algebra, ComplexFloat32Member>,
ConstructibleNdLong<ComplexFloat32CartesianTensorProductMember>,
Norm<ComplexFloat32CartesianTensorProductMember, Float32Member>,
Scale<ComplexFloat32CartesianTensorProductMember, ComplexFloat32Member>,
Rounding<Float32Member, ComplexFloat32CartesianTensorProductMember>,
Infinite<ComplexFloat32CartesianTensorProductMember>,
NaN<ComplexFloat32CartesianTensorProductMember>,
ScaleByHighPrec<ComplexFloat32CartesianTensorProductMember>,
ScaleByRational<ComplexFloat32CartesianTensorProductMember>,
ScaleByDouble<ComplexFloat32CartesianTensorProductMember>,
Tolerance<Float32Member, ComplexFloat32CartesianTensorProductMember> {
    private final Function2<Boolean, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> EQ = new Function2<Boolean, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CFLT, G.FLT.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> NEQ = new Function2<Boolean, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            return ComplexFloat32CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> ASSIGN = new Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember from, ComplexFloat32CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.CFLT, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<ComplexFloat32CartesianTensorProductMember> ZER = new Procedure1<ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> NEG = new Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CFLT, G.CFLT.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> ADDEL = new Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b, ComplexFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CFLT, G.CFLT.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> SUBEL = new Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b, ComplexFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CFLT, G.CFLT.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<ComplexFloat32CartesianTensorProductMember, Float32Member> NORM = new Procedure2<ComplexFloat32CartesianTensorProductMember, Float32Member>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, Float32Member b) {
            TensorNorm.compute(G.CFLT, G.FLT, a.rawData(), b);
        }
    };
    private final Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> CONJ = new Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CFLT, G.CFLT.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> SCALE = new Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32Member scalar, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.CFLT, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> ADDSCALAR = new Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32Member scalar, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.CFLT, scalar, G.CFLT.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> SUBSCALAR = new Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32Member scalar, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            ComplexFloat32Member tmp = G.CFLT.construct();
            G.CFLT.negate().call(scalar, tmp);
            ComplexFloat32CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> MULEL = new Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b, ComplexFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CFLT, G.CFLT.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> DIVIDEEL = new Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b, ComplexFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CFLT, G.CFLT.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> MUL = new Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b, ComplexFloat32CartesianTensorProductMember c) {
            ComplexFloat32CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorContract.compute(G.CFLT, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> SEMI = new Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.CFLT_TEN, G.CFLT, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> COMMA = new Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.CFLT_TEN, G.CFLT, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> POWER = new Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorPower.compute(G.CFLT_TEN, power, a, b);
        }
    };
    private final Procedure1<ComplexFloat32CartesianTensorProductMember> UNITY = new Procedure1<ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember result) {
            TensorUnity.compute(G.CFLT_TEN, G.CFLT, result);
        }
    };
    private final Function1<Boolean, ComplexFloat32CartesianTensorProductMember> ISNAN = new Function1<Boolean, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat32CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat32CartesianTensorProductMember> NAN = new Procedure1<ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a) {
            FillNaN.compute(G.CFLT, a);
        }
    };
    private final Function1<Boolean, ComplexFloat32CartesianTensorProductMember> ISINF = new Function1<Boolean, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat32CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat32CartesianTensorProductMember> INF = new Procedure1<ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a) {
            FillInfinite.compute(G.CFLT, a);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorRound.compute(G.CFLT_TEN, G.CFLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat32CartesianTensorProductMember> ISZERO = new Function1<Boolean, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat32CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure3<RationalMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> SBR = new Procedure3<RationalMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.CFLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> SBD = new Procedure3<Double, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.CFLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.CFLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32Member tol, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CFLT, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> MULBYSCALAR = new Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32Member factor, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            ComplexFloat32CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32Member factor, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            ComplexFloat32Member invFactor = G.CFLT.construct();
            G.CFLT.invert().call(factor, invFactor);
            ComplexFloat32CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> RAISE = new Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> LOWER = new Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            ComplexFloat32CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b, ComplexFloat32CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            ComplexFloat32CartesianTensorProductMember tmp = ComplexFloat32CartesianTensorProduct.this.construct();
            ComplexFloat32CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            ComplexFloat32CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> OUTER = new Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat32CartesianTensorProductMember a, ComplexFloat32CartesianTensorProductMember b, ComplexFloat32CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.CFLT_TEN, G.CFLT, a, b, c);
        }
    };

    @Override
    public ComplexFloat32CartesianTensorProductMember construct() {
        return new ComplexFloat32CartesianTensorProductMember();
    }

    @Override
    public ComplexFloat32CartesianTensorProductMember construct(ComplexFloat32CartesianTensorProductMember other) {
        return new ComplexFloat32CartesianTensorProductMember(other);
    }

    @Override
    public ComplexFloat32CartesianTensorProductMember construct(String s) {
        return new ComplexFloat32CartesianTensorProductMember(s);
    }

    @Override
    public ComplexFloat32CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new ComplexFloat32CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<ComplexFloat32CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<ComplexFloat32CartesianTensorProductMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexFloat32CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, ComplexFloat32CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat32CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat32CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat32CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat32CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat32Member, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember, ComplexFloat32CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

