/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32Algebra;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32MatrixMember;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat32Matrix
implements RingWithUnity<ComplexFloat32Matrix, ComplexFloat32MatrixMember>,
MatrixRing<ComplexFloat32Matrix, ComplexFloat32MatrixMember, ComplexFloat32Algebra, ComplexFloat32Member>,
Constructible2dLong<ComplexFloat32MatrixMember>,
Rounding<Float32Member, ComplexFloat32MatrixMember>,
Norm<ComplexFloat32MatrixMember, Float32Member>,
DirectProduct<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>,
Exponential<ComplexFloat32MatrixMember>,
Trigonometric<ComplexFloat32MatrixMember>,
Hyperbolic<ComplexFloat32MatrixMember>,
RealConstants<ComplexFloat32MatrixMember>,
Infinite<ComplexFloat32MatrixMember>,
NaN<ComplexFloat32MatrixMember>,
ScaleByHighPrec<ComplexFloat32MatrixMember>,
ScaleByRational<ComplexFloat32MatrixMember>,
ScaleByDouble<ComplexFloat32MatrixMember>,
Tolerance<Float32Member, ComplexFloat32MatrixMember> {
    private final Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> MUL = new Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            MatrixMultiply.compute(G.CFLT, a, b, c);
        }
    };
    private final Procedure3<Integer, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> POWER = new Procedure3<Integer, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(Integer power, ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            MatrixPower.compute(power, G.CFLT, G.CFLT_VEC, G.CFLT_MAT, a, b);
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> ZER = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> NEG = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            MatrixNegate.compute(G.CFLT, a, b);
        }
    };
    private final Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> ADD = new Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            MatrixAddition.compute(G.CFLT, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SUB = new Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            MatrixSubtraction.compute(G.CFLT, a, b, c);
        }
    };
    private final Function2<Boolean, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> EQ = new Function2<Boolean, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            return MatrixEqual.compute(G.CFLT, a, b);
        }
    };
    private final Function2<Boolean, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> NEQ = new Function2<Boolean, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            return ComplexFloat32Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> ASSIGN = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember from, ComplexFloat32MatrixMember to) {
            MatrixAssign.compute(G.CFLT, from, to);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, Float32Member> NORM = new Procedure2<ComplexFloat32MatrixMember, Float32Member>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, Float32Member b) {
            MatrixSpectralNorm.compute(G.CFLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> ROUND = new Procedure4<Round.Mode, Float32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            MatrixRound.compute(G.CFLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat32MatrixMember> ISNAN = new Function1<Boolean, ComplexFloat32MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat32MatrixMember a) {
            return SequenceIsNan.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> NAN = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            FillNaN.compute(G.CFLT, a);
        }
    };
    private final Function1<Boolean, ComplexFloat32MatrixMember> ISINF = new Function1<Boolean, ComplexFloat32MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat32MatrixMember a) {
            return SequenceIsInf.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> INF = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            FillInfinite.compute(G.CFLT, a);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> CONJ = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            MatrixConjugate.compute(G.CFLT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> TRANSP = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            MatrixTranspose.compute(G.CFLT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> CONJTRANSP = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            ComplexFloat32MatrixMember tmp = new ComplexFloat32MatrixMember();
            ComplexFloat32Matrix.this.conjugate().call(a, tmp);
            ComplexFloat32Matrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32Member> DET = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32Member>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32Member b) {
            MatrixDeterminant.compute(G.CFLT_MAT, G.CFLT, a, b);
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> UNITY = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            MatrixUnity.compute(G.CFLT, a);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> INV = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            MatrixInvert.compute(G.CFLT, G.CFLT_VEC, G.CFLT_MAT, a, b);
        }
    };
    private final Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> DIVIDE = new Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            ComplexFloat32MatrixMember invB = ComplexFloat32Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            ComplexFloat32Matrix.this.invert().call(b, invB);
            ComplexFloat32Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> DP = new Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember in1, ComplexFloat32MatrixMember in2, ComplexFloat32MatrixMember out) {
            MatrixDirectProduct.compute(G.CFLT, in1, in2, out);
        }
    };
    private final Procedure3<ComplexFloat32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SCALE = new Procedure3<ComplexFloat32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32Member a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            MatrixScale.compute(G.CFLT, a, b, c);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SINH = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.CFLT_MAT, G.CFLT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> COSH = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.CFLT_MAT, G.CFLT, a, b);
        }
    };
    private final Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SINHANDCOSH = new Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember s, ComplexFloat32MatrixMember c) {
            ComplexFloat32Matrix.this.sinh().call(a, s);
            ComplexFloat32Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> TANH = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            ComplexFloat32MatrixMember s = G.CFLT_MAT.construct();
            ComplexFloat32MatrixMember c = G.CFLT_MAT.construct();
            ComplexFloat32Matrix.this.sinhAndCosh().call(a, s, c);
            ComplexFloat32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SINCH = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            Sinch.compute(G.CFLT_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SINCHPI = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            Sinchpi.compute(G.CFLT_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SIN = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            TaylorEstimateSin.compute(18, G.CFLT_MAT, G.CFLT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> COS = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            TaylorEstimateCos.compute(18, G.CFLT_MAT, G.CFLT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> TAN = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            ComplexFloat32MatrixMember s = G.CFLT_MAT.construct();
            ComplexFloat32MatrixMember c = G.CFLT_MAT.construct();
            ComplexFloat32Matrix.this.sinAndCos().call(a, s, c);
            ComplexFloat32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SINANDCOS = new Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember s, ComplexFloat32MatrixMember c) {
            ComplexFloat32Matrix.this.sin().call(a, s);
            ComplexFloat32Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SINC = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            Sinc.compute(G.CFLT_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SINCPI = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            Sincpi.compute(G.CFLT_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> EXP = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            TaylorEstimateExp.compute(35, G.CFLT_MAT, G.CFLT, a, b);
        }
    };
    private final Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> LOG = new Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            TaylorEstimateLog.compute(8, G.CFLT_MAT, G.CFLT, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat32MatrixMember> ISZERO = new Function1<Boolean, ComplexFloat32MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat32MatrixMember a) {
            return SequenceIsZero.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> PI = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            ComplexFloat32Member pi = G.CFLT.construct();
            G.CFLT.PI().call(pi);
            MatrixConstantDiagonal.compute(G.CFLT, pi, a);
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> E = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            ComplexFloat32Member e = G.CFLT.construct();
            G.CFLT.E().call(e);
            MatrixConstantDiagonal.compute(G.CFLT, e, a);
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> PHI = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            ComplexFloat32Member phi = G.CFLT.construct();
            G.CFLT.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.CFLT, phi, a);
        }
    };
    private final Procedure1<ComplexFloat32MatrixMember> GAMMA = new Procedure1<ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32MatrixMember a) {
            ComplexFloat32Member gamma = G.CFLT.construct();
            G.CFLT.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.CFLT, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.CFLT, a, b, c);
        }
    };
    private Procedure3<RationalMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SBR = new Procedure3<RationalMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(RationalMember a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            MatrixScaleByRational.compute(G.CFLT, a, b, c);
        }
    };
    private Procedure3<Double, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> SBD = new Procedure3<Double, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(Double a, ComplexFloat32MatrixMember b, ComplexFloat32MatrixMember c) {
            MatrixScaleByDouble.compute(G.CFLT, a, b, c);
        }
    };
    private final Function3<Boolean, Float32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> WITHIN = new Function3<Boolean, Float32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember>(){

        @Override
        public Boolean call(Float32Member tol, ComplexFloat32MatrixMember a, ComplexFloat32MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.CFLT, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public ComplexFloat32MatrixMember construct() {
        return new ComplexFloat32MatrixMember();
    }

    @Override
    public ComplexFloat32MatrixMember construct(ComplexFloat32MatrixMember other) {
        return new ComplexFloat32MatrixMember(other);
    }

    @Override
    public ComplexFloat32MatrixMember construct(String s) {
        return new ComplexFloat32MatrixMember(s);
    }

    @Override
    public ComplexFloat32MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new ComplexFloat32MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat32MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat32MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<ComplexFloat32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, ComplexFloat32MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<ComplexFloat32MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float32Member, ComplexFloat32MatrixMember, ComplexFloat32MatrixMember> within() {
        return this.WITHIN;
    }
}

